/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.router;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2dl.AbstractRouter;
import org.eclipse.draw2dl.Bendpoint;
import org.eclipse.draw2dl.Connection;
import org.eclipse.draw2dl.FigureListener;
import org.eclipse.draw2dl.IFigure;
import org.eclipse.draw2dl.LayoutListener;
import org.eclipse.draw2dl.geometry.Point;
import org.eclipse.draw2dl.geometry.PointList;
import org.eclipse.draw2dl.geometry.PrecisionPoint;
import org.eclipse.draw2dl.geometry.Rectangle;
import org.eclipse.draw2dl.geometry.Translatable;
import org.jkiss.dbeaver.erd.ui.router.MikamiTabuchiRouter;
import org.jkiss.dbeaver.erd.ui.router.OrthogonalPath;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class MikamiTabuchiConnectionRouter
extends AbstractRouter {
    private boolean isDirty = false;
    private final IFigure container;
    private final Map<Connection, Object> constraintMap = new HashMap<Connection, Object>();
    private final Map<IFigure, Rectangle> figuresToBounds = new HashMap<IFigure, Rectangle>();
    private final Map<Connection, OrthogonalPath> connectionToPath = new HashMap<Connection, OrthogonalPath>();
    private final MikamiTabuchiRouter algorithm = new MikamiTabuchiRouter();
    private final Set<Connection> staleConnections = new HashSet<Connection>();
    private boolean ignoreInvalidate;
    private final LayoutListener listener = new LayoutTracker();
    private final FigureListener figureListener = source -> {
        Rectangle newBounds = source.getBounds().getCopy();
        if (this.algorithm.updateObstacle(this.figuresToBounds.get(source), newBounds)) {
            this.queueRerouting();
            this.isDirty = true;
        }
        this.figuresToBounds.put(source, newBounds);
    };

    public MikamiTabuchiConnectionRouter(IFigure container) {
        this.container = container;
    }

    public Object getConstraint(Connection connection) {
        return this.constraintMap.get(connection);
    }

    public void invalidate(Connection connection) {
        if (!this.ignoreInvalidate) {
            this.staleConnections.add(connection);
            this.isDirty = true;
            if (this.connectionToPath.get(connection) != null) {
                this.connectionToPath.get(connection).setDirty(true);
            }
        }
    }

    private void queueRerouting() {
        if (!this.connectionToPath.isEmpty()) {
            try {
                this.ignoreInvalidate = true;
                this.connectionToPath.keySet().iterator().next().revalidate();
                this.connectionToPath.values().forEach(it -> it.setDirty(true));
            }
            finally {
                this.ignoreInvalidate = false;
            }
        }
    }

    void addChild(IFigure child) {
        if (!this.figuresToBounds.containsKey(child)) {
            Rectangle bounds = child.getBounds().getCopy();
            this.algorithm.addObstacle(bounds);
            this.figuresToBounds.put(child, bounds);
            child.addFigureListener(this.figureListener);
            this.isDirty = true;
        }
    }

    private void processStaleConnections() {
        Iterator<Connection> iter = this.staleConnections.iterator();
        if (iter.hasNext()) {
            this.hookAll();
        }
        while (iter.hasNext()) {
            Connection conn = iter.next();
            OrthogonalPath path = this.connectionToPath.get(conn);
            if (path == null) {
                path = new OrthogonalPath(conn);
                this.connectionToPath.put(conn, path);
                this.algorithm.addPath(path);
            }
            List constraint = CommonUtils.safeList((List)((List)this.getConstraint(conn)));
            Point start = conn.getSourceAnchor().getReferencePoint().getCopy();
            Point end = conn.getTargetAnchor().getReferencePoint().getCopy();
            this.container.translateToRelative((Translatable)start);
            this.container.translateToRelative((Translatable)end);
            path.setStartPoint(start);
            path.setEndPoint(end);
            if (constraint.isEmpty()) {
                path.setBendpoints(null);
            } else {
                PointList bends = new PointList(constraint.size());
                for (Object o : constraint) {
                    Bendpoint bp = (Bendpoint)o;
                    bends.addPoint(bp.getLocation());
                }
                path.setBendpoints(bends);
            }
            this.isDirty |= path.isDirty();
        }
        this.staleConnections.clear();
    }

    private void hookAll() {
        this.figuresToBounds.clear();
        int i = 0;
        while (i < this.container.getChildren().size()) {
            this.addChild((IFigure)this.container.getChildren().get(i));
            ++i;
        }
        this.container.addLayoutListener(this.listener);
    }

    public void route(Connection connection) {
        if (!this.isDirty) {
            return;
        }
        this.ignoreInvalidate = true;
        this.processStaleConnections();
        this.isDirty = false;
        this.algorithm.setClientArea(this.container);
        UIUtils.asyncExec(() -> {
            List<OrthogonalPath> updated = this.algorithm.solve();
            for (OrthogonalPath path : updated) {
                if (path == null || path.getPoints() == null) continue;
                Connection current = path.getConnection();
                current.revalidate();
                PointList points = path.getPoints().getCopy();
                PrecisionPoint ref1 = new PrecisionPoint(points.getPoint(1));
                PrecisionPoint ref2 = new PrecisionPoint(points.getPoint(points.size() - 2));
                current.translateToAbsolute((Translatable)ref1);
                current.translateToAbsolute((Translatable)ref2);
                Point start = current.getSourceAnchor().getLocation((Point)ref1).getCopy();
                Point end = current.getTargetAnchor().getLocation((Point)ref2).getCopy();
                current.translateToRelative((Translatable)start);
                current.translateToRelative((Translatable)end);
                points.setPoint(start, 0);
                points.setPoint(end, points.size() - 1);
                current.setPoints(points);
            }
            this.ignoreInvalidate = false;
        });
    }

    private void unhookAll() {
        this.container.removeLayoutListener(this.listener);
        if (!this.figuresToBounds.isEmpty()) {
            Iterator<IFigure> figureItr = this.figuresToBounds.keySet().iterator();
            while (figureItr.hasNext()) {
                IFigure child = figureItr.next();
                figureItr.remove();
                this.removeChild(child);
            }
            this.figuresToBounds.clear();
        }
    }

    public void remove(Connection connection) {
        this.staleConnections.remove(connection);
        this.constraintMap.remove(connection);
        OrthogonalPath path = this.connectionToPath.remove(connection);
        this.algorithm.removePath(path);
        this.isDirty = true;
        if (this.connectionToPath.isEmpty()) {
            this.unhookAll();
            this.connectionToPath.clear();
        } else {
            this.queueRerouting();
        }
    }

    void removeChild(IFigure child) {
        Rectangle bounds = child.getBounds().getCopy();
        boolean change = this.algorithm.removeObstacle(bounds);
        this.figuresToBounds.remove(child);
        child.removeFigureListener(this.figureListener);
        if (change) {
            this.isDirty = true;
            this.queueRerouting();
        }
    }

    public void setSpacing(int spacing) {
        this.algorithm.setSpacing(spacing);
    }

    public boolean hasMoreConnections() {
        return !this.connectionToPath.isEmpty();
    }

    public IFigure getContainer() {
        return this.container;
    }

    public void setIgnoreInvalidate(boolean b) {
        this.ignoreInvalidate = b;
    }

    public boolean shouldIgnoreInvalidate() {
        return this.ignoreInvalidate;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public boolean containsConnection(Connection conn) {
        return this.connectionToPath.containsKey(conn);
    }

    public void setConstraint(Connection connection, Object constraint) {
        this.staleConnections.add(connection);
        this.constraintMap.put(connection, constraint);
        this.isDirty = true;
    }

    private void processLayout() {
        if (!this.staleConnections.isEmpty()) {
            this.staleConnections.iterator().next().revalidate();
        }
    }

    private class LayoutTracker
    extends LayoutListener.Stub {
        private LayoutTracker() {
        }

        public void postLayout(IFigure container) {
            MikamiTabuchiConnectionRouter.this.processLayout();
        }

        public void remove(IFigure child) {
            MikamiTabuchiConnectionRouter.this.removeChild(child);
        }

        public void setConstraint(IFigure child, Object constraint) {
            MikamiTabuchiConnectionRouter.this.addChild(child);
        }
    }
}

