/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.model;

import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSource;
import org.jkiss.dbeaver.model.access.DBAPrivilege;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class MySQLPrivilege
implements DBAPrivilege {
    private static final Log log = Log.getLog(MySQLPrivilege.class);
    public static final String GRANT_PRIVILEGE = "Grant Option";
    public static final String ALL_PRIVILEGES = "All Privileges";
    public static final Map<String, String> BAD_PRIV_NAME_MAP = new HashMap<String, String>();
    private final MySQLDataSource dataSource;
    private final String name;
    private final String context;
    private final String comment;
    private final Kind kind;

    static {
        BAD_PRIV_NAME_MAP.put("Delete versioning rows", "Delete history");
    }

    public MySQLPrivilege(MySQLDataSource dataSource, ResultSet resultSet) {
        this.dataSource = dataSource;
        this.name = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"privilege");
        this.context = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"context");
        this.comment = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"comment");
        this.kind = this.context.contains("Admin") || this.context.contains("server") ? Kind.ADMIN : (this.context.contains("Databases") ? Kind.DDL : (this.context.contains("Tables") ? Kind.OBJECTS : Kind.MISC));
    }

    public MySQLPrivilege(MySQLDataSource dataSource, String name, String context, String comment, Kind kind) {
        this.dataSource = dataSource;
        this.name = name;
        this.context = context;
        this.comment = comment;
        this.kind = kind;
    }

    public Kind getKind() {
        return this.kind;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    public String getFixedPrivilegeName() {
        String fixedName = BAD_PRIV_NAME_MAP.get(this.name);
        if (fixedName != null) {
            return fixedName;
        }
        return this.name;
    }

    @Property(viewable=true, order=2)
    public String getContext() {
        return this.context;
    }

    @Nullable
    public String getDescription() {
        return this.comment;
    }

    public DBSObject getParentObject() {
        return this.dataSource;
    }

    @NotNull
    public JDBCDataSource getDataSource() {
        return this.dataSource;
    }

    public boolean isPersisted() {
        return true;
    }

    public boolean isGrantOption() {
        return this.name.equalsIgnoreCase(GRANT_PRIVILEGE);
    }

    public String toString() {
        return this.name;
    }

    public static enum Kind {
        OBJECTS,
        DDL,
        ADMIN,
        MISC;

    }
}

