/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.completion.hippie;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.sql.completion.hippie.HippieCompletionEngine;
import org.jkiss.dbeaver.model.text.parser.TPWordDetector;

public final class HippieProposalProcessor {
    private static final String[] NO_PROPOSALS = new String[0];
    private final HippieCompletionEngine fEngine = new HippieCompletionEngine();
    private TPWordDetector wordDetector;

    public HippieProposalProcessor() {
    }

    public HippieProposalProcessor(@NotNull TPWordDetector wordDetector) {
        this.wordDetector = wordDetector;
    }

    public String[] computeCompletionStrings(IDocument document, int offset) {
        try {
            String prefix = this.getPrefix(document, offset);
            if (prefix == null || prefix.isEmpty()) {
                return NO_PROPOSALS;
            }
            ArrayList<String> result = new ArrayList<String>();
            for (String string : this.getSuggestions(document, offset, prefix)) {
                if (string.isEmpty()) continue;
                result.add(String.valueOf(prefix) + string);
            }
            return result.toArray(new String[0]);
        }
        catch (BadLocationException badLocationException) {
            return NO_PROPOSALS;
        }
    }

    private String getPrefix(IDocument document, int offset) throws BadLocationException {
        if (document == null || offset > document.getLength()) {
            return null;
        }
        int length = 0;
        int localOffset = offset;
        char nextChar = document.getChar(localOffset);
        while (Character.isJavaIdentifierPart(nextChar) || this.wordDetector != null && this.wordDetector.isWordPart(nextChar)) {
            ++length;
            if (--localOffset < 0) break;
            nextChar = document.getChar(localOffset);
        }
        return document.get(localOffset + 1, length);
    }

    private ArrayList<String> createSuggestionsFromOpenDocument(IDocument document, int offset, String prefix) {
        ArrayList<String> completions = new ArrayList<String>();
        completions.addAll(this.fEngine.getCompletionsBackwards(document, prefix, offset));
        completions.addAll(this.fEngine.getCompletionsForward(document, prefix, offset - prefix.length(), true));
        return completions;
    }

    private List<String> getSuggestions(IDocument document, int offset, String prefix) throws BadLocationException {
        ArrayList<String> suggestions = this.createSuggestionsFromOpenDocument(document, offset, prefix);
        if (document != null) {
            suggestions.addAll(this.fEngine.getCompletionsForward(document, prefix, 0, false));
        }
        suggestions.add("");
        return this.fEngine.makeUnique(suggestions);
    }

    public String getErrorMessage() {
        return null;
    }
}

