/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.net.ssh.config;

import java.nio.file.Path;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.net.ssh.SSHConstants;

public class SSHAuthConfiguration {
    private final SSHConstants.AuthType type;
    private final String password;
    private final Path keyFile;
    private final String keyValue;
    private final boolean savePassword;

    private SSHAuthConfiguration(@NotNull SSHConstants.AuthType type, @Nullable String password, boolean savePassword) {
        this.type = type;
        this.password = password;
        this.keyFile = null;
        this.keyValue = null;
        this.savePassword = savePassword;
    }

    private SSHAuthConfiguration(@NotNull SSHConstants.AuthType type, @Nullable Path keyFile, @Nullable String password, boolean savePassword) {
        this.type = type;
        this.password = password;
        this.keyFile = keyFile;
        this.keyValue = null;
        this.savePassword = savePassword;
    }

    private SSHAuthConfiguration(@NotNull SSHConstants.AuthType type, @NotNull String keyValue, @Nullable String password, boolean savePassword) {
        this.type = type;
        this.password = password;
        this.keyFile = null;
        this.keyValue = keyValue;
        this.savePassword = savePassword;
    }

    @NotNull
    public static SSHAuthConfiguration usingPassword(@NotNull String password, boolean savePassword) {
        return new SSHAuthConfiguration(SSHConstants.AuthType.PASSWORD, password, savePassword);
    }

    @NotNull
    public static SSHAuthConfiguration usingKey(@NotNull Path key, @Nullable String passphrase, boolean savePassword) {
        return new SSHAuthConfiguration(SSHConstants.AuthType.PUBLIC_KEY, key, passphrase, savePassword);
    }

    @NotNull
    public static SSHAuthConfiguration usingKey(@NotNull String keyValue, @Nullable String passphrase, boolean savePassword) {
        return new SSHAuthConfiguration(SSHConstants.AuthType.PUBLIC_KEY, keyValue, passphrase, savePassword);
    }

    @NotNull
    public static SSHAuthConfiguration usingAgent() {
        return new SSHAuthConfiguration(SSHConstants.AuthType.AGENT, null, false);
    }

    @NotNull
    public SSHConstants.AuthType getType() {
        return this.type;
    }

    @Nullable
    public String getPassword() {
        return this.password;
    }

    @Nullable
    public Path getKeyFile() {
        return this.keyFile;
    }

    @Nullable
    public String getKeyValue() {
        return this.keyValue;
    }

    public boolean isSavePassword() {
        return this.savePassword;
    }
}

