/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef3.ui.palette.customize;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.draw2dl.ColorConstants;
import org.eclipse.gef3.internal.InternalImages;
import org.eclipse.gef3.palette.PaletteContainer;
import org.eclipse.gef3.palette.PaletteEntry;
import org.eclipse.gef3.palette.PaletteSeparator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

class PaletteLabelProvider
implements ILabelProvider,
IColorProvider {
    private Map imageCache = new HashMap();

    public PaletteLabelProvider(TreeViewer viewer) {
    }

    public Color getBackground(Object element) {
        return null;
    }

    private Image getCachedImage(ImageDescriptor descriptor) {
        Image image = (Image)this.imageCache.get(descriptor);
        if (image == null) {
            image = descriptor.createImage();
            this.imageCache.put(descriptor, image);
        }
        return image;
    }

    public Color getForeground(Object element) {
        PaletteEntry entry = (PaletteEntry)element;
        if (!entry.isVisible() || !entry.getParent().isVisible()) {
            return ColorConstants.lineForeground;
        }
        return null;
    }

    public Image getImage(Object element) {
        PaletteEntry entry = (PaletteEntry)element;
        ImageDescriptor descriptor = entry.getSmallIcon();
        if (descriptor == null) {
            if (entry instanceof PaletteContainer) {
                descriptor = InternalImages.DESC_FOLDER_OPEN;
            } else if (entry instanceof PaletteSeparator) {
                descriptor = InternalImages.DESC_SEPARATOR;
            } else {
                return null;
            }
        }
        return this.getCachedImage(descriptor);
    }

    public String getText(Object element) {
        return ((PaletteEntry)element).getLabel();
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        Iterator images = this.imageCache.values().iterator();
        while (images.hasNext()) {
            ((Image)images.next()).dispose();
        }
        this.imageCache = null;
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

