/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.serialize;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.meta.DBSerializable;
import org.jkiss.dbeaver.runtime.serialize.DBPObjectSerializer;
import org.jkiss.dbeaver.runtime.serialize.SerializerDescriptor;

public class SerializerRegistry {
    private static final Log log = Log.getLog(SerializerRegistry.class);
    private static SerializerRegistry instance = null;
    private final Map<String, SerializerDescriptor> serializers = new HashMap<String, SerializerDescriptor>();

    public static synchronized SerializerRegistry getInstance() {
        if (instance == null) {
            instance = new SerializerRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private SerializerRegistry(IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor("org.jkiss.dbeaver.serialize");
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            if ("serializer".equals(ext.getName())) {
                SerializerDescriptor sd = new SerializerDescriptor(ext);
                this.serializers.put(sd.getId(), sd);
            }
            ++n2;
        }
    }

    public boolean isSerializable(Object object) {
        return object.getClass().getAnnotation(DBSerializable.class) != null;
    }

    public String getObjectType(Object object) {
        DBSerializable dbSerializable = object.getClass().getAnnotation(DBSerializable.class);
        return dbSerializable != null ? dbSerializable.value() : null;
    }

    @Nullable
    public DBPObjectSerializer createSerializer(Object object) {
        DBSerializable dbSerializable = object.getClass().getAnnotation(DBSerializable.class);
        if (dbSerializable != null) {
            return this.createSerializerByType(dbSerializable.value());
        }
        return null;
    }

    @Nullable
    public <OBJECT_CONTEXT, OBJECT_TYPE> DBPObjectSerializer<OBJECT_CONTEXT, OBJECT_TYPE> createSerializerByType(String typeID) {
        SerializerDescriptor sd = this.serializers.get(typeID);
        if (sd == null) {
            log.error("Serializer '" + typeID + "' not found");
            return null;
        }
        try {
            return sd.createSerializer();
        }
        catch (Exception e) {
            log.error("Error creating serializer " + sd.getId(), e);
            return null;
        }
    }
}

