/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.navigator.fs;

import java.nio.file.Path;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.fs.DBFVirtualFileSystemRoot;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.navigator.DBNLazyNode;
import org.jkiss.dbeaver.model.navigator.fs.DBNFileSystem;
import org.jkiss.dbeaver.model.navigator.fs.DBNPath;
import org.jkiss.dbeaver.model.navigator.fs.DBNPathBase;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;

public class DBNFileSystemRoot
extends DBNPathBase
implements DBNLazyNode {
    private static final Log log = Log.getLog(DBNFileSystemRoot.class);
    private DBFVirtualFileSystemRoot root;
    private DBNPath[] children;
    private Path path;

    public DBNFileSystemRoot(DBNFileSystem parentNode, DBFVirtualFileSystemRoot root) {
        super(parentNode);
        this.root = root;
    }

    @NotNull
    public DBFVirtualFileSystemRoot getRoot() {
        return this.root;
    }

    @Override
    public boolean isDisposed() {
        return this.root == null || super.isDisposed();
    }

    @Override
    protected void dispose(boolean reflect) {
        this.children = null;
        this.root = null;
        super.dispose(reflect);
    }

    @Override
    public String getNodeType() {
        return "FileSystemRoot";
    }

    @Override
    @Property(id="name", viewable=true, order=1)
    public String getNodeName() {
        return this.root.getName();
    }

    @Override
    public String getNodeDescription() {
        return null;
    }

    @Override
    public DBPImage getNodeIcon() {
        return DBIcon.TREE_FOLDER_INFO;
    }

    @Override
    public boolean allowsChildren() {
        return true;
    }

    @Override
    public Path getPath() {
        if (this.path == null) {
            try {
                this.path = this.root.getRootPath(new VoidProgressMonitor());
            }
            catch (DBException e) {
                log.error(e);
                return Path.of(".nonexistentfolder", new String[0]);
            }
        }
        return this.path;
    }
}

