/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.eula;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ui.eula.EULAConfirmationDialog;
import org.jkiss.dbeaver.ui.eula.EULAInfoDialog;
import org.jkiss.dbeaver.utils.SystemVariablesResolver;
import org.jkiss.utils.IOUtils;

public class EULAUtils {
    private static final Log log = Log.getLog(EULAUtils.class);
    public static final String DBEAVER_EULA = "DBeaver.eula";
    private static final String eulaVersion = "1.0";
    private static final String EULA_PATH = String.valueOf(SystemVariablesResolver.getInstallPath()) + File.separator + "licenses" + File.separator + "dbeaver_license.txt";

    @NotNull
    public static String getEulaVersion() {
        return eulaVersion;
    }

    public static String getPackageEula() {
        String eula;
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (FileReader reader = new FileReader(EULA_PATH);){
                eula = IOUtils.readToString((Reader)reader);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.error((Object)"Error reading End-user license agreement file", (Throwable)e);
            return null;
        }
        return eula;
    }

    public static void showEula(@NotNull Shell shell, boolean needsConfirmation) {
        String eula = EULAUtils.getPackageEula();
        if (needsConfirmation) {
            EULAUtils.showEulaConfirmationDialog(shell, eula);
        } else {
            EULAUtils.showEulaInfoDialog(shell, eula);
        }
    }

    private static void showEulaConfirmationDialog(@NotNull Shell shell, @Nullable String eula) {
        EULAConfirmationDialog eulaDialog = new EULAConfirmationDialog(shell, eula);
        eulaDialog.open();
    }

    private static void showEulaInfoDialog(@NotNull Shell shell, @Nullable String eula) {
        EULAInfoDialog eulaDialog = new EULAInfoDialog(shell, eula);
        eulaDialog.open();
    }
}

