/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.auth;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.auth.AuthPropertyDescriptor;
import org.jkiss.dbeaver.model.auth.SMAuthProvider;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.model.impl.PropertyDescriptor;
import org.jkiss.dbeaver.model.security.SMAuthCredentialsProfile;
import org.jkiss.dbeaver.model.security.SMAuthProviderDescriptor;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class AuthProviderDescriptor
extends AbstractDescriptor {
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.auth.provider";
    private static final Log log = Log.getLog(AuthProviderDescriptor.class);
    private final IConfigurationElement cfg;
    private final AbstractDescriptor.ObjectType implType;
    private SMAuthProvider<?> instance;
    private final DBPImage icon;
    private final Map<String, PropertyDescriptor> configurationParameters = new LinkedHashMap<String, PropertyDescriptor>();
    private final List<SMAuthCredentialsProfile> credentialProfiles = new ArrayList<SMAuthCredentialsProfile>();
    private final boolean configurable;
    private final boolean trusted;
    private final String[] requiredFeatures;

    public AuthProviderDescriptor(IConfigurationElement cfg) {
        super(cfg);
        this.cfg = cfg;
        this.implType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, cfg, "class");
        this.icon = this.iconToImage(cfg.getAttribute("icon"));
        this.configurable = CommonUtils.toBoolean((Object)cfg.getAttribute("configurable"));
        this.trusted = CommonUtils.toBoolean((Object)cfg.getAttribute("trusted"));
        IConfigurationElement[] iConfigurationElementArray = cfg.getChildren("configuration");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement cfgElement = iConfigurationElementArray[n2];
            for (IConfigurationElement propGroup : ArrayUtils.safeArray((Object[])cfgElement.getChildren("propertyGroup"))) {
                IConfigurationElement[] propElements;
                String category = propGroup.getAttribute("label");
                IConfigurationElement[] iConfigurationElementArray2 = propElements = propGroup.getChildren("property");
                int n3 = propElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement prop = iConfigurationElementArray2[n4];
                    PropertyDescriptor propertyDescriptor = new PropertyDescriptor(category, prop);
                    this.configurationParameters.put(CommonUtils.toString((Object)propertyDescriptor.getId()), propertyDescriptor);
                    ++n4;
                }
            }
            ++n2;
        }
        iConfigurationElementArray = cfg.getChildren("credentials");
        n = iConfigurationElementArray.length;
        n2 = 0;
        while (n2 < n) {
            IConfigurationElement credElement = iConfigurationElementArray[n2];
            this.credentialProfiles.add(new SMAuthCredentialsProfile(credElement));
            ++n2;
        }
        String rfList = cfg.getAttribute("requiredFeatures");
        this.requiredFeatures = !CommonUtils.isEmpty((String)rfList) ? rfList.split(",") : null;
    }

    @NotNull
    public String getId() {
        return this.cfg.getAttribute("id");
    }

    public String getLabel() {
        return this.cfg.getAttribute("label");
    }

    public String getDescription() {
        return this.cfg.getAttribute("description");
    }

    public DBPImage getIcon() {
        return this.icon;
    }

    public boolean isConfigurable() {
        return this.configurable;
    }

    public boolean isTrusted() {
        return this.trusted;
    }

    public List<PropertyDescriptor> getConfigurationParameters() {
        return new ArrayList<PropertyDescriptor>(this.configurationParameters.values());
    }

    public List<SMAuthCredentialsProfile> getCredentialProfiles() {
        return new ArrayList<SMAuthCredentialsProfile>(this.credentialProfiles);
    }

    public List<AuthPropertyDescriptor> getCredentialParameters(Set<String> keySet) {
        if (this.credentialProfiles.size() > 1) {
            for (SMAuthCredentialsProfile profile : this.credentialProfiles) {
                if (profile.getCredentialParameters().size() != keySet.size()) continue;
                boolean matches = true;
                for (String paramName : keySet) {
                    if (profile.getCredentialParameter(paramName) != null) continue;
                    matches = false;
                    break;
                }
                if (!matches) continue;
                return profile.getCredentialParameters();
            }
        }
        return this.credentialProfiles.get(0).getCredentialParameters();
    }

    @NotNull
    public SMAuthProvider<?> getInstance() {
        if (this.instance == null) {
            try {
                this.instance = (SMAuthProvider)this.implType.createInstance(SMAuthProvider.class);
            }
            catch (DBException e) {
                throw new IllegalStateException("Can not instantiate auth provider '" + this.implType.getImplName() + "'", e);
            }
        }
        return this.instance;
    }

    public String[] getRequiredFeatures() {
        return this.requiredFeatures;
    }

    public String toString() {
        return this.getId();
    }

    public SMAuthProviderDescriptor createDescriptorBean() {
        SMAuthProviderDescriptor smInfo = new SMAuthProviderDescriptor();
        smInfo.setId(this.getId());
        smInfo.setLabel(this.getLabel());
        smInfo.setDescription(this.getDescription());
        smInfo.setCredentialProfiles(this.getCredentialProfiles());
        if (this.icon != null) {
            smInfo.setIcon(this.icon.getLocation());
        }
        return smInfo;
    }
}

