/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.UUID;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.auth.SMSessionContext;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.task.DBTTaskManager;
import org.jkiss.dbeaver.registry.DataSourceRegistry;
import org.jkiss.dbeaver.registry.task.TaskManagerImpl;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.utils.CommonUtils;

public abstract class BaseProjectImpl
implements DBPProject {
    private static final Log log = Log.getLog(BaseProjectImpl.class);
    public static final String SETTINGS_STORAGE_FILE = "project-settings.json";
    public static final String METADATA_STORAGE_FILE = "project-metadata.json";
    public static final String PROP_PROJECT_ID = "id";
    public static final Gson METADATA_GSON = new GsonBuilder().setLenient().serializeNulls().create();
    private static final byte[] LOCAL_KEY_CACHE = new byte[]{-70, -69, 74, -97, 119, 74, -72, 83, -55, 108, 45, 101, 61, -2, 84, 74};
    @NotNull
    private final DBPWorkspace workspace;
    @NotNull
    private final SMSessionContext sessionContext;
    private volatile ProjectFormat format = ProjectFormat.UNKNOWN;
    private volatile DBPDataSourceRegistry dataSourceRegistry;
    private volatile TaskManagerImpl taskManager;
    private volatile Map<String, Object> properties;
    private volatile Map<String, Map<String, Object>> resourceProperties;
    private UUID projectID;
    protected final Object metadataSync = new Object();
    private ProjectSyncJob metadataSyncJob;
    private boolean inMemory;

    public BaseProjectImpl(@NotNull DBPWorkspace workspace, @Nullable SMSessionContext sessionContext) {
        this.workspace = workspace;
        this.sessionContext = sessionContext == null ? workspace.getAuthContext() : sessionContext;
    }

    public void setInMemory(boolean inMemory) {
        this.inMemory = inMemory;
    }

    public boolean isInMemory() {
        return this.inMemory;
    }

    public String getId() {
        return this.getName();
    }

    @NotNull
    public String getDisplayName() {
        return this.getName();
    }

    @NotNull
    public DBPWorkspace getWorkspace() {
        return this.workspace;
    }

    @NotNull
    public UUID getProjectID() {
        if (this.projectID == null) {
            String idStr = CommonUtils.toString((Object)this.getProjectProperty(PROP_PROJECT_ID), null);
            if (CommonUtils.isEmpty((String)idStr)) {
                this.projectID = UUID.randomUUID();
                this.setProjectProperty(PROP_PROJECT_ID, this.projectID.toString());
            } else {
                this.projectID = UUID.fromString(idStr);
            }
        }
        return this.projectID;
    }

    @Nullable
    public IContainer getRootResource() {
        return this.getEclipseProject();
    }

    @NotNull
    public Path getMetadataFolder(boolean create) {
        Path metadataFolder = this.getMetadataPath();
        if (create && !Files.exists(metadataFolder, new LinkOption[0])) {
            try {
                Files.createDirectories(metadataFolder, new FileAttribute[0]);
            }
            catch (IOException e) {
                log.error((Object)("Error creating metadata folder" + metadataFolder), (Throwable)e);
            }
        }
        return metadataFolder;
    }

    @NotNull
    protected Path getMetadataPath() {
        return this.getAbsolutePath().resolve(".dbeaver");
    }

    public boolean isRegistryLoaded() {
        return this.dataSourceRegistry != null;
    }

    public boolean isEncryptedProject() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public DBPDataSourceRegistry getDataSourceRegistry() {
        this.ensureOpen();
        Object object = this.metadataSync;
        synchronized (object) {
            if (this.dataSourceRegistry == null) {
                this.dataSourceRegistry = this.createDataSourceRegistry();
            }
        }
        return this.dataSourceRegistry;
    }

    @NotNull
    protected DBPDataSourceRegistry createDataSourceRegistry() {
        return new DataSourceRegistry(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public DBTTaskManager getTaskManager() {
        this.ensureOpen();
        if (this.taskManager == null) {
            Object object = this.metadataSync;
            synchronized (object) {
                if (this.taskManager == null) {
                    this.taskManager = new TaskManagerImpl(this);
                }
            }
        }
        return this.taskManager;
    }

    public SecretKey getLocalSecretKey() {
        return new SecretKeySpec(LOCAL_KEY_CACHE, "AES");
    }

    @NotNull
    public SMSessionContext getSessionContext() {
        return this.sessionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProjectProperty(String propName) {
        BaseProjectImpl baseProjectImpl = this;
        synchronized (baseProjectImpl) {
            this.loadProperties();
            return this.properties.get(propName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProjectProperty(String propName, Object propValue) {
        Object object = this.metadataSync;
        synchronized (object) {
            this.loadProperties();
            if (propValue == null) {
                this.properties.remove(propName);
            } else {
                this.properties.put(propName, propValue);
            }
            this.saveProperties();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProperties() {
        if (this.properties != null) {
            return;
        }
        Object object = this.metadataSync;
        synchronized (object) {
            Path settingsFile = this.getMetadataPath().resolve(SETTINGS_STORAGE_FILE);
            if (Files.exists(settingsFile, new LinkOption[0]) && settingsFile.toFile().length() > 0L) {
                try {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (BufferedReader settingsReader = Files.newBufferedReader(settingsFile, StandardCharsets.UTF_8);){
                        this.properties = JSONUtils.parseMap((Gson)METADATA_GSON, (Reader)settingsReader);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Throwable e) {
                    log.error((Object)("Error reading project '" + this.getName() + "' setting from " + settingsFile.toAbsolutePath()), e);
                }
            }
            if (this.properties == null) {
                this.properties = new LinkedHashMap<String, Object>();
            }
        }
    }

    private void saveProperties() {
        if (this.isInMemory()) {
            return;
        }
        Path settingsFile = this.getMetadataPath().resolve(SETTINGS_STORAGE_FILE);
        String settingsString = METADATA_GSON.toJson(this.properties);
        try {
            Path configFolder = settingsFile.getParent();
            if (!Files.exists(configFolder, new LinkOption[0])) {
                Files.createDirectories(configFolder, new FileAttribute[0]);
            }
            Files.writeString(settingsFile, (CharSequence)settingsString, new OpenOption[0]);
        }
        catch (Exception e) {
            log.error((Object)("Error writing project '" + this.getName() + "' setting to " + settingsFile.toAbsolutePath()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public String[] findResources(@NotNull Map<String, ?> properties) throws DBException {
        this.loadMetadata();
        Object object = this.metadataSync;
        synchronized (object) {
            ArrayList<String> resources = new ArrayList<String>();
            for (Map.Entry<String, Map<String, Object>> resource : this.resourceProperties.entrySet()) {
                boolean containsRequiredProperties = true;
                Map<String, Object> props = resource.getValue();
                for (Map.Entry<String, ?> property : properties.entrySet()) {
                    String propName = property.getKey();
                    Object propValue = property.getValue();
                    if (props.containsKey(propName) && Objects.equals(props.get(propName), propValue)) continue;
                    containsRequiredProperties = false;
                    break;
                }
                if (!containsRequiredProperties) continue;
                resources.add(resource.getKey());
            }
            return (String[])resources.toArray(String[]::new);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Object getResourceProperty(@NotNull String resourcePath, @NotNull String propName) {
        this.loadMetadata();
        Object object = this.metadataSync;
        synchronized (object) {
            Map<String, Object> resProps = this.resourceProperties.get(resourcePath);
            if (resProps != null) {
                return resProps.get(propName);
            }
        }
        return null;
    }

    @Nullable
    public Object getResourceProperty(@NotNull IResource resource, @NotNull String propName) {
        return this.getResourceProperty(this.getResourcePath(resource), propName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Map<String, Object> getResourceProperties(@NotNull String resourcePath) {
        this.loadMetadata();
        Object object = this.metadataSync;
        synchronized (object) {
            return this.resourceProperties.get(resourcePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setResourceProperty(@NotNull String resourcePath, @NotNull String propName, @Nullable Object propValue) {
        this.loadMetadata();
        Object object = this.metadataSync;
        synchronized (object) {
            Map<String, Object> resProps = this.resourceProperties.get(resourcePath);
            if (resProps == null) {
                if (propValue == null) {
                    return;
                }
                resProps = new LinkedHashMap<String, Object>();
                this.resourceProperties.put(resourcePath, resProps);
            }
            if (propValue == null) {
                if (resProps.remove(propName) == null) {
                    if (!resProps.isEmpty()) {
                        return;
                    }
                    this.resourceProperties.remove(resourcePath);
                }
            } else {
                Object oldValue = resProps.put(propName, propValue);
                if (Objects.equals(oldValue, propValue)) {
                    return;
                }
            }
        }
        this.flushMetadata();
    }

    public void refreshProject(DBRProgressMonitor monitor) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resetResourceProperties(@NotNull String resourcePath) {
        boolean hadProperties;
        this.loadMetadata();
        Object object = this.metadataSync;
        synchronized (object) {
            hadProperties = this.resourceProperties.remove(resourcePath) != null;
        }
        if (hadProperties) {
            this.flushMetadata();
        }
        return hadProperties;
    }

    @NotNull
    public String getResourcePath(@NotNull IResource resource) {
        return resource.getProjectRelativePath().toString();
    }

    protected void setResourceProperties(Map<String, Map<String, Object>> resourceProperties) {
        this.resourceProperties = resourceProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeResourceFromCache(IPath path) {
        boolean cacheChanged = false;
        Object object = this.metadataSync;
        synchronized (object) {
            if (this.resourceProperties != null) {
                cacheChanged = this.resourceProperties.remove(path.toString()) != null;
            }
        }
        if (cacheChanged) {
            this.flushMetadata();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateResourceCache(IPath oldPath, IPath newPath) {
        boolean cacheChanged = false;
        Object object = this.metadataSync;
        synchronized (object) {
            Map<String, Object> props;
            if (this.resourceProperties != null && (props = this.resourceProperties.remove(oldPath.toString())) != null) {
                this.resourceProperties.put(newPath.toString(), props);
                cacheChanged = true;
            }
        }
        if (cacheChanged) {
            this.flushMetadata();
        }
    }

    public boolean hasRealmPermission(String permission) {
        return true;
    }

    public boolean supportsRealmFeature(String feature) {
        return true;
    }

    public void dispose() {
        if (this.dataSourceRegistry != null) {
            this.dataSourceRegistry.dispose();
        }
    }

    public ProjectFormat getFormat() {
        return this.format;
    }

    protected void setFormat(ProjectFormat format) {
        this.format = format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMetadata() {
        if (this.isInMemory()) {
            return;
        }
        this.ensureOpen();
        Object object = this.metadataSync;
        synchronized (object) {
            if (this.resourceProperties != null) {
                return;
            }
            Path mdFile = this.getMetadataPath().resolve(METADATA_STORAGE_FILE);
            if (Files.exists(mdFile, new LinkOption[0]) && mdFile.toFile().length() > 0L) {
                TreeMap<String, Map<String, Object>> mdCache = new TreeMap<String, Map<String, Object>>();
                try {
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try (BufferedReader mdReader = Files.newBufferedReader(mdFile, StandardCharsets.UTF_8);){
                        Throwable throwable2 = null;
                        Object var8_12 = null;
                        try (JsonReader jsonReader = METADATA_GSON.newJsonReader((Reader)mdReader);){
                            jsonReader.beginObject();
                            while (jsonReader.hasNext()) {
                                String topName = jsonReader.nextName();
                                if (!"resources".equals(topName)) continue;
                                jsonReader.beginObject();
                                while (jsonReader.hasNext()) {
                                    String resourceName = jsonReader.nextName();
                                    HashMap<String, Object> resProperties = new HashMap<String, Object>();
                                    jsonReader.beginObject();
                                    while (jsonReader.hasNext()) {
                                        Object propValue;
                                        String propName = jsonReader.nextName();
                                        switch (jsonReader.peek()) {
                                            case NUMBER: {
                                                propValue = jsonReader.nextDouble();
                                                break;
                                            }
                                            case BOOLEAN: {
                                                propValue = jsonReader.nextBoolean();
                                                break;
                                            }
                                            case NULL: {
                                                propValue = null;
                                                break;
                                            }
                                            default: {
                                                propValue = jsonReader.nextString();
                                            }
                                        }
                                        resProperties.put(propName, propValue);
                                    }
                                    jsonReader.endObject();
                                    if (resProperties.isEmpty()) continue;
                                    mdCache.put(resourceName, resProperties);
                                }
                                jsonReader.endObject();
                            }
                            jsonReader.endObject();
                            this.resourceProperties = mdCache;
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                }
                catch (Throwable e) {
                    log.error((Object)("Error reading project '" + this.getName() + "' metadata from " + mdFile.toAbsolutePath()), e);
                }
            }
            if (this.resourceProperties == null) {
                this.resourceProperties = new TreeMap<String, Map<String, Object>>();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushMetadata() {
        if (this.inMemory) {
            return;
        }
        Object object = this.metadataSync;
        synchronized (object) {
            if (this.metadataSyncJob == null) {
                this.metadataSyncJob = new ProjectSyncJob();
            }
            this.metadataSyncJob.schedule(100L);
        }
    }

    public String toString() {
        return this.getName();
    }

    public static enum ProjectFormat {
        UNKNOWN,
        LEGACY,
        MODERN;

    }

    private class ProjectSyncJob
    extends AbstractJob {
        ProjectSyncJob() {
            super("Project metadata sync");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(DBRProgressMonitor monitor) {
            this.setName("Project '" + BaseProjectImpl.this.getName() + "' sync job");
            ContentUtils.makeFileBackup((Path)BaseProjectImpl.this.getMetadataFolder(false).resolve(BaseProjectImpl.METADATA_STORAGE_FILE));
            Object object = BaseProjectImpl.this.metadataSync;
            synchronized (object) {
                block29: {
                    Path mdFile = BaseProjectImpl.this.getMetadataPath().resolve(BaseProjectImpl.METADATA_STORAGE_FILE);
                    if (CommonUtils.isEmpty(BaseProjectImpl.this.resourceProperties) && !Files.exists(mdFile, new LinkOption[0])) {
                        return Status.OK_STATUS;
                    }
                    try {
                        if (CommonUtils.isEmpty(BaseProjectImpl.this.resourceProperties)) break block29;
                        Throwable throwable = null;
                        Object var5_7 = null;
                        try (BufferedWriter mdWriter = Files.newBufferedWriter(mdFile, StandardCharsets.UTF_8, new OpenOption[0]);){
                            Throwable throwable2 = null;
                            Object var8_12 = null;
                            try (JsonWriter jsonWriter = METADATA_GSON.newJsonWriter((Writer)mdWriter);){
                                jsonWriter.beginObject();
                                jsonWriter.name("resources");
                                jsonWriter.beginObject();
                                for (Map.Entry<String, Map<String, Object>> resEntry : BaseProjectImpl.this.resourceProperties.entrySet()) {
                                    jsonWriter.name(resEntry.getKey());
                                    jsonWriter.beginObject();
                                    Map<String, Object> resProps = resEntry.getValue();
                                    for (Map.Entry<String, Object> propEntry : resProps.entrySet()) {
                                        jsonWriter.name(propEntry.getKey());
                                        Object value = propEntry.getValue();
                                        if (value == null) {
                                            jsonWriter.nullValue();
                                            continue;
                                        }
                                        if (value instanceof Number) {
                                            jsonWriter.value((Number)value);
                                            continue;
                                        }
                                        if (value instanceof Boolean) {
                                            jsonWriter.value((Boolean)value);
                                            continue;
                                        }
                                        jsonWriter.value(CommonUtils.toString((Object)value));
                                    }
                                    jsonWriter.endObject();
                                }
                                jsonWriter.endObject();
                                jsonWriter.endObject();
                                jsonWriter.flush();
                            }
                            catch (Throwable throwable3) {
                                if (throwable2 == null) {
                                    throwable2 = throwable3;
                                } else if (throwable2 != throwable3) {
                                    throwable2.addSuppressed(throwable3);
                                }
                                throw throwable2;
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable == null) {
                                throwable = throwable4;
                            } else if (throwable != throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        log.error((Object)"Error flushing project metadata", (Throwable)e);
                    }
                }
            }
            return Status.OK_STATUS;
        }
    }
}

