/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.athena;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.athena.model.AthenaDataSource;
import org.jkiss.dbeaver.ext.athena.model.AthenaMetaModel;
import org.jkiss.dbeaver.ext.generic.GenericDataSourceProvider;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPInformationProvider;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class AthenaDataSourceProvider
extends GenericDataSourceProvider
implements DBPInformationProvider {
    private static final Log log = Log.getLog(AthenaDataSourceProvider.class);

    public void init(@NotNull DBPPlatform platform) {
    }

    @NotNull
    public DBPDataSource openDataSource(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBException {
        return new AthenaDataSource(monitor, container, new AthenaMetaModel());
    }

    public String getConnectionURL(DBPDriver driver, DBPConnectionConfiguration connectionInfo) {
        String urlTemplate = driver.getSampleURL();
        String regionName = connectionInfo.getServerName();
        if (regionName == null) {
            regionName = connectionInfo.getProviderProperty("AwsRegion");
        }
        if (CommonUtils.isEmpty((String)urlTemplate) || !urlTemplate.startsWith("jdbc:awsathena://")) {
            return "jdbc:awsathena://AwsRegion=" + regionName + ";";
        }
        urlTemplate = urlTemplate.replace("{region}", regionName).replace("{server}", regionName).replace("=region;", "=" + regionName + ";");
        return urlTemplate;
    }

    @Nullable
    public String getObjectInformation(@NotNull DBPObject object, @NotNull String infoType) {
        if (object instanceof DBPDataSourceContainer && infoType.equals("targetAddress")) {
            return ((DBPDataSourceContainer)object).getConnectionConfiguration().getServerName();
        }
        return null;
    }
}

