/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.object.struct;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.properties.ObjectPropertyDescriptor;
import org.jkiss.dbeaver.runtime.properties.PropertySourceEditable;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.internal.EditorsMessages;
import org.jkiss.dbeaver.ui.editors.object.struct.BaseObjectEditPage;
import org.jkiss.dbeaver.ui.properties.PropertyTreeViewer;

public class PropertyObjectEditPage
extends BaseObjectEditPage {
    private final DBSObject object;
    private final PropertySourceEditable propertySource;
    private PropertyTreeViewer propertyViewer;

    public PropertyObjectEditPage(@Nullable DBECommandContext commandContext, @NotNull DBSObject object) {
        super(NLS.bind((String)EditorsMessages.dialog_struct_attribute_edit_page_header_edit_attribute, (Object)DBUtils.getObjectFullName((DBPNamedObject)object, (DBPEvaluationContext)DBPEvaluationContext.UI)));
        this.object = object;
        this.propertySource = new PropertySourceEditable(commandContext, (Object)object, (Object)object);
        this.propertySource.collectProperties();
        DBPPropertyDescriptor[] dBPPropertyDescriptorArray = this.propertySource.getProperties();
        int n = dBPPropertyDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            ObjectPropertyDescriptor obj;
            DBPPropertyDescriptor prop = dBPPropertyDescriptorArray[n2];
            if (prop instanceof ObjectPropertyDescriptor && (!(obj = (ObjectPropertyDescriptor)prop).isEditPossible((Object)object) || obj.isNameProperty())) {
                this.propertySource.removeProperty(prop);
            }
            ++n2;
        }
    }

    @Override
    protected Control createPageContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(768));
        Text nameText = UIUtils.createLabelText((Composite)composite, (String)EditorsMessages.dialog_struct_label_text_name, (String)this.object.getName());
        nameText.selectAll();
        nameText.addModifyListener(e -> {
            if (this.object instanceof DBPNamedObject2 && this.object.getDataSource() != null) {
                String transformed = DBObjectNameCaseTransformer.transformName((DBPDataSource)this.object.getDataSource(), (String)nameText.getText().trim());
                ((DBPNamedObject2)this.object).setName(transformed);
            }
        });
        UIUtils.createControlLabel((Composite)composite, (String)EditorsMessages.dialog_struct_label_text_properties).setLayoutData((Object)new GridData(2));
        this.propertyViewer = new PropertyTreeViewer(composite, 2048);
        this.propertyViewer.getControl().setLayoutData((Object)GridDataFactory.fillDefaults().hint(400, -1).create());
        this.propertyViewer.loadProperties((DBPPropertySource)this.propertySource);
        return composite;
    }

    @Override
    public void performFinish() throws DBException {
        this.propertyViewer.saveEditorValues();
    }
}

