/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.data.preferences;

import java.util.Locale;
import java.util.StringJoiner;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages;
import org.jkiss.dbeaver.ui.dialogs.EnterNameDialog;
import org.jkiss.dbeaver.ui.preferences.PreferenceStoreDelegate;
import org.jkiss.dbeaver.ui.preferences.TargetPrefPage;
import org.jkiss.utils.CommonUtils;

public class PrefPageDataViewer
extends TargetPrefPage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.main.dataviewer";
    private List refPanelDescColumnKeywords;
    private Text maxAmountText;

    public PrefPageDataViewer() {
        this.setPreferenceStore((IPreferenceStore)new PreferenceStoreDelegate(DBWorkbench.getPlatform().getPreferenceStore()));
    }

    protected boolean hasDataSourceSpecificOptions(DBPDataSourceContainer container) {
        DBPPreferenceStore store = container.getPreferenceStore();
        return store.contains("resultset.reference.value.description.column.patterns") || store.contains("dictionary.max.rows");
    }

    protected boolean supportsDataSourceSpecificOptions() {
        return true;
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1, (int)5);
        Group group = UIUtils.createControlGroup((Composite)composite, (String)ResultSetMessages.pref_page_data_viewer_reference_panel_group, (int)2, (int)768, (int)0);
        UIUtils.createControlLabel((Composite)group, (String)ResultSetMessages.pref_page_data_viewer_reference_panel_desc_column_keywords_label, (int)2);
        this.refPanelDescColumnKeywords = new List((Composite)group, 2820);
        this.refPanelDescColumnKeywords.setLayoutData((Object)new GridData(768));
        ((GridData)this.refPanelDescColumnKeywords.getLayoutData()).heightHint = UIUtils.getFontHeight((Control)this.refPanelDescColumnKeywords) * 15;
        ToolBar toolbar = new ToolBar((Composite)group, 512);
        toolbar.setLayoutData((Object)new GridData(2));
        UIUtils.createToolItem((ToolBar)toolbar, (String)ResultSetMessages.pref_page_data_viewer_reference_panel_desc_column_keywords_add_button, (DBPImage)UIIcon.ADD, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String name = PrefPageDataViewer.this.promptKeywordName(null);
                if (name != null) {
                    PrefPageDataViewer.this.refPanelDescColumnKeywords.add(name);
                    PrefPageDataViewer.this.refPanelDescColumnKeywords.select(PrefPageDataViewer.this.refPanelDescColumnKeywords.getItemCount() - 1);
                    PrefPageDataViewer.this.refPanelDescColumnKeywords.notifyListeners(13, new Event());
                }
            }
        });
        final ToolItem removeButton = UIUtils.createToolItem((ToolBar)toolbar, (String)ResultSetMessages.pref_page_data_viewer_reference_panel_desc_column_keywords_remove_button, (DBPImage)UIIcon.DELETE, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = PrefPageDataViewer.this.refPanelDescColumnKeywords.getSelectionIndex();
                PrefPageDataViewer.this.refPanelDescColumnKeywords.remove(index);
                PrefPageDataViewer.this.refPanelDescColumnKeywords.select(CommonUtils.clamp((int)index, (int)0, (int)(PrefPageDataViewer.this.refPanelDescColumnKeywords.getItemCount() - 1)));
                PrefPageDataViewer.this.refPanelDescColumnKeywords.notifyListeners(13, new Event());
            }
        });
        final ToolItem editButton = UIUtils.createToolItem((ToolBar)toolbar, (String)ResultSetMessages.pref_page_data_viewer_reference_panel_desc_column_keywords_edit_button, (DBPImage)UIIcon.EDIT, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = PrefPageDataViewer.this.refPanelDescColumnKeywords.getSelectionIndex();
                String name = PrefPageDataViewer.this.promptKeywordName(PrefPageDataViewer.this.refPanelDescColumnKeywords.getItem(index));
                if (name != null) {
                    PrefPageDataViewer.this.refPanelDescColumnKeywords.setItem(index, name);
                }
            }
        });
        this.refPanelDescColumnKeywords.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = PrefPageDataViewer.this.refPanelDescColumnKeywords.getSelectionIndex() >= 0;
                removeButton.setEnabled(selected);
                editButton.setEnabled(selected);
            }
        });
        group = UIUtils.createControlGroup((Composite)composite, (String)ResultSetMessages.pref_page_data_viewer_dictionary_panel_group, (int)1, (int)768, (int)0);
        this.maxAmountText = UIUtils.createLabelText((Composite)group, (String)ResultSetMessages.getPref_page_data_viewer_dictionary_panel_results_max_size, (String)"200");
        this.maxAmountText.addVerifyListener(UIUtils.getNumberVerifyListener((Locale)Locale.getDefault()));
        this.maxAmountText.addModifyListener(event -> {
            this.updateApplyButton();
            this.getContainer().updateButtons();
        });
        return composite;
    }

    public boolean isValid() {
        return super.isValid() && !this.maxAmountText.getText().isEmpty();
    }

    protected void loadPreferences(DBPPreferenceStore store) {
        this.refPanelDescColumnKeywords.removeAll();
        for (String pattern : DBVEntity.getDescriptionColumnPatterns((DBPPreferenceStore)store)) {
            this.refPanelDescColumnKeywords.add(pattern);
        }
        this.refPanelDescColumnKeywords.notifyListeners(13, new Event());
        this.maxAmountText.setText(store.getString("dictionary.max.rows"));
    }

    protected void savePreferences(DBPPreferenceStore store) {
        StringJoiner buffer = new StringJoiner("|");
        String[] stringArray = this.refPanelDescColumnKeywords.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String pattern = stringArray[n2];
            buffer.add(pattern);
            ++n2;
        }
        store.setValue("resultset.reference.value.description.column.patterns", buffer.toString());
        store.setValue("dictionary.max.rows", this.maxAmountText.getText());
    }

    protected void clearPreferences(DBPPreferenceStore store) {
        store.setToDefault("resultset.reference.value.description.column.patterns");
        store.setToDefault("dictionary.max.rows");
    }

    protected void performDefaults() {
        DBPPreferenceStore store = this.getTargetPreferenceStore();
        this.clearPreferences(store);
        this.loadPreferences(store);
    }

    protected String getPropertyPageID() {
        return PAGE_ID;
    }

    @Nullable
    private String promptKeywordName(@Nullable String value) {
        String name = EnterNameDialog.chooseName((Shell)this.getShell(), (String)ResultSetMessages.pref_page_data_viewer_reference_panel_desc_column_keywords_prompt_title, (String)value);
        if (name != null) {
            name = name.toLowerCase(Locale.ENGLISH).strip();
        }
        if (CommonUtils.isNotEmpty((String)name) && this.refPanelDescColumnKeywords.indexOf(name) < 0) {
            return name;
        }
        return null;
    }
}

