/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.panel.metadata;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeBindingMeta;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.DatabaseLoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadVisualizer;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.LoadingJob;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TreeContentProvider;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPanel;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages;
import org.jkiss.dbeaver.ui.controls.resultset.panel.ResultSetPanelRefresher;
import org.jkiss.dbeaver.ui.navigator.itemlist.DatabaseObjectListControl;
import org.jkiss.dbeaver.ui.navigator.itemlist.ObjectListControl;
import org.jkiss.utils.CommonUtils;

public class MetaDataPanel
implements IResultSetPanel {
    public static final String PANEL_ID = "results-metadata";
    private IResultSetPresentation presentation;
    private MetaDataTable attributeList;
    private List<DBDAttributeBinding> curAttributes;
    private Color colorDisabled;
    private transient boolean updateSelection = false;

    @Override
    public Control createContents(IResultSetPresentation presentation, Composite parent) {
        this.presentation = presentation;
        this.colorDisabled = presentation.getControl().getDisplay().getSystemColor(17);
        this.attributeList = new MetaDataTable(parent);
        this.attributeList.setFitWidth(true);
        this.attributeList.getItemsViewer().addSelectionChangedListener(event -> {
            DBDAttributeBinding attr = this.getSelectedAttribute();
            if (attr != null && !this.updateSelection && this.isAttributeVisible(attr)) {
                this.updateSelection = true;
                try {
                    presentation.setCurrentAttribute(attr);
                }
                finally {
                    this.updateSelection = false;
                }
            }
        });
        if (this.presentation instanceof ISelectionProvider) {
            ISelectionChangedListener listener = event -> {
                DBDAttributeBinding attr;
                if (!this.updateSelection && this.presentation.getController().getVisiblePanel() == this && (attr = presentation.getCurrentAttribute()) != null && attr != this.getSelectedAttribute()) {
                    this.updateSelection = true;
                    try {
                        this.attributeList.getItemsViewer().setSelection((ISelection)new StructuredSelection((Object)attr));
                    }
                    finally {
                        this.updateSelection = false;
                    }
                }
            };
            ((ISelectionProvider)this.presentation).addSelectionChangedListener(listener);
            this.attributeList.getControl().addDisposeListener(e -> ((ISelectionProvider)presentation).removeSelectionChangedListener(listener));
        }
        ResultSetPanelRefresher.installOn(this, presentation);
        return this.attributeList;
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Nullable
    private DBDAttributeBinding getSelectedAttribute() {
        return (DBDAttributeBinding)this.attributeList.getSuitableSelectedElement(DBDAttributeBinding.class);
    }

    private boolean isAttributeVisible(DBDAttributeBinding attr) {
        return this.presentation.getController().getModel().getVisibleAttributes().contains(attr);
    }

    @Override
    public void activatePanel() {
        this.refresh(false);
    }

    @Override
    public void deactivatePanel() {
    }

    @Override
    public void setFocus() {
        this.attributeList.setFocus();
    }

    @Override
    public void refresh(boolean force) {
        if (this.attributeList.isLoading()) {
            return;
        }
        List<DBDAttributeBinding> newAttributes = Arrays.asList(this.presentation.getController().getModel().getAttributes());
        if (this.curAttributes != null && this.curAttributes.size() == newAttributes.size()) {
            boolean equals = true;
            int i = 0;
            while (i < this.curAttributes.size()) {
                if (this.curAttributes.get(i) != newAttributes.get(i)) {
                    equals = false;
                    break;
                }
                ++i;
            }
            if (equals) {
                return;
            }
        }
        this.curAttributes = newAttributes;
        this.attributeList.clearListData();
        this.attributeList.loadData();
    }

    public void contributeActions(IContributionManager manager) {
        manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)UIUtils.getActiveWorkbenchWindow(), (String)"org.jkiss.dbeaver.ui.editors.sql.generate.ddl.by.resultSet", (String)ResultSetMessages.generate_ddl_by_result_set_name, (DBPImage)UIIcon.SQL_TEXT, (String)ResultSetMessages.generate_ddl_by_result_set_tip, (boolean)true));
    }

    private class LoadAttributesService
    extends DatabaseLoadService<Collection<DBDAttributeBinding>> {
        LoadAttributesService() {
            super("Load sessions", MetaDataPanel.this.presentation.getController().getExecutionContext());
        }

        public Collection<DBDAttributeBinding> evaluate(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            return MetaDataPanel.this.curAttributes;
        }
    }

    private class MetaDataTable
    extends DatabaseObjectListControl<DBDAttributeBinding> {
        MetaDataTable(Composite parent) {
            super(parent, 0x10000000, (IWorkbenchSite)MetaDataPanel.this.presentation.getController().getSite(), (IContentProvider)new TreeContentProvider(){

                public Object[] getChildren(Object parentElement) {
                    List nested = ((DBDAttributeBinding)parentElement).getNestedBindings();
                    return nested == null ? new Object[]{} : nested.toArray(new Object[0]);
                }

                public boolean hasChildren(Object element) {
                    return !CommonUtils.isEmpty((Collection)((DBDAttributeBinding)element).getNestedBindings());
                }
            });
        }

        public void fillCustomActions(IContributionManager contributionManager) {
            UIUtils.fillDefaultTreeContextMenu((IContributionManager)contributionManager, (Tree)((Tree)this.getItemsViewer().getControl()));
            contributionManager.add((IAction)new Action("Copy column names"){

                public void run() {
                    StringBuilder text = new StringBuilder();
                    Object[] objectArray = MetaDataTable.this.getItemsViewer().getStructuredSelection().toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object item = objectArray[n2];
                        if (item instanceof DBDAttributeBinding) {
                            if (text.length() > 0) {
                                text.append("\n");
                            }
                            text.append(((DBDAttributeBinding)item).getName());
                        }
                        ++n2;
                    }
                    if (text.length() == 0) {
                        return;
                    }
                    UIUtils.setClipboardContents((Display)MetaDataTable.this.getDisplay(), (Transfer)TextTransfer.getInstance(), (Object)text.toString());
                }
            });
        }

        @NotNull
        protected String getListConfigId(List<Class<?>> classList) {
            DBCExecutionContext executionContext = MetaDataPanel.this.presentation.getController().getExecutionContext();
            if (executionContext == null) {
                return "MetaData";
            }
            return "MetaData/" + executionContext.getDataSource().getContainer().getDriver().getId();
        }

        protected Object getObjectValue(DBDAttributeBinding item) {
            if (item instanceof DBDAttributeBindingMeta) {
                return item.getMetaAttribute();
            }
            if (item != null) {
                return item.getAttribute();
            }
            return null;
        }

        @Nullable
        protected DBPImage getObjectImage(DBDAttributeBinding item) {
            return DBValueFormatting.getObjectImage((DBPObject)item.getMetaAttribute());
        }

        protected Color getObjectForeground(DBDAttributeBinding item) {
            if (item.getParentObject() == null && !MetaDataPanel.this.isAttributeVisible(item)) {
                return MetaDataPanel.this.colorDisabled;
            }
            return super.getObjectForeground((Object)item);
        }

        protected LoadingJob<Collection<DBDAttributeBinding>> createLoadService(boolean forUpdate) {
            return LoadingJob.createService((ILoadService)new LoadAttributesService(), (ILoadVisualizer)new ObjectListControl.ObjectsLoadVisualizer((ObjectListControl)this){

                public void completeLoading(Collection<DBDAttributeBinding> items) {
                    super.completeLoading(items);
                    TreeViewer itemsViewer = (TreeViewer)((MetaDataTable)MetaDataTable.this).MetaDataPanel.this.attributeList.getItemsViewer();
                    if (!itemsViewer.getControl().isDisposed()) {
                        itemsViewer.expandToLevel(2);
                    }
                }
            });
        }
    }
}

