/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.model;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.erd.model.ERDAssociation;
import org.jkiss.dbeaver.erd.model.ERDDiagram;
import org.jkiss.dbeaver.erd.model.ERDEntity;
import org.jkiss.dbeaver.erd.model.ERDEntityAttribute;
import org.jkiss.dbeaver.erd.model.ERDObject;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPSystemObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.dbeaver.model.struct.rdb.DBSTablePartition;
import org.jkiss.dbeaver.model.virtual.DBVUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class ERDUtils {
    private static final Log log = Log.getLog(ERDUtils.class);

    @NotNull
    public static Collection<? extends DBSEntityAttribute> getBestTableIdentifier(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntity entity) throws DBException {
        if (entity instanceof DBSTable && ((DBSTable)entity).isView()) {
            return Collections.emptyList();
        }
        if (CommonUtils.isEmpty((Collection)entity.getAttributes(monitor))) {
            return Collections.emptyList();
        }
        DBSEntityConstraint uniqueId = null;
        for (DBSEntityConstraint id : CommonUtils.safeCollection((Collection)entity.getConstraints(monitor))) {
            if (id instanceof DBSEntityReferrer && id.getConstraintType() == DBSEntityConstraintType.PRIMARY_KEY) {
                return DBUtils.getEntityAttributes((DBRProgressMonitor)monitor, (DBSEntityReferrer)((DBSEntityReferrer)id));
            }
            if (id.getConstraintType().isUnique()) {
                uniqueId = id;
                continue;
            }
            if (!(id instanceof DBSTableIndex) || !((DBSTableIndex)id).isUnique()) continue;
            uniqueId = id;
        }
        if (uniqueId instanceof DBSEntityReferrer) {
            return DBUtils.getEntityAttributes((DBRProgressMonitor)monitor, (DBSEntityReferrer)((DBSEntityReferrer)uniqueId));
        }
        if (entity instanceof DBSTable) {
            try {
                Collection indexes = ((DBSTable)entity).getIndexes(monitor);
                if (!CommonUtils.isEmpty((Collection)indexes)) {
                    for (DBSTableIndex index : indexes) {
                        if (!DBUtils.isIdentifierIndex((DBRProgressMonitor)monitor, (DBSTableIndex)index)) continue;
                        return DBUtils.getEntityAttributes((DBRProgressMonitor)monitor, (DBSEntityReferrer)index);
                    }
                }
            }
            catch (DBException e) {
                log.debug((Object)e);
            }
        }
        return Collections.emptyList();
    }

    public static boolean isIdentifyingAssociation(ERDAssociation association) {
        if (association.isLogical()) {
            return false;
        }
        try {
            return DBUtils.isIdentifyingAssociation((DBRProgressMonitor)new VoidProgressMonitor(), (DBSEntityAssociation)((DBSEntityAssociation)association.getObject()));
        }
        catch (DBException e) {
            log.debug((Object)e);
            return false;
        }
    }

    public static boolean isOptionalAssociation(ERDAssociation association) {
        try {
            return DBUtils.isOptionalAssociation((DBRProgressMonitor)new VoidProgressMonitor(), (DBSEntityAssociation)((DBSEntityAssociation)association.getObject()));
        }
        catch (DBException e) {
            log.debug((Object)e);
            return false;
        }
    }

    public static ERDEntityAttribute getAttributeByModel(ERDEntity entity, DBSEntityAttribute attr) {
        for (ERDEntityAttribute erdAttr : entity.getAttributes()) {
            if (erdAttr.getObject() != attr) continue;
            return erdAttr;
        }
        return null;
    }

    public static <T> List<T> getObjectsFromERD(List<? extends ERDObject<T>> erdObjects) {
        ArrayList<T> result = null;
        if (erdObjects != null) {
            result = new ArrayList<T>();
            for (ERDObject<T> erdObject : erdObjects) {
                result.add(erdObject.getObject());
            }
        }
        return result;
    }

    public static ERDEntity makeEntityFromObject(DBRProgressMonitor monitor, ERDDiagram diagram, List<ERDEntity> otherEntities, DBSEntity entity, Object userData) {
        ERDEntity erdEntity = new ERDEntity(entity);
        erdEntity.setUserData(userData);
        try {
            diagram.getContentProvider().fillEntityFromObject(monitor, diagram, otherEntities, erdEntity);
        }
        catch (DBCException e) {
            DBWorkbench.getPlatformUI().showError("Can't create entity", e.getMessage());
            return null;
        }
        return erdEntity;
    }

    public static Collection<DBSEntity> collectDatabaseTables(DBRProgressMonitor monitor, DBSObject root, ERDDiagram diagram, boolean showViews, boolean showPartitions) throws DBException {
        LinkedHashSet<DBSEntity> result = new LinkedHashSet<DBSEntity>();
        if (root instanceof DBSObjectContainer) {
            monitor.beginTask("Load '" + root.getName() + "' content", 3);
            DBSObjectContainer objectContainer = (DBSObjectContainer)root;
            try {
                DBExecUtils.tryExecuteRecover((Object)monitor, (DBPDataSource)objectContainer.getDataSource(), param -> {
                    try {
                        objectContainer.cacheStructure(monitor, 7);
                    }
                    catch (DBException e) {
                        throw new InvocationTargetException(e);
                    }
                });
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showError("Cache database model", "Error caching database model", (Throwable)e);
            }
            Collection entities = objectContainer.getChildren(monitor);
            if (entities != null) {
                Class childType = objectContainer.getPrimaryChildType(monitor);
                DBSObjectFilter objectFilter = objectContainer.getDataSource().getContainer().getObjectFilter(childType, (DBSObject)objectContainer, true);
                for (DBSObject entity2 : entities) {
                    DBSEntity entity1;
                    if (!(entity2 instanceof DBSEntity) || objectFilter != null && objectFilter.isEnabled() && !objectFilter.matches(entity2.getName()) || ERDUtils.skipSystemEntity(entity1 = (DBSEntity)entity2) || entity1.getEntityType() != DBSEntityType.TABLE && entity1.getEntityType() != DBSEntityType.CLASS && entity1.getEntityType() != DBSEntityType.VIRTUAL_ENTITY && (!showViews || !DBUtils.isView((DBSEntity)entity1))) continue;
                    result.add(entity1);
                }
            }
            monitor.done();
        } else if (root instanceof DBSEntity) {
            monitor.beginTask("Load '" + root.getName() + "' relations", 3);
            DBSEntity rootTable = (DBSEntity)root;
            result.add(rootTable);
            try {
                monitor.subTask("Read foreign keys");
                List fks = DBVUtils.getAllAssociations((DBRProgressMonitor)monitor, (DBSEntity)rootTable);
                if (fks != null) {
                    for (DBSEntityAssociation fk : fks) {
                        DBSEntity associatedEntity = fk.getAssociatedEntity();
                        if (associatedEntity == null) continue;
                        result.add(DBVUtils.getRealEntity((DBRProgressMonitor)monitor, (DBSEntity)associatedEntity));
                    }
                }
                monitor.worked(1);
            }
            catch (DBException e) {
                log.warn((Object)"Can't load table foreign keys", (Throwable)e);
            }
            if (monitor.isCanceled()) {
                return result;
            }
            monitor.subTask("Read references");
            List refs = DBVUtils.getAllReferences((DBRProgressMonitor)monitor, (DBSEntity)rootTable);
            for (DBSEntityAssociation ref : refs) {
                result.add(ref.getParentObject());
            }
            monitor.worked(1);
            if (monitor.isCanceled()) {
                return result;
            }
            try {
                monitor.subTask("Read associations");
                ArrayList<DBSEntity> secondLevelEntities = new ArrayList<DBSEntity>();
                for (DBSEntity entity3 : result) {
                    Collection fks;
                    if (entity3 == rootTable || entity3.getEntityType() != DBSEntityType.ASSOCIATION || (fks = entity3.getAssociations(monitor)) == null) continue;
                    for (DBSEntityAssociation association : fks) {
                        if (association.getConstraintType() == DBSEntityConstraintType.INHERITANCE) continue;
                        secondLevelEntities.add(association.getAssociatedEntity());
                    }
                }
                result.addAll(secondLevelEntities);
                monitor.worked(1);
            }
            catch (DBException e) {
                log.warn((Object)"Can't load table references", (Throwable)e);
            }
            monitor.done();
        }
        for (ERDEntity diagramEntity : diagram.getEntities()) {
            result.remove(diagramEntity.getObject());
        }
        if (!showPartitions) {
            result.removeIf(entity -> entity instanceof DBSTablePartition);
        }
        return result;
    }

    public static boolean skipSystemEntity(DBSEntity entity) {
        boolean showSystemObjects = entity.getDataSource().getContainer().getNavigatorSettings().isShowSystemObjects();
        return !showSystemObjects && entity instanceof DBPSystemObject && ((DBPSystemObject)entity).isSystem();
    }
}

