/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.e4;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.renderers.swt.StackRenderer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityPart;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.e4.DBeaverPartList;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorInput;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.editors.sql.handlers.SQLEditorHandlerRenameFile;

public class DBeaverStackRenderer
extends StackRenderer {
    public void showAvailableItems(MElementContainer<?> stack, CTabFolder folder, boolean forceCenter) {
        Point location;
        IEclipseContext ctx = this.getContext((MUIElement)stack);
        DBeaverPartList list = new DBeaverPartList(folder.getShell(), 16384, 768, (EPartService)ctx.get(EPartService.class), stack, this, true);
        list.setInput();
        Point size = list.computeSizeHint();
        if (forceCenter) {
            Rectangle area = folder.getClientArea();
            location = folder.toDisplay(area.x, area.y);
            location.x = Math.max(0, location.x + (area.width - size.x) / 2);
            location.y = Math.max(0, location.y + (area.height - size.y) / 3);
        } else {
            location = folder.toDisplay(DBeaverStackRenderer.getChevronLocation(folder));
            Rectangle area = folder.getMonitor().getClientArea();
            if (location.x + size.x > area.x + area.width) {
                location.x = area.x + area.width - size.x;
            }
            if (location.y + size.y > area.y + area.height) {
                location.y = area.y + area.height - size.y;
            }
        }
        list.setSize(size.x, size.y);
        list.setLocation(location);
        list.setVisible(true);
        list.setFocus();
        list.getShell().addListener(27, e -> UIUtils.asyncExec(() -> {
            if (!list.hasFocus()) {
                list.dispose();
            }
        }));
    }

    protected void populateTabMenu(Menu menu, MPart part) {
        super.populateTabMenu(menu, part);
        IWorkbenchPart workbenchPart = this.getWorkbenchPart(part);
        if (workbenchPart instanceof IEditorPart) {
            IFile localFile;
            IEditorInput editorInput;
            IWorkbenchPage activePage = workbenchPart.getSite().getWorkbenchWindow().getActivePage();
            if (activePage.getActiveEditor() != workbenchPart) {
                activePage.activate(workbenchPart);
            }
            if ((editorInput = ((IEditorPart)workbenchPart).getEditorInput()) instanceof IDatabaseEditorInput) {
                this.populateEditorMenu(menu, (IDatabaseEditorInput)editorInput);
            }
            if ((localFile = EditorUtils.getFileFromInput((IEditorInput)editorInput)) != null) {
                this.populateFileMenu(menu, workbenchPart, localFile);
                return;
            }
            if (workbenchPart instanceof SQLEditor) {
                new MenuItem(menu, 2);
                DBeaverStackRenderer.addActionItem(workbenchPart, menu, "org.eclipse.ui.file.saveAs");
            }
        }
    }

    private void populateFileMenu(@NotNull Menu menu, final @NotNull IWorkbenchPart workbenchPart, final @NotNull IFile inputFile) {
        MenuItem menuItemOthers;
        new MenuItem(menu, 2);
        if (workbenchPart instanceof SQLEditor) {
            DBeaverStackRenderer.addActionItem(workbenchPart, menu, "org.jkiss.dbeaver.core.sql.editor.create");
        }
        if (inputFile.getParent() instanceof IFolder && inputFile.getParent().getLocation() != null) {
            MenuItem menuItemOpenFolder = new MenuItem(menu, 0);
            menuItemOpenFolder.setText(CoreMessages.editor_file_open_in_explorer);
            menuItemOpenFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ShellUtils.launchProgram((String)inputFile.getParent().getLocation().toFile().getAbsolutePath());
                }
            });
        }
        if (inputFile.getLocation() != null) {
            menuItemOthers = new MenuItem(menu, 0);
            menuItemOthers.setText(CoreMessages.editor_file_copy_path);
            menuItemOthers.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String filePath = inputFile.getLocation().toFile().getAbsolutePath();
                    UIUtils.setClipboardContents((Display)Display.getCurrent(), (Transfer)TextTransfer.getInstance(), (Object)filePath);
                }
            });
        }
        new MenuItem(menu, 2);
        if (workbenchPart instanceof SQLEditor) {
            DBeaverStackRenderer.addActionItem(workbenchPart, menu, "org.jkiss.dbeaver.ui.editors.sql.deleteThisScript");
        }
        menuItemOthers = new MenuItem(menu, 0);
        String renameText = CoreMessages.editor_file_rename;
        if (workbenchPart instanceof SQLEditor) {
            renameText = String.valueOf(renameText) + "\t" + ActionUtils.findCommandDescription((String)"org.jkiss.dbeaver.ui.editors.sql.rename", (IServiceLocator)workbenchPart.getSite(), (boolean)true);
        }
        menuItemOthers.setText(renameText);
        menuItemOthers.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLEditorHandlerRenameFile.renameFile((IWorkbenchPart)workbenchPart, (IFile)inputFile, (String)"file");
            }
        });
    }

    private void populateEditorMenu(@NotNull Menu menu, @NotNull IDatabaseEditorInput input) {
        String label;
        final DBSObject object = input.getDatabaseObject();
        DBNDatabaseNode node = input.getNavigatorNode();
        if (object != null && node != null && (label = node.getMeta().getNodeTypeLabel(object.getDataSource(), null)) != null) {
            new MenuItem(menu, 2);
            MenuItem item = new MenuItem(menu, 0);
            item.setText(NLS.bind((String)CoreMessages.editor_file_copy_object_name, (Object)label));
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DBWorkbench.getPlatformUI().copyTextToClipboard(DBUtils.getObjectFullName((DBPNamedObject)object, (DBPEvaluationContext)DBPEvaluationContext.UI), false);
                }
            });
        }
    }

    private static void addActionItem(final @NotNull IWorkbenchPart workbenchPart, @NotNull Menu menu, final @NotNull String actionId) {
        String actionText = ActionUtils.findCommandName((String)actionId);
        String shortcut = ActionUtils.findCommandDescription((String)actionId, (IServiceLocator)workbenchPart.getSite(), (boolean)true);
        if (shortcut != null) {
            actionText = String.valueOf(actionText) + "\t" + shortcut;
        }
        MenuItem menuItemDelete = new MenuItem(menu, 0);
        menuItemDelete.setText(actionText);
        menuItemDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionUtils.runCommand((String)actionId, (IServiceLocator)workbenchPart.getSite());
            }
        });
    }

    private IWorkbenchPart getWorkbenchPart(MPart part) {
        Object clientObject;
        if (part != null && (clientObject = part.getObject()) instanceof CompatibilityPart) {
            return ((CompatibilityPart)clientObject).getPart();
        }
        return null;
    }

    @NotNull
    private static Point getChevronLocation(@NotNull CTabFolder folder) {
        CTabItem item = null;
        int i = 0;
        while (i < folder.getItemCount()) {
            CTabItem tmpItem = folder.getItem(i);
            if (tmpItem.isShowing()) {
                item = tmpItem;
            }
            ++i;
        }
        if (item != null) {
            Rectangle bounds = item.getBounds();
            return new Point(bounds.x + bounds.width, bounds.y + bounds.height);
        }
        return new Point(0, 0);
    }
}

