/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.handlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithResult;
import org.jkiss.dbeaver.model.sql.generator.SQLGenerator;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorUtils;
import org.jkiss.dbeaver.ui.editors.sql.generator.SQLGeneratorContributor;
import org.jkiss.dbeaver.ui.editors.sql.handlers.SQLEditorHandlerOpenEditor;
import org.jkiss.dbeaver.ui.editors.sql.handlers.SQLNavigatorContext;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class SQLEditorHandlerOpenObjectConsole
extends AbstractHandler {
    private static final Log log = Log.getLog(SQLEditorHandlerOpenObjectConsole.class);
    private static final boolean OPEN_FILE_EDITOR = true;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow workbenchWindow = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        SQLNavigatorContext navContext = null;
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        List selectedObjects = NavigatorUtils.getSelectedObjects((ISelection)currentSelection);
        ArrayList<DBSEntity> entities = new ArrayList<DBSEntity>();
        for (DBSObject object : selectedObjects) {
            DBSObject parentObject;
            if (navContext == null) {
                navContext = new SQLNavigatorContext(object);
            }
            if (object instanceof DBSEntity) {
                entities.add((DBSEntity)object);
            }
            if (!(object instanceof DBNDatabaseFolder) || !((parentObject = object.getParentObject()) instanceof DBSEntity)) continue;
            entities.add((DBSEntity)parentObject);
        }
        if (navContext == null || navContext.getDataSourceContainer() == null) {
            log.debug((Object)"No active datasource");
            return null;
        }
        SQLGenerator<DBSEntity> generator = SQLGeneratorContributor.SELECT_GENERATOR(entities, true);
        String title = "Query";
        if (entities.size() == 1) {
            title = DBUtils.getObjectFullName((DBPNamedObject)((DBPNamedObject)entities.get(0)), (DBPEvaluationContext)DBPEvaluationContext.DML);
        }
        try {
            this.openConsole(workbenchWindow, (DBRRunnableWithResult<String>)generator, navContext, title, !entities.isEmpty(), currentSelection);
        }
        catch (Exception e) {
            DBWorkbench.getPlatformUI().showError("Open console", "Can open SQL editor", (Throwable)e);
        }
        return null;
    }

    void openConsole(IWorkbenchWindow workbenchWindow, DBRRunnableWithResult<String> generator, SQLNavigatorContext navigatorContext, String title, boolean doRun, ISelection currentSelection) throws Exception {
        UIUtils.runInUI((IRunnableContext)workbenchWindow, generator);
        String sql = CommonUtils.notEmpty((String)((String)generator.getResult()));
        SQLEditorHandlerOpenObjectConsole.openAndExecuteSQLScript(workbenchWindow, navigatorContext, title, doRun, currentSelection, sql);
    }

    public static void openAndExecuteSQLScript(IWorkbenchWindow workbenchWindow, SQLNavigatorContext navigatorContext, String title, boolean doRun, final ISelection currentSelection, String sql) throws CoreException {
        DBPProject project = navigatorContext.getProject();
        SQLEditorHandlerOpenEditor.checkProjectIsOpen(project);
        IFolder folder = SQLEditorHandlerOpenEditor.getCurrentScriptFolder(currentSelection);
        IFile scriptFile = SQLEditorUtils.createNewScript(project, folder, navigatorContext);
        FileEditorInput sqlInput = new FileEditorInput(scriptFile);
        final SQLEditor editor = (SQLEditor)workbenchWindow.getActivePage().openEditor((IEditorInput)sqlInput, SQLEditor.class.getName());
        if (editor != null && editor.getDocument() != null) {
            editor.getDocument().set(sql);
            AbstractJob execJob = new AbstractJob("Execute SQL in console"){

                protected IStatus run(DBRProgressMonitor monitor) {
                    int i = 0;
                    while (i < 100) {
                        if (editor.getExecutionContext() != null) break;
                        RuntimeUtils.pause((int)100);
                        ++i;
                    }
                    return Status.OK_STATUS;
                }
            };
            if (doRun) {
                execJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent event) {
                        UIUtils.syncExec(() -> editor.processSQL(false, NavigatorUtils.getSelectedObjects((ISelection)currentSelection).size() > 1));
                    }
                });
            }
            execJob.schedule();
        }
    }
}

