/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.swt.editor;

import java.awt.BasicStroke;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.ResourceBundle;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.swt.editor.SWTPaintCanvas;
import org.jfree.chart.swt.editor.SWTStrokeCanvas;
import org.jfree.chart.util.ResourceBundleWrapper;
import org.jfree.swt.SWTUtils;

class SWTPlotAppearanceEditor
extends Composite {
    private Spinner selectStroke;
    private SWTStrokeCanvas strokeCanvas;
    private SWTPaintCanvas backgroundPaintCanvas;
    private SWTPaintCanvas outlinePaintCanvas;
    private PlotOrientation plotOrientation;
    private Combo orientation;
    private static final String[] orientationNames = new String[]{"Vertical", "Horizontal"};
    private static final int ORIENTATION_VERTICAL = 0;
    private static final int ORIENTATION_HORIZONTAL = 1;
    protected static ResourceBundle localizationResources = ResourceBundleWrapper.getBundle((String)"org.jfree.chart.editor.LocalizationBundle");

    SWTPlotAppearanceEditor(Composite parent, int style, Plot plot) {
        super(parent, style);
        FillLayout layout = new FillLayout();
        layout.marginWidth = 4;
        layout.marginHeight = 4;
        this.setLayout((Layout)layout);
        Group general = new Group((Composite)this, 0);
        GridLayout groupLayout = new GridLayout(3, false);
        groupLayout.marginWidth = 4;
        groupLayout.marginHeight = 4;
        general.setLayout((Layout)groupLayout);
        general.setText(localizationResources.getString("General"));
        new Label((Composite)general, 0).setText(localizationResources.getString("Outline_stroke"));
        this.strokeCanvas = new SWTStrokeCanvas((Composite)general, 0);
        this.strokeCanvas.setStroke(plot.getOutlineStroke());
        GridData strokeGridData = new GridData(4, 0x1000000, true, false);
        strokeGridData.heightHint = 20;
        this.strokeCanvas.setLayoutData(strokeGridData);
        this.selectStroke = new Spinner((Composite)general, 2048);
        this.selectStroke.setMinimum(1);
        this.selectStroke.setMaximum(3);
        this.selectStroke.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.selectStroke.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int w = SWTPlotAppearanceEditor.this.selectStroke.getSelection();
                if (w > 0) {
                    SWTPlotAppearanceEditor.this.strokeCanvas.setStroke(new BasicStroke(w));
                    SWTPlotAppearanceEditor.this.strokeCanvas.redraw();
                }
            }
        });
        new Label((Composite)general, 0).setText(localizationResources.getString("Outline_Paint"));
        this.outlinePaintCanvas = new SWTPaintCanvas((Composite)general, 0, SWTUtils.toSwtColor((Device)this.getDisplay(), (Paint)plot.getOutlinePaint()));
        GridData outlineGridData = new GridData(4, 0x1000000, true, false);
        outlineGridData.heightHint = 20;
        this.outlinePaintCanvas.setLayoutData(outlineGridData);
        Button selectOutlineColor = new Button((Composite)general, 8);
        selectOutlineColor.setText(localizationResources.getString("Select..."));
        selectOutlineColor.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        selectOutlineColor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColorDialog dlg = new ColorDialog(SWTPlotAppearanceEditor.this.getShell());
                dlg.setText(localizationResources.getString("Outline_Paint"));
                dlg.setRGB(SWTPlotAppearanceEditor.this.outlinePaintCanvas.getColor().getRGB());
                RGB rgb = dlg.open();
                if (rgb != null) {
                    SWTPlotAppearanceEditor.this.outlinePaintCanvas.setColor(new Color((Device)SWTPlotAppearanceEditor.this.getDisplay(), rgb));
                }
            }
        });
        new Label((Composite)general, 0).setText(localizationResources.getString("Background_paint"));
        this.backgroundPaintCanvas = new SWTPaintCanvas((Composite)general, 0, SWTUtils.toSwtColor((Device)this.getDisplay(), (Paint)plot.getBackgroundPaint()));
        GridData bgGridData = new GridData(4, 0x1000000, true, false);
        bgGridData.heightHint = 20;
        this.backgroundPaintCanvas.setLayoutData(bgGridData);
        Button selectBgPaint = new Button((Composite)general, 8);
        selectBgPaint.setText(localizationResources.getString("Select..."));
        selectBgPaint.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        selectBgPaint.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColorDialog dlg = new ColorDialog(SWTPlotAppearanceEditor.this.getShell());
                dlg.setText(localizationResources.getString("Background_paint"));
                dlg.setRGB(SWTPlotAppearanceEditor.this.backgroundPaintCanvas.getColor().getRGB());
                RGB rgb = dlg.open();
                if (rgb != null) {
                    SWTPlotAppearanceEditor.this.backgroundPaintCanvas.setColor(new Color((Device)SWTPlotAppearanceEditor.this.getDisplay(), rgb));
                }
            }
        });
        if (plot instanceof CategoryPlot) {
            this.plotOrientation = ((CategoryPlot)plot).getOrientation();
        } else if (plot instanceof XYPlot) {
            this.plotOrientation = ((XYPlot)plot).getOrientation();
        }
        if (this.plotOrientation != null) {
            boolean isVertical = this.plotOrientation.equals((Object)PlotOrientation.VERTICAL);
            int index = isVertical ? 0 : 1;
            new Label((Composite)general, 0).setText(localizationResources.getString("Orientation"));
            this.orientation = new Combo((Composite)general, 4);
            this.orientation.setItems(orientationNames);
            this.orientation.select(index);
            this.orientation.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 2, 1));
            this.orientation.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    switch (SWTPlotAppearanceEditor.this.orientation.getSelectionIndex()) {
                        case 0: {
                            SWTPlotAppearanceEditor.this.plotOrientation = PlotOrientation.VERTICAL;
                            break;
                        }
                        case 1: {
                            SWTPlotAppearanceEditor.this.plotOrientation = PlotOrientation.HORIZONTAL;
                            break;
                        }
                        default: {
                            SWTPlotAppearanceEditor.this.plotOrientation = PlotOrientation.VERTICAL;
                        }
                    }
                }
            });
        }
    }

    public PlotOrientation getPlotOrientation() {
        return this.plotOrientation;
    }

    public Color getBackGroundPaint() {
        return this.backgroundPaintCanvas.getColor();
    }

    public Color getOutlinePaint() {
        return this.outlinePaintCanvas.getColor();
    }

    public Stroke getStroke() {
        return this.strokeCanvas.getStroke();
    }
}

