/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.editors;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ModelPreferences;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.controls.CustomTimeEditor;
import org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.editors.BaseValueEditor;

public class DateTimeInlineEditor
extends BaseValueEditor<Control> {
    private TextMode textMode;
    private DateEditorMode dateEditorMode;
    private CustomTimeEditor timeEditor;

    public DateTimeInlineEditor(IValueController controller) {
        super(controller);
    }

    @Override
    protected void addInlineListeners(@NotNull Control inlineControl, @NotNull Listener listener) {
        super.addInlineListeners(inlineControl, listener);
        this.timeEditor.addSelectionAdapter(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Event selectionEvent = new Event();
                selectionEvent.widget = DateTimeInlineEditor.this.timeEditor.getControl();
                DateTimeInlineEditor.this.timeEditor.getControl().notifyListeners(13, selectionEvent);
            }
        });
        this.timeEditor.addModifyListener(e -> {
            Event modificationEvent = new Event();
            modificationEvent.widget = this.timeEditor.getControl();
            this.timeEditor.getControl().notifyListeners(24, modificationEvent);
        });
    }

    @Override
    protected Control createControl(Composite editPlaceholder) {
        Object value = this.valueController.getValue();
        this.valueController.getEditPlaceholder();
        boolean inline = this.valueController.getEditType() == IValueController.EditType.INLINE;
        this.timeEditor = new CustomTimeEditor(editPlaceholder, 2, true, inline);
        this.textMode = new TextMode(this, this.timeEditor, this.valueController);
        this.dateEditorMode = new DateEditorMode(this, this.timeEditor);
        if (!this.isCalendarMode()) {
            this.textMode.run();
            this.textMode.setChecked(true);
        } else {
            this.dateEditorMode.setChecked(true);
        }
        this.primeEditorValue(value);
        this.timeEditor.createDateFormat(this.valueController.getValueType());
        this.timeEditor.setEditable(!this.valueController.isReadOnly());
        return this.timeEditor.getControl();
    }

    private boolean isCalendarMode() {
        return ModelPreferences.getPreferences().getBoolean("resultset.datetime.editor");
    }

    @Override
    public Object extractEditorValue() throws DBException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (DBCSession session = this.valueController.getExecutionContext().openSession((DBRProgressMonitor)new VoidProgressMonitor(), DBCExecutionPurpose.UTIL, "Make datetime value from editor");){
            if (!this.isCalendarMode()) {
                String strValue = this.timeEditor.getValueAsString();
                return this.valueController.getValueHandler().getValueFromObject(session, this.valueController.getValueType(), (Object)strValue, false, true);
            }
            Date dateValue = this.timeEditor.getValueAsDate();
            return this.valueController.getValueHandler().getValueFromObject(session, this.valueController.getValueType(), (Object)dateValue, false, true);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void contributeActions(@NotNull IContributionManager manager, @NotNull IValueController controller) throws DBCException {
        super.contributeActions(manager, controller);
        manager.add((IContributionItem)ActionUtils.makeActionContribution((IAction)this.textMode, (boolean)false));
        manager.add((IContributionItem)ActionUtils.makeActionContribution((IAction)this.dateEditorMode, (boolean)false));
        manager.update(true);
        this.timeEditor.getControl().layout();
    }

    @Override
    public void primeEditorValue(@Nullable Object value) {
        this.timeEditor.setTextValue(this.valueController.getValueHandler().getValueDisplayString(this.valueController.getValueType(), value, DBDDisplayFormat.EDIT));
        if (value == null) {
            this.timeEditor.setValue(null);
        } else if (value instanceof Time) {
            this.timeEditor.setValue((Date)((Time)value));
        } else if (value instanceof Timestamp) {
            this.timeEditor.setValue((Date)((Timestamp)value));
        } else if (value instanceof Date) {
            this.timeEditor.setValue((Date)value);
        } else if (this.isCalendarMode()) {
            DBWorkbench.getPlatformUI().showWarningMessageBox(ResultSetMessages.dialog_value_view_error_parsing_date_title, ResultSetMessages.dialog_value_view_error_parsing_date_message);
            this.textMode.run();
        }
        if (this.valueController.getEditType() == IValueController.EditType.INLINE) {
            this.timeEditor.selectAllContent();
        }
    }

    private static class DateEditorMode
    extends Action {
        private final DateTimeInlineEditor parent;
        CustomTimeEditor editor;

        DateEditorMode(DateTimeInlineEditor parent, CustomTimeEditor editor) {
            super("Calendar", 8);
            this.editor = editor;
            super.setText("Calendar");
            super.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)DBIcon.TYPE_DATETIME));
            this.parent = parent;
        }

        public void run() {
            Object value;
            super.run();
            if (this.parent.isCalendarMode()) {
                return;
            }
            if (this.parent.isDirty()) {
                try {
                    value = this.parent.extractEditorValue();
                    if (value instanceof Date || value == null) {
                        this.editor.setValue((Date)value);
                    }
                }
                catch (DBException e) {
                    DBWorkbench.getPlatformUI().showError(ResultSetMessages.dialog_value_view_dialog_error_updating_title, ResultSetMessages.dialog_value_view_dialog_error_updating_message, (Throwable)e);
                    return;
                }
            }
            try {
                value = this.parent.extractEditorValue();
                if (!(value instanceof Date) && value != null) {
                    DBWorkbench.getPlatformUI().showWarningMessageBox(ResultSetMessages.dialog_value_view_error_parsing_date_title, NLS.bind((String)ResultSetMessages.dialog_value_view_error_parsing_date_message, (Object)value));
                    ModelPreferences.getPreferences().setValue("resultset.datetime.editor", false);
                    this.setChecked(false);
                    this.parent.textMode.setChecked(true);
                    return;
                }
                this.editor.setToDateComposite();
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showError(ResultSetMessages.dialog_value_view_dialog_error_updating_title, ResultSetMessages.dialog_value_view_dialog_error_updating_message, (Throwable)e);
                return;
            }
            ModelPreferences.getPreferences().setValue("resultset.datetime.editor", true);
        }
    }

    private static class TextMode
    extends Action {
        private final DateTimeInlineEditor parent;
        CustomTimeEditor editor;
        protected final IValueController valueController;

        TextMode(DateTimeInlineEditor parent, CustomTimeEditor editor, IValueController valueController) {
            super("Text", 8);
            this.editor = editor;
            this.valueController = valueController;
            this.parent = parent;
            super.setText("Text");
            super.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.SQL_TEXT));
        }

        public void run() {
            super.run();
            if (this.parent.isDirty()) {
                try {
                    Object value = this.parent.extractEditorValue();
                    this.editor.setTextValue(this.valueController.getValueHandler().getValueDisplayString(this.valueController.getValueType(), value, DBDDisplayFormat.EDIT));
                }
                catch (DBException e) {
                    DBWorkbench.getPlatformUI().showError(ResultSetMessages.dialog_value_view_dialog_error_updating_title, ResultSetMessages.dialog_value_view_dialog_error_updating_message, (Throwable)e);
                    return;
                }
            }
            this.editor.setToTextComposite();
            ModelPreferences.getPreferences().setValue("resultset.datetime.editor", false);
        }
    }
}

