/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.sql.edit.struct;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataTypeProvider;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectWithDependencies;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.edit.prop.DBECommandComposite;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAbstract;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableColumn;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndexColumn;
import org.jkiss.utils.CommonUtils;

public abstract class SQLTableColumnManager<OBJECT_TYPE extends DBSEntityAttribute, TABLE_TYPE extends DBSEntity>
extends SQLObjectEditor<OBJECT_TYPE, TABLE_TYPE>
implements DBEObjectWithDependencies {
    public static final long DDL_FEATURE_OMIT_COLUMN_CLAUSE_IN_DROP = 1L;
    public static final long DDL_FEATURE_USER_BRACKETS_IN_DROP = 2L;
    public static final long FEATURE_ALTER_TABLE_ADD_COLUMN = 4L;
    public static final String QUOTE = "'";
    protected final ColumnModifier<OBJECT_TYPE> DataTypeModifier = (monitor, column, sql, command) -> {
        String typeName = column.getTypeName();
        DBPDataKind dataKind = column.getDataKind();
        DBSDataType dataType = SQLTableColumnManager.findDataType(column, typeName);
        sql.append(' ').append(typeName);
        if (dataType == null) {
            log.debug("Type name '" + typeName + "' is not supported by driver");
        } else {
            dataKind = dataType.getDataKind();
        }
        String modifiers = SQLUtils.getColumnTypeModifiers(column.getDataSource(), column, typeName, dataKind);
        if (modifiers != null) {
            sql.append(modifiers);
        }
    };
    protected final ColumnModifier<OBJECT_TYPE> NotNullModifier = (monitor, column, sql, command) -> {
        if (column.isRequired()) {
            sql.append(" NOT NULL");
        }
    };
    protected final ColumnModifier<OBJECT_TYPE> NullNotNullModifier = (monitor, column, sql, command) -> {
        StringBuilder stringBuilder = sql.append(column.isRequired() ? " NOT NULL" : " NULL");
    };
    protected final ColumnModifier<OBJECT_TYPE> NullNotNullModifierConditional = (monitor, column, sql, command) -> {
        if (command instanceof DBECommandComposite && ((DBECommandComposite)command).getProperty("required") == null) {
            return;
        }
        this.NullNotNullModifier.appendModifier(monitor, (DBSEntityAttribute)column, sql, command);
    };
    protected final ColumnModifier<OBJECT_TYPE> DefaultModifier = (monitor, column, sql, command) -> {
        String defaultValue = CommonUtils.toString((Object)column.getDefaultValue());
        if (!CommonUtils.isEmpty((String)defaultValue)) {
            DBPDataKind dataKind = column.getDataKind();
            boolean useQuotes = false;
            if (!defaultValue.startsWith(QUOTE) && !defaultValue.endsWith(QUOTE)) {
                char firstChar;
                if (useQuotes && defaultValue.trim().startsWith(QUOTE)) {
                    useQuotes = false;
                }
                if (dataKind == DBPDataKind.DATETIME && !Character.isLetter(firstChar = defaultValue.trim().charAt(0)) && firstChar != '(' && firstChar != '[') {
                    useQuotes = true;
                }
            }
            sql.append(" DEFAULT ");
            if (useQuotes) {
                sql.append(QUOTE);
            }
            sql.append(defaultValue);
            if (useQuotes) {
                sql.append(QUOTE);
            }
        }
    };

    protected ColumnModifier[] getSupportedModifiers(OBJECT_TYPE column, Map<String, Object> options) {
        return new ColumnModifier[]{this.DataTypeModifier, this.NotNullModifier, this.DefaultModifier};
    }

    @Override
    public boolean canEditObject(OBJECT_TYPE object) {
        DBSEntity table = object.getParentObject();
        return table != null && !DBUtils.isView(table);
    }

    @Override
    public boolean canCreateObject(Object container) {
        return container instanceof DBSTable && !((DBSTable)container).isView();
    }

    @Override
    public boolean canDeleteObject(OBJECT_TYPE object) {
        return this.canEditObject(object);
    }

    @Override
    public long getMakerOptions(DBPDataSource dataSource) {
        return 4L;
    }

    protected long getDDLFeatures(OBJECT_TYPE object) {
        return 0L;
    }

    private boolean hasDDLFeature(OBJECT_TYPE object, long feature) {
        return (this.getDDLFeatures(object) & feature) != 0L;
    }

    @Override
    protected void addObjectCreateActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
        DBSEntity table = ((DBSEntityAttribute)command.getObject()).getParentObject();
        StringBuilder sql = new StringBuilder(256);
        sql.append("ALTER TABLE ").append(DBUtils.getObjectFullName(table, DBPEvaluationContext.DDL)).append(" ADD ");
        if (this.hasDDLFeature((DBSEntityAttribute)command.getObject(), 4L)) {
            sql.append("COLUMN ");
        }
        sql.append((CharSequence)this.getNestedDeclaration(monitor, (TABLE_TYPE)table, (DBECommandAbstract<OBJECT_TYPE>)command, options));
        actions.add(new SQLDatabasePersistAction(ModelMessages.model_jdbc_create_new_table_column, sql.toString()));
    }

    @Override
    protected void addObjectDeleteActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) throws DBException {
        boolean useBrackets = this.hasDDLFeature((DBSEntityAttribute)command.getObject(), 2L);
        StringBuilder ddl = new StringBuilder();
        ddl.append("ALTER TABLE ").append(DBUtils.getObjectFullName(((DBSEntityAttribute)command.getObject()).getParentObject(), DBPEvaluationContext.DDL));
        ddl.append(" DROP ");
        if (useBrackets) {
            ddl.append('(');
        }
        if (!this.hasDDLFeature((DBSEntityAttribute)command.getObject(), 1L)) {
            ddl.append("COLUMN ");
        }
        ddl.append(DBUtils.getQuotedIdentifier((DBSObject)command.getObject()));
        if (useBrackets) {
            ddl.append(')');
        }
        actions.add(new SQLDatabasePersistAction(ModelMessages.model_jdbc_drop_table_column, ddl.toString()));
    }

    @NotNull
    protected String getNewColumnName(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, @NotNull TABLE_TYPE table) {
        return DBUtils.makeNewObjectName(monitor, "Column{0}", table, DBSEntityAttribute.class, DBSEntity::getAttribute, context);
    }

    @Override
    protected StringBuilder getNestedDeclaration(DBRProgressMonitor monitor, TABLE_TYPE owner, DBECommandAbstract<OBJECT_TYPE> command, Map<String, Object> options) {
        DBSEntityAttribute column = (DBSEntityAttribute)command.getObject();
        String columnName = DBUtils.getQuotedIdentifier(column.getDataSource(), column.getName());
        if (command instanceof SQLObjectEditor.ObjectRenameCommand) {
            columnName = DBUtils.getQuotedIdentifier(column.getDataSource(), ((SQLObjectEditor.ObjectRenameCommand)command).getNewName());
        }
        StringBuilder decl = new StringBuilder(40);
        decl.append(columnName);
        ColumnModifier[] columnModifierArray = this.getSupportedModifiers(column, options);
        int n = columnModifierArray.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnModifier modifier = columnModifierArray[n2];
            modifier.appendModifier(monitor, column, decl, command);
            ++n2;
        }
        return decl;
    }

    @Override
    protected void validateObjectProperties(DBRProgressMonitor monitor, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) throws DBException {
        if (CommonUtils.isEmpty((String)((DBSEntityAttribute)command.getObject()).getName())) {
            throw new DBException("Column name cannot be empty");
        }
        if (CommonUtils.isEmpty((String)((DBSEntityAttribute)command.getObject()).getTypeName())) {
            throw new DBException("Column type name cannot be empty");
        }
    }

    private static DBSDataType findDataType(DBSObject object, String typeName) {
        DBPDataTypeProvider dataTypeProvider = DBUtils.getParentOfType(DBPDataTypeProvider.class, object);
        if (dataTypeProvider != null) {
            return dataTypeProvider.getLocalDataType(typeName);
        }
        return null;
    }

    protected static DBSDataType findBestDataType(DBSObject object, String ... typeNames) {
        DBPDataTypeProvider dataTypeProvider = DBUtils.getParentOfType(DBPDataTypeProvider.class, object);
        if (dataTypeProvider != null) {
            return DBUtils.findBestDataType(dataTypeProvider.getLocalDataTypes(), typeNames);
        }
        return null;
    }

    @Override
    public List<? extends DBSObject> getDependentObjectsList(DBRProgressMonitor monitor, DBSObject object) throws DBException {
        Collection<? extends DBSTableIndex> indexes;
        DBSObject dbsObject = object.getParentObject();
        HashSet<DBSObject> dependentObjectsList = new HashSet<DBSObject>();
        if (dbsObject instanceof DBSEntity && object instanceof DBSEntityAttribute) {
            Collection<? extends DBSEntityAssociation> collection;
            DBSEntity parentObject = (DBSEntity)dbsObject;
            Collection<? extends DBSEntityConstraint> collection2 = parentObject.getConstraints(monitor);
            if (!CommonUtils.isEmpty(collection2)) {
                for (DBSEntityConstraint dBSEntityConstraint : collection2) {
                    this.addDependentConstraints(monitor, (DBSEntityAttribute)object, dependentObjectsList, dBSEntityConstraint);
                }
            }
            if (!CommonUtils.isEmpty(collection = parentObject.getAssociations(monitor))) {
                for (DBSEntityAssociation dBSEntityAssociation : collection) {
                    this.addDependentConstraints(monitor, (DBSEntityAttribute)object, dependentObjectsList, dBSEntityAssociation);
                }
            }
        }
        if (dbsObject instanceof DBSTable && !CommonUtils.isEmpty(indexes = ((DBSTable)dbsObject).getIndexes(monitor))) {
            block2: for (DBSTableIndex dBSTableIndex : indexes) {
                List<? extends DBSTableIndexColumn> list = dBSTableIndex.getAttributeReferences(monitor);
                if (CommonUtils.isEmpty(list)) continue;
                for (DBSTableIndexColumn dBSTableIndexColumn : list) {
                    DBSTableColumn tableColumn = dBSTableIndexColumn.getTableColumn();
                    if (tableColumn != object) continue;
                    dependentObjectsList.add(dBSTableIndex);
                    continue block2;
                }
            }
        }
        return new ArrayList(dependentObjectsList);
    }

    private void addDependentConstraints(DBRProgressMonitor monitor, DBSEntityAttribute object, Set<DBSObject> dependentObjectsList, DBSObject constraint) throws DBException {
        List<? extends DBSEntityAttributeRef> attributeReferences;
        if (constraint instanceof DBSEntityReferrer && !CommonUtils.isEmpty(attributeReferences = ((DBSEntityReferrer)constraint).getAttributeReferences(monitor))) {
            for (DBSEntityAttributeRef dBSEntityAttributeRef : attributeReferences) {
                if (dBSEntityAttributeRef.getAttribute() != object) continue;
                dependentObjectsList.add(constraint);
                break;
            }
        }
    }

    public static void addColumnCommentAction(List<DBEPersistAction> actionList, DBSEntityAttribute column, DBSEntity table) {
        actionList.add(new SQLDatabasePersistAction("Comment column", "COMMENT ON COLUMN " + DBUtils.getObjectFullName(table, DBPEvaluationContext.DDL) + "." + DBUtils.getQuotedIdentifier(column) + " IS " + SQLUtils.quoteString(column.getDataSource(), CommonUtils.notEmpty((String)column.getDescription()))));
    }

    protected static interface ColumnModifier<OBJECT_TYPE extends DBPObject> {
        public void appendModifier(DBRProgressMonitor var1, OBJECT_TYPE var2, StringBuilder var3, DBECommandAbstract<OBJECT_TYPE> var4);
    }
}

