/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.maven;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.connection.DBPAuthInfo;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.registry.VersionUtils;
import org.jkiss.dbeaver.registry.maven.IMavenIdentifier;
import org.jkiss.dbeaver.registry.maven.MavenArtifactReference;
import org.jkiss.dbeaver.registry.maven.MavenArtifactVersion;
import org.jkiss.dbeaver.registry.maven.MavenRegistry;
import org.jkiss.dbeaver.registry.maven.MavenRepository;
import org.jkiss.dbeaver.registry.maven.versioning.DefaultArtifactVersion;
import org.jkiss.dbeaver.registry.maven.versioning.VersionRange;
import org.jkiss.dbeaver.runtime.WebUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;
import org.jkiss.utils.xml.SAXListener;
import org.jkiss.utils.xml.SAXReader;
import org.jkiss.utils.xml.XMLException;
import org.xml.sax.Attributes;

public class MavenArtifact
implements IMavenIdentifier {
    private static final Log log = Log.getLog(MavenArtifact.class);
    public static final String MAVEN_METADATA_XML = "maven-metadata.xml";
    public static final String FILE_JAR = "jar";
    public static final String FILE_POM = "pom";
    public static final String PACKAGING_BUNDLE = "bundle";
    @NotNull
    private final MavenRepository repository;
    @NotNull
    private final String groupId;
    @NotNull
    private final String artifactId;
    @Nullable
    private final String fallbackVersion;
    private final List<String> versions = new ArrayList<String>();
    private String latestVersion;
    private String releaseVersion;
    private Date lastUpdate;
    private final List<MavenArtifactVersion> localVersions = new ArrayList<MavenArtifactVersion>();
    private transient boolean metadataLoaded = false;

    public MavenArtifact(@NotNull MavenRepository repository, @NotNull String groupId, @NotNull String artifactId, @Nullable String fallbackVersion) {
        this.repository = repository;
        this.groupId = CommonUtils.trim((String)groupId);
        this.artifactId = CommonUtils.trim((String)artifactId);
        this.fallbackVersion = CommonUtils.trim((String)fallbackVersion);
    }

    public void loadMetadata(DBRProgressMonitor monitor) throws IOException {
        block28: {
            this.latestVersion = null;
            this.releaseVersion = null;
            this.versions.clear();
            this.lastUpdate = null;
            String metadataPath = String.valueOf(this.getBaseArtifactURL()) + MAVEN_METADATA_XML;
            monitor.subTask("Load metadata " + this);
            try {
                Throwable throwable = null;
                Object var4_7 = null;
                try (InputStream mdStream = WebUtils.openConnection((String)metadataPath, (DBPAuthInfo)this.getRepository().getAuthInfo(), null).getInputStream();){
                    this.parseMetadata(mdStream);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (XMLException e) {
                log.warn((Object)"Error parsing artifact metadata", (Throwable)e);
                this.removeIgnoredVersions();
                monitor.worked(1);
                break block28;
            }
            catch (IOException e) {
                try {
                    try {
                        Throwable throwable = null;
                        Object var5_12 = null;
                        try (InputStream dirStream = WebUtils.openConnection((String)this.getBaseArtifactURL(), (DBPAuthInfo)this.getRepository().getAuthInfo(), null).getInputStream();){
                            this.parseDirectory(dirStream);
                            break block28;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    catch (XMLException xMLException) {
                        log.warn((Object)"Error parsing artifact directory", (Throwable)e);
                    }
                    break block28;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.removeIgnoredVersions();
                    monitor.worked(1);
                }
            }
            this.removeIgnoredVersions();
            monitor.worked(1);
        }
        this.metadataLoaded = true;
    }

    private void removeIgnoredVersions() {
        Iterator<String> iter = this.versions.iterator();
        while (iter.hasNext()) {
            String version = iter.next();
            if (!MavenRegistry.getInstance().isVersionIgnored(String.valueOf(this.groupId) + ":" + this.artifactId + ":" + version)) continue;
            iter.remove();
        }
    }

    private void parseDirectory(InputStream dirStream) throws IOException, XMLException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtils.copyStream((InputStream)dirStream, (OutputStream)baos);
        String dir = baos.toString();
        Pattern hrefPattern = Pattern.compile("a href=\"(.+)/?\"");
        Matcher matcher = hrefPattern.matcher(dir);
        while (matcher.find()) {
            String href = matcher.group(1);
            while (href.endsWith("/")) {
                href = href.substring(0, href.length() - 1);
            }
            int divPos = href.lastIndexOf(47);
            if (divPos != -1) {
                href = href.substring(divPos + 1);
            }
            if (href.equals("..")) continue;
            this.versions.add(href);
        }
    }

    private void parseMetadata(InputStream mdStream) throws IOException, XMLException {
        SAXReader reader = new SAXReader(mdStream);
        reader.parse(new SAXListener(){
            public String lastTag;

            public void saxStartElement(SAXReader reader, String namespaceURI, String localName, Attributes atts) throws XMLException {
                this.lastTag = localName;
            }

            public void saxText(SAXReader reader, String data) throws XMLException {
                if ("version".equals(this.lastTag)) {
                    MavenArtifact.this.versions.add(data);
                } else if ("latest".equals(this.lastTag)) {
                    MavenArtifact.this.latestVersion = data;
                } else if ("release".equals(this.lastTag)) {
                    MavenArtifact.this.releaseVersion = data;
                } else if ("lastUpdate".equals(this.lastTag)) {
                    try {
                        MavenArtifact.this.lastUpdate = new Date(Long.parseLong(data));
                    }
                    catch (NumberFormatException e) {
                        log.warn((Object)e);
                    }
                }
            }

            public void saxEndElement(SAXReader reader, String namespaceURI, String localName) throws XMLException {
                this.lastTag = null;
            }
        });
    }

    @NotNull
    public MavenRepository getRepository() {
        return this.repository;
    }

    @Override
    @NotNull
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    @NotNull
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    @Nullable
    public String getFallbackVersion() {
        return this.fallbackVersion;
    }

    @Override
    @NotNull
    public String getVersion() {
        return "";
    }

    @Override
    @NotNull
    public String getId() {
        return MavenArtifactReference.makeId(this);
    }

    @Nullable
    public Collection<String> getAvailableVersions(DBRProgressMonitor monitor, String versionSpec) throws IOException {
        if (CommonUtils.isEmpty(this.versions) && !this.metadataLoaded) {
            this.loadMetadata(monitor);
        }
        if (!MavenArtifact.isVersionPattern(versionSpec)) {
            return this.versions;
        }
        Pattern versionPattern = null;
        VersionRange versionRange = null;
        if (versionSpec.startsWith("{") && versionSpec.endsWith("}")) {
            try {
                versionPattern = Pattern.compile(versionSpec.substring(1, versionSpec.length() - 1));
            }
            catch (Exception exception) {
                log.error((Object)("Bad version pattern: " + versionSpec));
            }
        } else {
            try {
                versionRange = VersionRange.createFromVersionSpec(versionSpec);
            }
            catch (Exception exception) {
                log.error((Object)("Bad version specification: " + versionSpec));
            }
        }
        ArrayList<String> filtered = new ArrayList<String>();
        for (String version : this.versions) {
            boolean matches = versionPattern != null ? versionPattern.matcher(version).matches() : (versionRange != null ? versionRange.containsVersion(new DefaultArtifactVersion(version)) : true);
            if (!matches) continue;
            filtered.add(version);
        }
        return filtered;
    }

    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    private String getBaseArtifactURL() {
        String dir = String.valueOf(this.groupId.replace('.', '/')) + "/" + this.artifactId;
        return String.valueOf(this.repository.getUrl()) + dir + "/";
    }

    public String getFileURL(String version, String fileType) {
        return String.valueOf(this.getBaseArtifactURL()) + version + "/" + this.getVersionFileName(version, fileType);
    }

    @NotNull
    String getVersionFileName(@NotNull String version, @NotNull String fileType) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.artifactId).append("-").append(version);
        if (FILE_JAR.equals(fileType) && !CommonUtils.isEmpty((String)this.fallbackVersion)) {
            sb.append('-').append(this.fallbackVersion);
        }
        sb.append(".").append(fileType);
        return sb.toString();
    }

    public String toString() {
        return this.getId();
    }

    @Nullable
    public MavenArtifactVersion getVersion(String versionStr) {
        for (MavenArtifactVersion version : this.localVersions) {
            if (!CommonUtils.equalObjects((Object)version.getVersion(), (Object)versionStr)) continue;
            return version;
        }
        return null;
    }

    private MavenArtifactVersion makeLocalVersion(DBRProgressMonitor monitor, String versionStr, boolean setActive, boolean resolveOptionalDependencies) throws IllegalArgumentException, IOException {
        MavenArtifactVersion version = this.getVersion(versionStr);
        if (version == null) {
            version = new MavenArtifactVersion(monitor, this, versionStr, resolveOptionalDependencies);
            this.localVersions.add(version);
        }
        return version;
    }

    public MavenArtifactVersion resolveVersion(@NotNull DBRProgressMonitor monitor, @NotNull String versionRef, boolean resolveOptionalDependencies) throws IOException {
        MavenArtifactVersion localVersion;
        String versionInfo;
        boolean lookupVersion;
        block23: {
            block21: {
                if (CommonUtils.isEmpty((String)versionRef)) {
                    throw new IOException("Empty artifact " + this + " version");
                }
                boolean predefinedVersion = versionRef.equals("RELEASE") || versionRef.equals("LATEST") || versionRef.equals("SNAPSHOT");
                boolean bl = lookupVersion = predefinedVersion || MavenArtifact.isVersionPattern(versionRef);
                if (lookupVersion && !this.metadataLoaded) {
                    this.loadMetadata(monitor);
                }
                if (!lookupVersion) break block21;
                List<String> allVersions = this.versions;
                switch (versionRef) {
                    case "RELEASE": {
                        versionInfo = this.releaseVersion;
                        if (CommonUtils.isEmpty((String)versionInfo) || !VersionUtils.isBetaVersion(versionInfo)) break;
                        versionInfo = null;
                        break;
                    }
                    case "LATEST": {
                        versionInfo = this.latestVersion;
                        break;
                    }
                    default: {
                        if (versionRef.startsWith("{") && versionRef.endsWith("}")) {
                            String regex = versionRef.substring(1, versionRef.length() - 1);
                            try {
                                Pattern versionPattern = Pattern.compile(regex);
                                ArrayList<String> versions = new ArrayList<String>(allVersions);
                                Iterator iter = versions.iterator();
                                while (iter.hasNext()) {
                                    if (versionPattern.matcher((CharSequence)iter.next()).matches()) continue;
                                    iter.remove();
                                }
                                versionInfo = VersionUtils.findLatestVersion(versions);
                                break;
                            }
                            catch (Exception exception) {
                                throw new IOException("Bad version pattern: " + regex);
                            }
                        }
                        versionInfo = this.getVersionFromSpec(versionRef);
                    }
                }
                if (versionInfo == null) {
                    if (allVersions.isEmpty()) {
                        throw new IOException("Artifact '" + this + "' has empty version list");
                    }
                    versionInfo = VersionUtils.findLatestVersion(allVersions);
                }
                break block23;
            }
            versionInfo = versionRef.startsWith("[") || versionRef.startsWith("(") ? this.getVersionFromSpec(versionRef) : versionRef;
        }
        if ((localVersion = this.getVersion(versionInfo)) == null) {
            try {
                localVersion = this.makeLocalVersion(monitor, versionInfo, lookupVersion, resolveOptionalDependencies);
            }
            catch (IOException e) {
                log.debug((Object)("Error loading version info: " + e.getMessage()));
            }
        }
        return localVersion;
    }

    public static boolean versionMatches(String version, String versionSpec) {
        try {
            if (versionSpec.startsWith("{") && versionSpec.endsWith("}")) {
                Pattern versionPattern = Pattern.compile(versionSpec.substring(1, versionSpec.length() - 1));
                return versionPattern.matcher(version).matches();
            }
            return VersionRange.createFromVersionSpec(versionSpec).containsVersion(new DefaultArtifactVersion(version));
        }
        catch (Exception e) {
            log.debug((Object)e);
            return false;
        }
    }

    @Nullable
    private String getVersionFromSpec(String versionRef) throws IOException {
        String versionInfo;
        try {
            VersionRange range = VersionRange.createFromVersionSpec(versionRef);
            versionInfo = range.getRecommendedVersion() != null ? range.getRecommendedVersion().toString() : (!range.getRestrictions().isEmpty() ? range.getRestrictions().get(0).getLowerBound().toString() : null);
        }
        catch (Exception e) {
            throw new IOException("Bad version pattern: " + versionRef, e);
        }
        return versionInfo;
    }

    private static boolean isVersionPattern(String versionSpec) {
        if (versionSpec.isEmpty()) {
            return false;
        }
        char firstChar = versionSpec.charAt(0);
        char lastChar = versionSpec.charAt(versionSpec.length() - 1);
        return firstChar == '[' || firstChar == '(' || firstChar == '{' || lastChar == ']' || lastChar == ')' || lastChar == '}' || versionSpec.contains(",");
    }
}

