/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.parser.common;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.dbeaver.parser.common.ParseResult;
import org.jkiss.dbeaver.parser.common.ParserDispatchResult;
import org.jkiss.dbeaver.parser.common.ParserFsm;
import org.jkiss.dbeaver.parser.common.ParserFsmNode;
import org.jkiss.dbeaver.parser.common.ParserStack;
import org.jkiss.dbeaver.parser.common.ParserState;
import org.jkiss.dbeaver.parser.common.grammar.GrammarInfo;
import org.jkiss.dbeaver.parser.common.grammar.nfa.GrammarNfaOperation;

public class Parser {
    private final GrammarInfo grammar;
    private final ParserFsm fsm;

    public Parser(GrammarInfo grammar, ParserFsm fsm) {
        this.grammar = grammar;
        this.fsm = fsm;
    }

    public ParseResult parse(String text) {
        ArrayDeque<ParserState> queue = new ArrayDeque<ParserState>();
        for (ParserFsmNode initialState : this.fsm.getInitialStates()) {
            queue.addLast(ParserState.initial(initialState));
        }
        ArrayList<ParserDispatchResult> dispatchResults = new ArrayList<ParserDispatchResult>();
        ParserState boundary = null;
        ArrayList<ParserState> results = new ArrayList<ParserState>();
        while (!queue.isEmpty()) {
            ParserState state = (ParserState)queue.removeFirst();
            if (boundary == null || boundary.getPosition() > state.getPosition()) {
                boundary = state;
            }
            dispatchResults.clear();
            state.getFsmState().dispatch(text, state.getPosition(), dispatchResults);
            for (ParserDispatchResult result : dispatchResults) {
                ParserStack newStack = Parser.evaluateOperations(state.getStack(), result.getStep().getOperations());
                if (newStack == null) continue;
                ParserState nextState = state.capture(result.getEnd(), result.getStep().getTo(), result.getStep(), newStack);
                if (result.getStep().getTo() == null || result.getStep().getTo().isEnd()) {
                    if (nextState.getPosition() < text.length()) continue;
                    results.add(nextState);
                    continue;
                }
                queue.add(nextState);
            }
        }
        return new ParseResult(text, this.grammar, boundary, results);
    }

    private static ParserStack evaluateOperations(ParserStack stack, List<GrammarNfaOperation> ops) {
        ParserStack newStack = stack;
        for (GrammarNfaOperation op : ops) {
            switch (op.getKind()) {
                case RULE_START: 
                case CALL: 
                case LOOP_ENTER: 
                case SEQ_ENTER: {
                    newStack = newStack.push(op.getExprId(), 0, op.getRule());
                    break;
                }
                case RULE_END: 
                case RESUME: {
                    if (newStack.getExprId() == op.getExprId() && newStack.getRule() == op.getRule()) {
                        newStack = newStack.pop();
                        break;
                    }
                    return null;
                }
                case LOOP_INCREMENT: {
                    if (newStack.getExprId() == op.getExprId() && newStack.getExprPosition() <= op.getMaxIterations()) {
                        newStack = newStack.pop().push(op.getExprId(), newStack.getExprPosition() + 1, op.getRule());
                        break;
                    }
                    return null;
                }
                case LOOP_EXIT: {
                    if (newStack.getExprId() == op.getExprId() && newStack.getExprPosition() <= op.getMaxIterations() && newStack.getExprPosition() >= op.getMinIterations()) {
                        newStack = newStack.pop();
                        break;
                    }
                    return null;
                }
                case SEQ_STEP: {
                    if (newStack.getExprId() == op.getExprId() && newStack.getExprPosition() <= op.getMaxIterations() && newStack.getExprPosition() + 1 == op.getExprPosition()) {
                        newStack = newStack.pop().push(op.getExprId(), op.getExprPosition(), op.getRule());
                        break;
                    }
                    return null;
                }
                case SEQ_EXIT: {
                    if (newStack.getExprId() == op.getExprId() && newStack.getExprPosition() + 1 == op.getMaxIterations()) {
                        newStack = newStack.pop();
                        break;
                    }
                    return null;
                }
                default: {
                    throw new UnsupportedOperationException("Unexpected parse opeation kind " + (Object)((Object)op.getKind()));
                }
            }
        }
        return newStack;
    }
}

