/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.ui.config;

import java.util.Map;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCatalog;
import org.jkiss.dbeaver.ext.mysql.model.MySQLPrivilege;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableBase;
import org.jkiss.dbeaver.ext.mysql.model.MySQLUser;
import org.jkiss.dbeaver.ext.mysql.ui.internal.MySQLUIMessages;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommand;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAbstract;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class MySQLCommandGrantPrivilege
extends DBECommandAbstract<MySQLUser> {
    private boolean grant;
    private boolean withGrantOption;
    private MySQLCatalog schema;
    private MySQLTableBase table;
    private MySQLPrivilege privilege;

    public MySQLCommandGrantPrivilege(MySQLUser user, boolean grant, boolean withGrantOption, MySQLCatalog schema, MySQLTableBase table, MySQLPrivilege privilege) {
        super((DBPObject)user, grant ? MySQLUIMessages.edit_command_grant_privilege_action_grant_privilege : MySQLUIMessages.edit_command_grant_privilege_name_revoke_privilege);
        this.grant = grant;
        this.withGrantOption = withGrantOption;
        this.schema = schema;
        this.table = table;
        this.privilege = privilege;
    }

    public void updateModel() {
        ((MySQLUser)this.getObject()).clearGrantsCache();
    }

    public DBEPersistAction[] getPersistActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, Map<String, Object> options) {
        String privName = this.privilege.getFixedPrivilegeName();
        String grantScript = "GRANT " + privName + " ON " + this.getObjectName() + " TO " + ((MySQLUser)this.getObject()).getFullName() + (this.withGrantOption ? " WITH GRANT OPTION" : "");
        String revokeScript = "REVOKE " + privName + " ON " + this.getObjectName() + " FROM " + ((MySQLUser)this.getObject()).getFullName();
        return new DBEPersistAction[]{new SQLDatabasePersistAction(MySQLUIMessages.edit_command_grant_privilege_action_grant_privilege, this.grant ? grantScript : revokeScript)};
    }

    public DBECommand<?> merge(DBECommand<?> prevCommand, Map<Object, Object> userParams) {
        if (prevCommand instanceof MySQLCommandGrantPrivilege) {
            MySQLCommandGrantPrivilege prevGrant = (MySQLCommandGrantPrivilege)prevCommand;
            if (prevGrant.schema == this.schema && prevGrant.table == this.table) {
                if (prevGrant.privilege == this.privilege) {
                    if (prevGrant.grant == this.grant) {
                        return prevCommand;
                    }
                    return null;
                }
                if ("Grant option".equals(this.privilege.getName()) && this.withGrantOption) {
                    prevGrant.withGrantOption = true;
                    return prevCommand;
                }
            }
        }
        return super.merge(prevCommand, userParams);
    }

    private String getObjectName() {
        return String.valueOf(this.schema == null ? "*" : DBUtils.getQuotedIdentifier((DBSObject)this.schema)) + "." + (this.table == null ? "*" : DBUtils.getQuotedIdentifier((DBSObject)this.table));
    }
}

