/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.qm.meta;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.exec.DBCSavepoint;
import org.jkiss.dbeaver.model.qm.meta.QMMConnectionInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMObject;
import org.jkiss.dbeaver.model.qm.meta.QMMTransactionSavepointInfo;

public class QMMTransactionInfo
extends QMMObject {
    private final QMMConnectionInfo connection;
    private final QMMTransactionInfo previous;
    private boolean committed;
    private final QMMTransactionSavepointInfo savepointStack;

    QMMTransactionInfo(QMMConnectionInfo connection, QMMTransactionInfo previous) {
        this.connection = connection;
        this.previous = previous;
        this.savepointStack = new QMMTransactionSavepointInfo(this, null, null, null);
    }

    private QMMTransactionInfo(Builder builder) {
        this.connection = builder.connection;
        this.previous = builder.previous;
        this.committed = builder.committed;
        this.savepointStack = builder.savepointStack;
    }

    public static Builder builder() {
        return new Builder();
    }

    void commit() {
        this.committed = true;
        QMMTransactionSavepointInfo sp = this.savepointStack;
        while (sp != null) {
            if (!sp.isClosed()) {
                sp.close(true);
            }
            sp = sp.getPrevious();
        }
        super.close();
    }

    void rollback(DBCSavepoint toSavepoint) {
        this.committed = false;
        QMMTransactionSavepointInfo sp = this.savepointStack;
        while (sp != null) {
            sp.close(false);
            if (toSavepoint != null && sp.getReference() == toSavepoint) break;
            sp = sp.getPrevious();
        }
        super.close();
    }

    @Override
    public QMMConnectionInfo getConnection() {
        return this.connection;
    }

    @Override
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("connection", this.getConnection().toMap());
        return result;
    }

    public static QMMTransactionInfo fromMap(Map<String, Object> objectMap) {
        QMMConnectionInfo connectionInfo = QMMConnectionInfo.fromMap(JSONUtils.getObject(objectMap, "connection"));
        return QMMTransactionInfo.builder().setConnection(connectionInfo).build();
    }

    public QMMTransactionInfo getPrevious() {
        return this.previous;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public QMMTransactionSavepointInfo getCurrentSavepoint() {
        return this.savepointStack;
    }

    public QMMObject getSavepoint(DBCSavepoint savepoint) {
        QMMTransactionSavepointInfo sp = this.savepointStack;
        while (sp != null) {
            if (sp.getReference() == savepoint) {
                return sp;
            }
            sp = sp.getPrevious();
        }
        return null;
    }

    public String toString() {
        return "TRANSACTION";
    }

    @Override
    public String getText() {
        return this.connection.getText();
    }

    @Override
    public QMMObject.ObjectType getObjectType() {
        return QMMObject.ObjectType.TransactionInfo;
    }

    public static final class Builder {
        private QMMConnectionInfo connection;
        private QMMTransactionInfo previous;
        private boolean committed;
        private QMMTransactionSavepointInfo savepointStack;

        private Builder() {
        }

        public Builder setConnection(QMMConnectionInfo connection) {
            this.connection = connection;
            return this;
        }

        public Builder setPrevious(QMMTransactionInfo previous) {
            this.previous = previous;
            return this;
        }

        public Builder setCommitted(boolean committed) {
            this.committed = committed;
            return this;
        }

        public Builder setSavepointStack(QMMTransactionSavepointInfo savepointStack) {
            this.savepointStack = savepointStack;
            return this;
        }

        public QMMTransactionInfo build() {
            return new QMMTransactionInfo(this);
        }
    }
}

