/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.preferences;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.internal.SQLEditorMessages;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.dbeaver.utils.PrefUtils;

public class PrefPageSQLCodeEditing
extends AbstractPrefPage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    private static final Log log = Log.getLog(PrefPageSQLCodeEditing.class);
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.main.sql.codeeditor";
    private Button csFoldingEnabled;
    private Button csMarkOccurrencesUnderCursor;
    private Button csMarkOccurrencesForSelection;
    private Button csProblemMarkersEnabled;
    private Button acSingleQuotesCheck;
    private Button acDoubleQuotesCheck;
    private Button acBracketsCheck;
    private Button afKeywordCase;
    private Button afExtractFromSource;

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        Composite composite = UIUtils.createComposite((Composite)parent, (int)1);
        Group foldingGroup = UIUtils.createControlGroup((Composite)composite, (String)SQLEditorMessages.pref_page_sql_completion_group_misc, (int)2, (int)34, (int)0);
        this.csMarkOccurrencesUnderCursor = UIUtils.createCheckbox((Composite)foldingGroup, (String)SQLEditorMessages.pref_page_sql_completion_label_mark_occurrences, (String)SQLEditorMessages.pref_page_sql_completion_label_mark_occurrences_tip, (boolean)false, (int)2);
        this.csMarkOccurrencesForSelection = UIUtils.createCheckbox((Composite)foldingGroup, (String)SQLEditorMessages.pref_page_sql_completion_label_mark_occurrences_for_selections, (String)SQLEditorMessages.pref_page_sql_completion_label_mark_occurrences_for_selections_tip, (boolean)false, (int)2);
        this.csFoldingEnabled = UIUtils.createCheckbox((Composite)foldingGroup, (String)SQLEditorMessages.pref_page_sql_completion_label_folding_enabled, (String)SQLEditorMessages.pref_page_sql_completion_label_folding_enabled_tip, (boolean)false, (int)2);
        this.csProblemMarkersEnabled = UIUtils.createCheckbox((Composite)foldingGroup, (String)SQLEditorMessages.pref_page_sql_completion_label_problem_markers_enabled, (String)SQLEditorMessages.pref_page_sql_completion_label_problem_markers_enabled_tip, (boolean)false, (int)2);
        Group acGroup = UIUtils.createControlGroup((Composite)composite, (String)SQLEditorMessages.pref_page_sql_format_group_auto_close, (int)1, (int)34, (int)0);
        this.acSingleQuotesCheck = UIUtils.createCheckbox((Composite)acGroup, (String)SQLEditorMessages.pref_page_sql_format_label_single_quotes, (boolean)false);
        this.acDoubleQuotesCheck = UIUtils.createCheckbox((Composite)acGroup, (String)SQLEditorMessages.pref_page_sql_format_label_double_quotes, (boolean)false);
        this.acBracketsCheck = UIUtils.createCheckbox((Composite)acGroup, (String)SQLEditorMessages.pref_page_sql_format_label_brackets, (boolean)false);
        Group afGroup = UIUtils.createControlGroup((Composite)composite, (String)SQLEditorMessages.pref_page_sql_format_group_auto_format, (int)1, (int)34, (int)0);
        this.afKeywordCase = UIUtils.createCheckbox((Composite)afGroup, (String)SQLEditorMessages.pref_page_sql_format_label_convert_keyword_case, (String)SQLEditorMessages.pref_page_sql_format_label_convert_keyword_case_tip, (boolean)false, (int)1);
        this.afExtractFromSource = UIUtils.createCheckbox((Composite)afGroup, (String)SQLEditorMessages.pref_page_sql_format_label_extract_sql_from_source_code, (String)SQLEditorMessages.pref_page_sql_format_label_extract_sql_from_source_code_tip, (boolean)false, (int)1);
        this.performDefaults();
        return composite;
    }

    protected void performDefaults() {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        try {
            this.csFoldingEnabled.setSelection(store.getBoolean("SQLEditor.Folding.enabled"));
            this.csMarkOccurrencesUnderCursor.setSelection(store.getBoolean("SQLEditor.markOccurrences"));
            this.csMarkOccurrencesForSelection.setSelection(store.getBoolean("SQLEditor.markOccurrences.forSelection"));
            this.csProblemMarkersEnabled.setSelection(store.getBoolean("SQLEditor.problemMarkers.enabled"));
            this.acSingleQuotesCheck.setSelection(store.getBoolean("SQLEditor.closeSingleQuotes"));
            this.acDoubleQuotesCheck.setSelection(store.getBoolean("SQLEditor.closeDoubleQuotes"));
            this.acBracketsCheck.setSelection(store.getBoolean("SQLEditor.closeBrackets"));
            this.afKeywordCase.setSelection(store.getBoolean("SQLEditor.format.keywordCaseAuto"));
            this.afExtractFromSource.setSelection(store.getBoolean("SQLEditor.format.extractFromSource"));
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
    }

    public boolean performOk() {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        try {
            store.setValue("SQLEditor.Folding.enabled", this.csFoldingEnabled.getSelection());
            store.setValue("SQLEditor.markOccurrences", this.csMarkOccurrencesUnderCursor.getSelection());
            store.setValue("SQLEditor.markOccurrences.forSelection", this.csMarkOccurrencesForSelection.getSelection());
            store.setValue("SQLEditor.problemMarkers.enabled", this.csProblemMarkersEnabled.getSelection());
            store.setValue("SQLEditor.closeSingleQuotes", this.acSingleQuotesCheck.getSelection());
            store.setValue("SQLEditor.closeDoubleQuotes", this.acDoubleQuotesCheck.getSelection());
            store.setValue("SQLEditor.closeBrackets", this.acBracketsCheck.getSelection());
            store.setValue("SQLEditor.format.keywordCaseAuto", this.afKeywordCase.getSelection());
            store.setValue("SQLEditor.format.extractFromSource", this.afExtractFromSource.getSelection());
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
        return super.performOk();
    }

    public void init(IWorkbench workbench) {
    }

    public IAdaptable getElement() {
        return null;
    }

    public void setElement(IAdaptable element) {
    }
}

