/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.finder;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.jkiss.dbeaver.ui.controls.finder.AdvancedList;
import org.jkiss.utils.CommonUtils;

public class AdvancedListItem {
    static final int BORDER_MARGIN = 5;
    private final AdvancedList list;
    private final Object data;
    private final ILabelProvider labelProvider;
    private final TextLayout textLayout;

    public AdvancedListItem(AdvancedList list, Object item, ILabelProvider labelProvider) {
        this.labelProvider = labelProvider;
        this.list = list;
        this.list.addItem(this);
        this.data = item;
        this.textLayout = new TextLayout((Device)list.getDisplay());
        this.textLayout.setFont(list.getFont());
        this.textLayout.setText(labelProvider.getText(item));
    }

    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public Object getData() {
        return this.data;
    }

    void painItem(GC gc, int x, int y) {
        boolean isHover;
        Point itemSize = this.list.getItemSize();
        if (itemSize.x <= 0 || itemSize.y <= 0) {
            return;
        }
        boolean isSelected = this.list.getSelectedItem() == this;
        boolean bl = isHover = this == this.list.getHoverItem();
        if (isSelected) {
            gc.setBackground(this.list.getSelectionBackgroundColor());
            gc.setForeground(this.list.getSelectionForegroundColor());
        } else if (isHover) {
            gc.setBackground(this.list.getHoverBackgroundColor());
            gc.setForeground(this.list.getForegroundColor());
        } else {
            gc.setBackground(this.list.getBackground());
            gc.setForeground(this.list.getForegroundColor());
        }
        if (isSelected || isHover) {
            gc.fillRoundRectangle(x + 2, y + 2, itemSize.x - 4, itemSize.y - 4, 10, 10);
        } else {
            gc.fillRectangle(x, y, itemSize.x, itemSize.y);
        }
        Image icon = this.labelProvider.getImage(this.data);
        Rectangle iconBounds = icon.getBounds();
        Point imageSize = this.list.getImageSize();
        int imgPosX = (itemSize.x - imageSize.x) / 2;
        int imgPosY = 5;
        if (iconBounds.width == imageSize.x && iconBounds.height == imageSize.y) {
            gc.drawImage(icon, x + imgPosX, y + imgPosY);
        } else {
            gc.drawImage(icon, 0, 0, iconBounds.width, iconBounds.height, x + imgPosX, y + imgPosY, imageSize.x, imageSize.y);
        }
        gc.setAntialias(1);
        gc.setInterpolation(2);
        this.textLayout.setWidth(itemSize.x - 10);
        this.textLayout.setAlignment(0x1000000);
        this.textLayout.draw(gc, x + 5, y + imageSize.y + 5);
    }

    public String toString() {
        return CommonUtils.toString((Object)this.data);
    }
}

