/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.parser.common;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jkiss.dbeaver.parser.common.ParserFsmNode;
import org.jkiss.dbeaver.parser.common.ParserFsmStep;

class ParserFsm {
    private final List<ParserFsmNode> initialStates;
    private final List<ParserFsmNode> allStates;

    public ParserFsm(List<ParserFsmNode> initialStates, List<ParserFsmNode> parseFsmStates) {
        this.initialStates = initialStates;
        this.allStates = parseFsmStates;
    }

    public Iterable<ParserFsmNode> getInitialStates() {
        return this.initialStates;
    }

    public void prepare() {
        for (ParserFsmNode state : this.allStates) {
            state.prepare();
        }
    }

    public String collectDebugString() {
        StringBuilder sb = new StringBuilder();
        for (ParserFsmNode s : this.allStates) {
            sb.append("state").append(s).append(":");
            if (this.initialStates.contains(s)) {
                sb.append("<START>");
            }
            if (s.isEnd()) {
                sb.append(" <END>");
            }
            sb.append("\n");
            Map<String, List<ParserFsmStep>> transitionsByPatterm = s.getTransitions().stream().collect(Collectors.groupingBy(t -> t.getPattern() == null ? "" : t.getPattern()));
            for (Map.Entry<String, List<ParserFsmStep>> entry : transitionsByPatterm.entrySet()) {
                sb.append("\ton ").append(entry.getKey()).append("\n");
                for (ParserFsmStep transition : entry.getValue()) {
                    sb.append("\t\tto ").append(transition.getTo()).append(" { ");
                    sb.append(String.join((CharSequence)", ", transition.getOperations().stream().map(op -> op.toString()).collect(Collectors.toList())));
                    sb.append(" }\n");
                }
            }
        }
        return sb.toString();
    }
}

