/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.netezza.model;

import java.sql.Connection;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.ext.netezza.model.NetezzaSQLDialect;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.utils.BeanUtils;

public class NetezzaDataSource
extends GenericDataSource {
    private static final Log log = Log.getLog(NetezzaDataSource.class);

    public NetezzaDataSource(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container, @NotNull GenericMetaModel metaModel) throws DBException {
        super(monitor, container, metaModel, (SQLDialect)new NetezzaSQLDialect());
    }

    public NetezzaDataSource(@NotNull DBRProgressMonitor monitor, @NotNull GenericMetaModel metaModel, @NotNull DBPDataSourceContainer container) throws DBException {
        super(monitor, metaModel, container, (SQLDialect)new NetezzaSQLDialect());
    }

    protected void initializeContextState(@NotNull DBRProgressMonitor monitor, @NotNull JDBCExecutionContext context, JDBCExecutionContext initFrom) throws DBException {
        String name = this.getContainer().getActualConnectionConfiguration().getUserName();
        if (this.getSQLDialect().isQuotedIdentifier(name)) {
            try {
                Connection connection = context.getConnection(monitor);
                Object datasource = BeanUtils.invokeObjectMethod((Object)connection, (String)"getDatasource");
                BeanUtils.invokeObjectMethod((Object)datasource, (String)"setUser", (Class[])new Class[]{String.class}, (Object[])new Object[]{name});
            }
            catch (Throwable e) {
                log.debug((Object)"Error setting user", e);
            }
        }
    }
}

