/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import java.sql.JDBCType;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.impl.data.formatters.TimestampFormatSample;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.ui.UIUtils;

public class CustomTimeEditor {
    private static final String FORMAT_PATTERN = "pattern";
    private final int style;
    private final boolean isPanel;
    private DateTime dateEditor;
    private DateTime timeEditor;
    private Composite basePart;
    private static final String TIMESTAMP_DEFAULT_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private String format = "";
    private Label timeLabel;
    private Label dateLabel;
    private int millis = -1;
    private String dateAsText = "";
    private final boolean isInline;
    private InputMode inputMode = InputMode.None;
    private final Calendar calendar = Calendar.getInstance();
    private Text textEditor;
    private Listener modifyListener;
    private SelectionAdapter selectionListener;
    private boolean editable;

    public void createDateFormat(@NotNull DBSTypedObject valueType) {
        JDBCType jdbcType = JDBCType.valueOf(valueType.getTypeID());
        switch (jdbcType) {
            case DATE: {
                this.inputMode = InputMode.Date;
                this.disposeDateEditor(this.timeEditor, this.timeLabel);
                break;
            }
            case TIME: {
                this.inputMode = InputMode.Time;
                this.disposeDateEditor(this.dateEditor, this.dateLabel);
                break;
            }
            default: {
                this.inputMode = InputMode.DateTime;
            }
        }
    }

    public CustomTimeEditor(@NotNull Composite parent, int style, boolean isPanel, boolean isInline) {
        this.isInline = isInline;
        this.isPanel = isPanel;
        this.style = style;
        this.initEditor(parent, style);
    }

    @NotNull
    private Composite initEditor(@NotNull Composite parent, int style) {
        this.basePart = new Composite(parent, style);
        GridLayout layout = new GridLayout(2, false);
        if (this.isInline) {
            layout.marginWidth = 0;
            layout.marginHeight = 0;
        }
        this.basePart.setLayout((Layout)layout);
        this.setToDateComposite();
        this.basePart.pack();
        this.format = this.getTimestampFormat();
        return this.basePart;
    }

    public void setToTextComposite() {
        if (this.textEditor != null && !this.textEditor.isDisposed()) {
            return;
        }
        this.disposeDateEditor(this.timeEditor, this.timeLabel);
        this.timeEditor = null;
        this.disposeDateEditor(this.dateEditor, this.dateLabel);
        this.dateEditor = null;
        this.textEditor = new Text(this.basePart, this.isPanel && !this.isInline ? this.style : this.style | 0x800);
        GridData gridData = new GridData(4, 4, true, true, 1, 1);
        this.textEditor.setLayoutData((Object)gridData);
        this.allowEdit();
        this.textEditor.setText(this.dateAsText);
        this.basePart.layout();
    }

    private void disposeDateEditor(DateTime dateTimeEditor, Label dateTimeLabel) {
        if (dateTimeEditor != null) {
            dateTimeEditor.dispose();
            if (dateTimeLabel != null) {
                dateTimeLabel.dispose();
            }
        }
    }

    public void setToDateComposite() {
        if (this.dateEditor != null || this.timeEditor != null) {
            return;
        }
        if (this.textEditor != null && !this.textEditor.isDisposed()) {
            this.textEditor.dispose();
            this.textEditor = null;
        }
        GridData layoutData = new GridData(4, 131072, true, false, 1, 1);
        if (!this.isInline) {
            this.dateLabel = UIUtils.createLabel(this.basePart, "Date");
        }
        this.dateEditor = new DateTime(this.basePart, 4);
        this.dateEditor.setLayoutData((Object)layoutData);
        if (!this.isInline) {
            this.timeLabel = UIUtils.createLabel(this.basePart, "Time");
        }
        this.timeEditor = new DateTime(this.basePart, 65664);
        this.timeEditor.setLayoutData((Object)layoutData);
        this.allowEdit();
        this.setDateFromCalendar();
        this.updateListeners();
        this.basePart.layout();
    }

    public void setFormat(@NotNull String format) {
        this.format = format;
    }

    public void updateListeners() {
        if (this.selectionListener != null) {
            if (this.dateEditor != null && !this.dateEditor.isDisposed()) {
                this.dateEditor.addSelectionListener((SelectionListener)this.selectionListener);
            }
            if (this.timeEditor != null && !this.timeEditor.isDisposed()) {
                this.timeEditor.addSelectionListener((SelectionListener)this.selectionListener);
            }
        }
        if (this.modifyListener != null && this.textEditor != null && !this.textEditor.isDisposed()) {
            this.textEditor.addListener(24, this.modifyListener);
        }
    }

    public void addSelectionAdapter(@NotNull SelectionAdapter listener) {
        this.selectionListener = listener;
        this.updateListeners();
    }

    public void addModifyListener(@NotNull Listener listener) {
        this.modifyListener = listener;
        this.updateListeners();
    }

    private static void setWithoutListener(@NotNull Control control, int type, Listener listener, @NotNull Runnable blockToRun) {
        if (listener != null) {
            control.removeListener(type, listener);
            blockToRun.run();
            control.addListener(type, listener);
        } else {
            blockToRun.run();
        }
    }

    private String getTimestampFormat() {
        TimestampFormatSample prefFormat = new TimestampFormatSample();
        Map map = prefFormat.getDefaultProperties(Locale.getDefault());
        Object pattern = map.get(FORMAT_PATTERN);
        if (pattern instanceof String) {
            this.format = (String)pattern;
            return this.format;
        }
        return TIMESTAMP_DEFAULT_FORMAT;
    }

    public void setTextValue(@Nullable String value) {
        this.dateAsText = value;
        if (this.textEditor != null && !this.textEditor.isDisposed()) {
            CustomTimeEditor.setWithoutListener((Control)this.textEditor, 24, this.modifyListener, () -> this.textEditor.setText(value));
        }
    }

    public void setValue(@Nullable Date value) {
        if (value != null) {
            this.calendar.setTime(value);
        }
        this.setDateFromCalendar();
    }

    private void setDateFromCalendar() {
        if (this.dateEditor != null && !this.dateEditor.isDisposed()) {
            this.dateEditor.setDate(this.calendar.get(1), this.calendar.get(2), this.calendar.get(5));
        }
        if (this.timeEditor != null && !this.timeEditor.isDisposed()) {
            this.timeEditor.addTraverseListener(e -> {
                boolean bl = this.timeEditor.setFocus();
            });
            this.timeEditor.setTime(this.calendar.get(11), this.calendar.get(12), this.calendar.get(13));
            try {
                this.millis = this.calendar.get(14);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.millis = -1;
            }
        }
    }

    @Nullable
    public String getValueAsString() {
        if (this.textEditor != null && !this.textEditor.isDisposed()) {
            return this.textEditor.getText();
        }
        return null;
    }

    @Nullable
    public Date getValueAsDate() {
        switch (this.inputMode) {
            case Time: {
                this.calendar.set(0, 0, 0, this.timeEditor.getHours(), this.timeEditor.getMinutes(), this.timeEditor.getSeconds());
                break;
            }
            case Date: {
                this.calendar.set(this.dateEditor.getYear(), this.dateEditor.getMonth(), this.dateEditor.getDay());
                break;
            }
            case DateTime: {
                this.calendar.set(this.dateEditor.getYear(), this.dateEditor.getMonth(), this.dateEditor.getDay(), this.timeEditor.getHours(), this.timeEditor.getMinutes(), this.timeEditor.getSeconds());
                break;
            }
            default: {
                this.calendar.set(0, 0, 0, 0, 0, 0);
            }
        }
        if (this.millis != -1) {
            this.calendar.set(14, this.millis);
        }
        return this.calendar.getTime();
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
        this.allowEdit();
    }

    public void allowEdit() {
        if (this.dateEditor != null && !this.dateEditor.isDisposed()) {
            this.dateEditor.setEnabled(this.editable);
        }
        if (this.timeEditor != null && !this.timeEditor.isDisposed()) {
            this.timeEditor.setEnabled(this.editable);
        }
        if (this.textEditor != null && !this.textEditor.isDisposed()) {
            this.textEditor.setEditable(this.editable);
        }
    }

    public Composite getControl() {
        return this.basePart;
    }

    public void selectAllContent() {
        if (this.textEditor != null && !this.textEditor.isDisposed()) {
            this.textEditor.selectAll();
        }
    }

    private static enum InputMode {
        None,
        Date,
        Time,
        DateTime;

    }
}

