/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.router;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2dl.Connection;
import org.eclipse.draw2dl.IFigure;
import org.eclipse.draw2dl.geometry.Point;
import org.eclipse.draw2dl.geometry.PointList;
import org.eclipse.draw2dl.geometry.PrecisionPoint;
import org.eclipse.draw2dl.geometry.Rectangle;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.erd.ui.router.OrthogonalPath;
import org.jkiss.utils.Pair;

public class MikamiTabuchiRouter {
    private static final Log log = Log.getLog(MikamiTabuchiRouter.class);
    private static final int SOURCE_VERTICAL_LINES = 0;
    private static final int SOURCE_HORIZONTAL_LINES = 1;
    private static final int TARGET_VERTICAL_LINES = 2;
    private static final int TARGET_HORIZONTAL_LINES = 3;
    private int spacing = 15;
    private final List<Rectangle> obstacles = new ArrayList<Rectangle>();
    private PrecisionPoint start;
    private PrecisionPoint finish;
    private final List<OrthogonalPath> workingPaths = new ArrayList<OrthogonalPath>();
    private final List<OrthogonalPath> userPaths = new ArrayList<OrthogonalPath>();
    private final Map<OrthogonalPath, List<OrthogonalPath>> pathsToChildPaths = new HashMap<OrthogonalPath, List<OrthogonalPath>>();
    private Set<TrialLine> trialLinesWithPenalty;
    private Map<Boolean, List<Pair<Point, Point>>> resultMap;
    private final Map<Integer, Map<Integer, List<TrialLine>>> linesMap = new LinkedHashMap<Integer, Map<Integer, List<TrialLine>>>();
    private Pair<TrialLine, TrialLine> result;
    private static final int MAX_LINE_COUNT = 50000;
    private int currentLineCount;
    IFigure clientArea;
    private boolean requiresStep;
    private boolean resultIsNotPreferred;

    public void setClientArea(IFigure clientArea) {
        this.clientArea = clientArea;
    }

    private void createLinesFromTrial(TrialLine pos, int iter) {
        double from = pos.vertical ? pos.from.y : pos.from.x;
        double start = pos.start;
        double end = pos.finish;
        double startPosition = pos.hasForbiddenStart() ? pos.creationForbiddenStart : from;
        double i = startPosition - (startPosition - start) / 20.0;
        while (i > start) {
            ++this.currentLineCount;
            this.createTrial(pos, iter, i);
            if (this.currentLineCount > 50000) {
                return;
            }
            i -= (startPosition - start) / 20.0;
        }
        double finishPosition = pos.hasForbiddenFinish() ? pos.creationForbiddenFinish : from;
        double i2 = finishPosition + (end - finishPosition) / 20.0;
        while (i2 < end) {
            ++this.currentLineCount;
            this.createTrial(pos, iter, i2);
            if (this.currentLineCount > 50000) {
                return;
            }
            i2 += (end - finishPosition) / 20.0;
        }
    }

    private boolean createTrial(TrialLine pos, int iteration, double i) {
        TrialLine trialLine = this.createTrialLine(i, !pos.vertical, pos);
        this.getLinesMap(trialLine, iteration).add(trialLine);
        TrialLine interception = trialLine.findIntersection();
        if (interception != null) {
            int interceptionMultiplier;
            if (this.lineLiesOnPreviouslyCreatedLine((Point)trialLine.from, (Point)this.getInterceptionPoint(trialLine, interception), trialLine.vertical) || this.lineLiesOnPreviouslyCreatedLine((Point)interception.from, (Point)this.getInterceptionPoint(trialLine, interception), interception.vertical)) {
                this.requiresStep = true;
            }
            if (this.trialLinesWithPenalty.contains(trialLine) || this.trialLinesWithPenalty.contains(interception)) {
                this.requiresStep = true;
            }
            if (this.result == null) {
                this.result = new Pair((Object)trialLine, (Object)interception);
                this.resultIsNotPreferred = this.requiresStep;
                this.requiresStep = false;
                return true;
            }
            Pair trialLinePair = new Pair((Object)trialLine, (Object)interception);
            int resultMultiplier = this.resultIsNotPreferred ? 2 : 1;
            int n = interceptionMultiplier = this.requiresStep ? 2 : 1;
            if (this.calculateDistance(this.result) * (double)resultMultiplier > this.calculateDistance((Pair<TrialLine, TrialLine>)trialLinePair) * (double)interceptionMultiplier) {
                this.result = trialLinePair;
                this.resultIsNotPreferred = this.requiresStep;
                this.requiresStep = false;
                return true;
            }
            this.requiresStep = false;
            return false;
        }
        this.requiresStep = false;
        return false;
    }

    boolean lineLiesOnPreviouslyCreatedLine(Point point, Point secondPoint, boolean vertical) {
        for (Pair<Point, Point> line : this.resultMap.get(vertical)) {
            if (!(vertical ? point.x - 5 <= ((Point)line.getFirst()).x && point.x + this.spacing / 5 >= ((Point)line.getFirst()).x && (this.isInsideLine(point.y, ((Point)line.getFirst()).y, ((Point)line.getSecond()).y) || this.isInsideLine(secondPoint.y, ((Point)line.getFirst()).y, ((Point)line.getSecond()).y) || this.isInsideLine(((Point)line.getFirst()).y, point.y, secondPoint.y) || this.isInsideLine(((Point)line.getSecond()).y, point.y, secondPoint.y)) : point.y - this.spacing / 5 <= ((Point)line.getFirst()).y && point.y + this.spacing / 5 >= ((Point)line.getFirst()).y && (this.isInsideLine(point.x, ((Point)line.getFirst()).x, ((Point)line.getSecond()).x) || this.isInsideLine(secondPoint.x, ((Point)line.getFirst()).x, ((Point)line.getSecond()).x) || this.isInsideLine(((Point)line.getFirst()).x, point.x, secondPoint.x) || this.isInsideLine(((Point)line.getSecond()).x, point.x, secondPoint.x)))) continue;
            return true;
        }
        return false;
    }

    private boolean isInsideLine(int pointCoordinate, int lineCoordinateFirstPoint, int lineCoordinateSecondPoint) {
        return Math.min(lineCoordinateFirstPoint, lineCoordinateSecondPoint) <= pointCoordinate && Math.max(lineCoordinateFirstPoint, lineCoordinateSecondPoint) >= pointCoordinate;
    }

    @NotNull
    private List<TrialLine> getLinesMap(TrialLine line, int iteration) {
        if (line.vertical) {
            return line.fromSource ? this.linesMap.get(iteration).get(0) : this.linesMap.get(iteration).get(2);
        }
        return line.fromSource ? this.linesMap.get(iteration).get(1) : this.linesMap.get(iteration).get(3);
    }

    @NotNull
    private List<TrialLine> getOpposingLinesMap(TrialLine line, int iteration) {
        if (line.vertical) {
            return line.fromSource ? this.linesMap.get(iteration).get(3) : this.linesMap.get(iteration).get(1);
        }
        return line.fromSource ? this.linesMap.get(iteration).get(2) : this.linesMap.get(iteration).get(0);
    }

    private PrecisionPoint getInterceptionPoint(TrialLine source, TrialLine target) {
        if (source.vertical) {
            return new PrecisionPoint(source.from.x, target.from.y);
        }
        return new PrecisionPoint(target.from.x, source.from.y);
    }

    @NotNull
    private TrialLine createTrialLine(double pos, boolean vertical, @NotNull TrialLine parentLine) {
        PrecisionPoint point = vertical ? new PrecisionPoint(pos, (double)parentLine.from.y) : new PrecisionPoint((double)parentLine.from.x, pos);
        TrialLine trialLine = new TrialLine(point, parentLine);
        if (this.trialLinesWithPenalty.contains(parentLine) || this.lineLiesOnPreviouslyCreatedLine((Point)point, (Point)parentLine.from, !vertical)) {
            this.trialLinesWithPenalty.add(trialLine);
            this.requiresStep = true;
        }
        return trialLine;
    }

    public void setSpacing(int spacing) {
        this.spacing = spacing;
    }

    public boolean updateObstacle(Rectangle rectangle, Rectangle newBounds) {
        return this.obstacles.remove(rectangle) | this.obstacles.add(newBounds);
    }

    public void addObstacle(Rectangle bounds) {
        this.obstacles.add(bounds);
    }

    public boolean removeObstacle(Rectangle bounds) {
        return this.obstacles.remove(bounds);
    }

    private PointList traceback(Pair<TrialLine, TrialLine> res, boolean saveResults) {
        PointList points = new PointList();
        TrialLine line = ((TrialLine)res.getFirst()).fromSource ? (TrialLine)res.getFirst() : (TrialLine)res.getSecond();
        TrialLine previousLine = (TrialLine)res.getFirst();
        PrecisionPoint point = null;
        while (line != null) {
            if (point == null || !point.equals((Object)line.from)) {
                points.addPoint((Point)line.from);
            }
            previousLine = line;
            point = line.from;
            line = line.getParent();
        }
        points.reverse();
        point = this.getInterceptionPoint((TrialLine)res.getFirst(), (TrialLine)res.getSecond());
        points.addPoint((Point)point);
        line = ((TrialLine)res.getFirst()).fromSource ? (TrialLine)res.getSecond() : (TrialLine)res.getFirst();
        while (line != null) {
            if (!line.from.equals((Object)point)) {
                points.addPoint((Point)line.from);
            }
            point = line.from;
            line = line.getParent();
        }
        if (saveResults) {
            boolean vertical = !previousLine.vertical;
            int i = 1;
            while (i < points.size() - 2) {
                this.resultMap.get(vertical).add((Pair<Point, Point>)new Pair((Object)points.getPoint(i), (Object)points.getPoint(i + 1)));
                vertical = !vertical;
                ++i;
            }
        }
        return points;
    }

    public List<OrthogonalPath> solve() {
        this.resetWorkingPaths();
        this.updateChildPaths();
        Point point = null;
        this.init();
        for (OrthogonalPath userPath : this.workingPaths) {
            PointList pointList;
            if (userPath.isSourceIsChild() && point != null) {
                userPath.updateForbiddenDirection(point);
            }
            if ((pointList = this.solvePath(userPath)) != null && pointList.size() >= 2) {
                point = pointList.getPoint(pointList.size() - 2);
            }
            userPath.setPoints(pointList);
        }
        this.recombineChildrenPaths();
        return Collections.unmodifiableList(this.userPaths);
    }

    private void init() {
        this.resultMap = new HashMap<Boolean, List<Pair<Point, Point>>>();
        this.resultMap.put(false, new ArrayList());
        this.resultMap.put(true, new ArrayList());
    }

    private void resetWorkingPaths() {
        for (OrthogonalPath workingPath : this.workingPaths) {
            workingPath.reset();
        }
    }

    private void updateChildPaths() {
        for (OrthogonalPath path : this.userPaths) {
            if (!path.isDirty()) continue;
            List<OrthogonalPath> children = this.pathsToChildPaths.get(path);
            int previousCount = 1;
            int newCount = 1;
            if (children == null) {
                children = new ArrayList<OrthogonalPath>();
            } else {
                previousCount = children.size();
            }
            if (path.getBendpoints() != null) {
                newCount = path.getBendpoints().size() + 1;
            }
            if (previousCount != newCount) {
                children = this.regenerateChildPaths(path, children, previousCount, newCount, path.getConnection());
            }
            this.refreshChildrenEndpoints(path, children);
        }
    }

    private void refreshChildrenEndpoints(OrthogonalPath path, List<OrthogonalPath> children) {
        Point previous = path.getStart();
        PointList bendPoints = path.getBendpoints();
        int i = 0;
        while (i < children.size()) {
            Point next = i < bendPoints.size() ? bendPoints.getPoint(i) : path.getEnd();
            OrthogonalPath child = children.get(i);
            child.setStartPoint(previous);
            child.setEndPoint(next);
            previous = next;
            ++i;
        }
        if (children.size() > 1) {
            children.get(0).setTargetIsChild(true);
            children.get(0).setSourceIsChild(false);
            children.get(children.size() - 1).setSourceIsChild(true);
            children.get(children.size() - 1).setTargetIsChild(false);
        }
        i = 1;
        while (i < children.size() - 1) {
            children.get(i).setSourceIsChild(true);
            children.get(i).setTargetIsChild(true);
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private List<OrthogonalPath> regenerateChildPaths(OrthogonalPath path, List<OrthogonalPath> orthogonalPaths, int currentCount, int newCount, Connection connection) {
        block2: {
            if (currentCount != 1) break block2;
            this.workingPaths.remove(path);
            currentCount = 0;
            orthogonalPaths = new ArrayList<OrthogonalPath>();
            this.pathsToChildPaths.put(path, orthogonalPaths);
            ** GOTO lbl24
        }
        if (newCount != 1) ** GOTO lbl24
        this.workingPaths.removeAll(orthogonalPaths);
        this.workingPaths.add(path);
        this.pathsToChildPaths.remove(path);
        return Collections.emptyList();
lbl-1000:
        // 1 sources

        {
            child = new OrthogonalPath(connection);
            orthogonalPaths.add(child);
            this.workingPaths.add(child);
            ++currentCount;
lbl24:
            // 3 sources

            ** while (currentCount < newCount)
        }
lbl25:
        // 2 sources

        while (currentCount > newCount) {
            child = orthogonalPaths.remove(orthogonalPaths.size() - 1);
            this.workingPaths.remove(child);
            --currentCount;
        }
        return orthogonalPaths;
    }

    private double calculateDistance(Pair<TrialLine, TrialLine> res) {
        PrecisionPoint interceptionPoint = this.getInterceptionPoint((TrialLine)res.getFirst(), (TrialLine)res.getSecond());
        return ((TrialLine)res.getFirst()).distance + interceptionPoint.getDistance((Point)((TrialLine)res.getFirst()).from) + interceptionPoint.getDistance((Point)((TrialLine)res.getSecond()).from) + ((TrialLine)res.getSecond()).distance;
    }

    @NotNull
    private PointList solvePath(OrthogonalPath path) {
        if (path.getStart().equals((Object)path.getEnd())) {
            log.debug((Object)"Origin point is the same as Destination point");
            PointList pointList = new PointList();
            pointList.addPoint(path.getStart());
            pointList.addPoint(path.getEnd());
            return pointList;
        }
        if (!this.clientArea.getClientArea().contains(path.start) || !this.clientArea.getClientArea().contains(path.end)) {
            this.clientArea.getUpdateManager().performUpdate();
        }
        this.trialLinesWithPenalty = new HashSet<TrialLine>();
        this.linesMap.clear();
        this.resultIsNotPreferred = false;
        this.start = new PrecisionPoint(path.start);
        this.result = null;
        this.finish = new PrecisionPoint(path.end);
        int iter = 0;
        this.currentLineCount = 0;
        this.initStartingTrialLines(path, path.getForbiddenDirection());
        while (true) {
            this.linesMap.put(iter + 1, new HashMap());
            this.initNewLayer(iter + 1);
            boolean hasValues = false;
            int i = 0;
            while (i < 4) {
                for (TrialLine trialLine : this.linesMap.get(iter).get(i)) {
                    this.createLinesFromTrial(trialLine, iter + 1);
                    if (this.currentLineCount <= 50000) continue;
                    if (this.result != null) {
                        return this.traceback(this.result, true);
                    }
                    PointList pointList = new PointList();
                    pointList.addPoint((Point)this.start);
                    pointList.addPoint((Point)this.finish);
                    return pointList;
                }
                ++i;
            }
            if (this.result != null && !this.resultIsNotPreferred) {
                return this.traceback(this.result, true);
            }
            i = 0;
            while (i < 4) {
                if (this.linesMap.get(iter + 1).get(i).size() != 0) {
                    hasValues = true;
                }
                ++i;
            }
            if (!hasValues) {
                PointList pointList = new PointList();
                pointList.addPoint((Point)this.start);
                pointList.addPoint((Point)this.finish);
                return pointList;
            }
            ++iter;
        }
    }

    private void recombineChildrenPaths() {
        for (OrthogonalPath path : this.pathsToChildPaths.keySet()) {
            if (path.getPoints() == null) continue;
            path.getPoints().removeAllPoints();
            List<OrthogonalPath> childPaths = this.pathsToChildPaths.get(path);
            OrthogonalPath childPath = null;
            for (OrthogonalPath orthogonalPath : childPaths) {
                childPath = orthogonalPath;
                if (!childPath.getStart().equals((Object)childPath.getPoints().getPoint(0))) {
                    childPath.getPoints().reverse();
                }
                path.getPoints().addAll(childPath.getPoints());
                path.getPoints().removePoint(path.getPoints().size() - 1);
            }
            path.getPoints().addPoint(childPath.getPoints().getLastPoint());
        }
    }

    private void initStartingTrialLines(OrthogonalPath path, OrthogonalPath.Direction forbiddenDirection) {
        this.linesMap.put(0, new HashMap());
        this.initNewLayer(0);
        TrialLine horizontalStartTrial = new TrialLine(this.start, true, false, forbiddenDirection);
        TrialLine horizontalFinishTrial = new TrialLine(this.finish, false, false, forbiddenDirection);
        if (path.isSourceIsChild()) {
            TrialLine verticalStartTrial = new TrialLine(this.start, true, true, forbiddenDirection);
            this.linesMap.get(0).get(0).add(verticalStartTrial);
        }
        if (path.isTargetIsChild()) {
            TrialLine verticalFinishTrial = new TrialLine(this.finish, false, true, forbiddenDirection);
            this.linesMap.get(0).get(2).add(verticalFinishTrial);
        }
        this.linesMap.get(0).get(1).add(horizontalStartTrial);
        this.linesMap.get(0).get(3).add(horizontalFinishTrial);
    }

    private void initNewLayer(int iter) {
        int i = 0;
        while (i < 4) {
            this.linesMap.get(iter).put(i, new ArrayList());
            ++i;
        }
    }

    public void removePath(OrthogonalPath path) {
        this.userPaths.remove(path);
        List<OrthogonalPath> orthogonalPaths = this.pathsToChildPaths.get(path);
        if (orthogonalPaths == null) {
            this.workingPaths.remove(path);
        } else {
            this.workingPaths.removeAll(orthogonalPaths);
        }
    }

    public void addPath(OrthogonalPath path) {
        this.workingPaths.add(path);
        this.userPaths.add(path);
    }

    private class TrialLine {
        @Nullable
        private TrialLine parent;
        @NotNull
        private final PrecisionPoint from;
        private final boolean fromSource;
        private final boolean vertical;
        double distance = 0.0;
        private double start = Double.MIN_VALUE;
        private double finish = Double.MIN_VALUE;
        private double creationForbiddenStart = Double.MIN_VALUE;
        private double creationForbiddenFinish = Double.MIN_VALUE;

        private void calculateForbiddenRange(OrthogonalPath.Direction forbiddenDirection) {
            for (Rectangle it : MikamiTabuchiRouter.this.obstacles) {
                if (!this.isInsideFigure(it)) continue;
                if (this.vertical) {
                    this.creationForbiddenStart = it.getTop().y - MikamiTabuchiRouter.this.spacing;
                    this.creationForbiddenFinish = it.getBottom().y + MikamiTabuchiRouter.this.spacing;
                    continue;
                }
                this.creationForbiddenStart = it.getLeft().x - MikamiTabuchiRouter.this.spacing;
                this.creationForbiddenFinish = it.getRight().x + MikamiTabuchiRouter.this.spacing;
            }
            if (forbiddenDirection == null) {
                if (this.creationForbiddenStart != Double.MIN_VALUE) {
                    this.start = this.creationForbiddenStart - (double)(MikamiTabuchiRouter.this.spacing * 2);
                }
                if (this.creationForbiddenFinish != Double.MIN_VALUE) {
                    this.finish = this.creationForbiddenFinish + (double)(MikamiTabuchiRouter.this.spacing * 2);
                }
            }
            if (forbiddenDirection != null) {
                switch (forbiddenDirection) {
                    case DOWN: {
                        if (!this.vertical) break;
                        this.start = this.from.y;
                        break;
                    }
                    case UP: {
                        if (!this.vertical) break;
                        this.finish = this.from.y;
                        break;
                    }
                    case LEFT: {
                        if (this.vertical) break;
                        this.start = this.from.x;
                        break;
                    }
                    case RIGHT: {
                        if (this.vertical) break;
                        this.finish = this.from.x;
                    }
                }
            }
        }

        public boolean hasForbiddenStart() {
            return this.creationForbiddenStart != Double.MIN_VALUE;
        }

        public boolean hasForbiddenFinish() {
            return this.creationForbiddenFinish != Double.MIN_VALUE;
        }

        TrialLine(@NotNull PrecisionPoint start, TrialLine parent) {
            this.from = start;
            this.parent = parent;
            this.distance += start.getDistance((Point)parent.from);
            this.fromSource = parent.fromSource;
            this.vertical = !parent.vertical;
            this.cutByObstacles(false);
        }

        TrialLine(PrecisionPoint start, boolean fromSource, boolean vertical, OrthogonalPath.Direction forbiddenDirection) {
            this.from = start;
            this.vertical = vertical;
            this.fromSource = fromSource;
            this.calculateForbiddenRange(forbiddenDirection);
            this.cutByObstacles(true);
        }

        private boolean isInsideFigure(Rectangle it) {
            return it.getLeft().x <= this.from.x && it.getRight().x > this.from.x && it.getTop().y <= this.from.y && it.getBottom().y > this.from.y;
        }

        private void cutByObstacles(boolean startingLine) {
            for (Rectangle it : MikamiTabuchiRouter.this.obstacles) {
                if (this.isInsideFigure(it)) {
                    if (startingLine) continue;
                    this.cut(it);
                }
                if ((!this.vertical || it.getLeft().x - MikamiTabuchiRouter.this.spacing > this.from.x || it.getRight().x + MikamiTabuchiRouter.this.spacing <= this.from.x) && (this.vertical || it.getTop().y - MikamiTabuchiRouter.this.spacing > this.from.y || it.getBottom().y + MikamiTabuchiRouter.this.spacing <= this.from.y)) continue;
                this.cut(it);
            }
            if (this.finish == Double.MIN_VALUE) {
                this.finish = this.vertical ? (double)(MikamiTabuchiRouter.this.clientArea.getClientArea().getBottom().y - 1) : (double)(MikamiTabuchiRouter.this.clientArea.getClientArea().getRight().x - 1);
            }
            if (this.start == Double.MIN_VALUE) {
                this.start = this.vertical ? MikamiTabuchiRouter.this.clientArea.getClientArea().getTop().y + 1 : MikamiTabuchiRouter.this.clientArea.getClientArea().getLeft().x + 1;
            }
        }

        private void cut(Rectangle bound) {
            double fromPosition = this.vertical ? this.from.y : this.from.x;
            double startPoint = this.vertical ? bound.getTop().y : bound.getLeft().x;
            double endPoint = this.vertical ? bound.getBottom().y : bound.getRight().x;
            if (fromPosition > endPoint && (this.start == Double.MIN_VALUE || this.start < endPoint + (double)MikamiTabuchiRouter.this.spacing)) {
                this.start = endPoint + (double)MikamiTabuchiRouter.this.spacing;
            }
            if (fromPosition <= startPoint && (this.finish == Double.MIN_VALUE || this.finish > startPoint - (double)MikamiTabuchiRouter.this.spacing)) {
                this.finish = startPoint - (double)MikamiTabuchiRouter.this.spacing;
            }
        }

        @Nullable
        public TrialLine findIntersection() {
            int i = MikamiTabuchiRouter.this.linesMap.values().size() - 1;
            while (i >= 0) {
                for (TrialLine trialLine : MikamiTabuchiRouter.this.getOpposingLinesMap(this, i)) {
                    if (!this.intersect(trialLine)) continue;
                    return trialLine;
                }
                --i;
            }
            return null;
        }

        private boolean intersect(TrialLine line) {
            double firstLinePos = this.vertical ? this.from.x : this.from.y;
            double secondLinePos = this.vertical ? line.from.y : line.from.x;
            return firstLinePos >= line.start && firstLinePos < line.finish && secondLinePos >= this.start && secondLinePos < this.finish;
        }

        @Nullable
        public TrialLine getParent() {
            return this.parent;
        }
    }
}

