/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.ui.ide.IEditorAssociationOverride;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public final class EditorAssociationOverrideDescriptor {
    private static final String EDITOR_ASSOCIATION_OVERRIDE_EXTENSION_POINT = "org.eclipse.ui.ide.editorAssociationOverride";
    private static final String EDITOR_ASSOCIATION_OVERRIDE_ELEMENT = "editorAssociationOverride";
    private static final String ID_ATTRIBUTE = "id";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String DESCRIPTION_ATTRIBUTE = "description";
    private static final String CLASS_ATTRIBUTE = "class";
    private IConfigurationElement fElement;

    public static EditorAssociationOverrideDescriptor[] getContributedEditorAssociationOverrides() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor(EDITOR_ASSOCIATION_OVERRIDE_EXTENSION_POINT);
        return EditorAssociationOverrideDescriptor.createDescriptors(elements);
    }

    private EditorAssociationOverrideDescriptor(IConfigurationElement element) {
        Assert.isNotNull((Object)element);
        this.fElement = element;
    }

    public IEditorAssociationOverride createOverride() throws CoreException {
        final Throwable[] exception = new Throwable[1];
        final IEditorAssociationOverride[] result = new IEditorAssociationOverride[1];
        String message = MessageFormat.format(IDEWorkbenchMessages.editorAssociationOverride_error_couldNotCreate_message, this.getId(), this.fElement.getContributor().getName());
        SafeRunnable code = new SafeRunnable(message){

            public void run() throws Exception {
                result[0] = (IEditorAssociationOverride)EditorAssociationOverrideDescriptor.this.fElement.createExecutableExtension(EditorAssociationOverrideDescriptor.CLASS_ATTRIBUTE);
            }

            public void handleException(Throwable ex) {
                super.handleException(ex);
                exception[0] = ex;
            }
        };
        SafeRunner.run((ISafeRunnable)code);
        if (exception[0] == null) {
            return result[0];
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.ui.ide", 0, message, exception[0]));
    }

    public String getId() {
        return this.fElement.getAttribute(ID_ATTRIBUTE);
    }

    public String getName() {
        return this.fElement.getAttribute(NAME_ATTRIBUTE);
    }

    public String getDescription() {
        return this.fElement.getAttribute(DESCRIPTION_ATTRIBUTE);
    }

    public boolean equals(Object obj) {
        if (obj == null || !obj.getClass().equals(this.getClass()) || this.getId() == null) {
            return false;
        }
        return this.getId().equals(((EditorAssociationOverrideDescriptor)obj).getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    private static EditorAssociationOverrideDescriptor[] createDescriptors(IConfigurationElement[] elements) {
        ArrayList<EditorAssociationOverrideDescriptor> result = new ArrayList<EditorAssociationOverrideDescriptor>(elements.length);
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            if (EDITOR_ASSOCIATION_OVERRIDE_ELEMENT.equals(configElement.getName())) {
                EditorAssociationOverrideDescriptor desc = new EditorAssociationOverrideDescriptor(configElement);
                result.add(desc);
            } else {
                String message = MessageFormat.format(IDEWorkbenchMessages.editorAssociationOverride_error_invalidElementName_message, configElement.getContributor().getName(), configElement.getName());
                IDEWorkbenchPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ui.ide", 0, message, null));
            }
            ++n2;
        }
        return result.toArray(new EditorAssociationOverrideDescriptor[result.size()]);
    }
}

