/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.erd.model.ERDAssociation;
import org.jkiss.dbeaver.erd.model.ERDAttributeVisibility;
import org.jkiss.dbeaver.erd.model.ERDContainer;
import org.jkiss.dbeaver.erd.model.ERDContext;
import org.jkiss.dbeaver.erd.model.ERDDiagram;
import org.jkiss.dbeaver.erd.model.ERDElement;
import org.jkiss.dbeaver.erd.model.ERDEntityAttribute;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.virtual.DBVUtils;
import org.jkiss.utils.CommonUtils;

public class ERDEntity
extends ERDElement<DBSEntity> {
    static final Log log = Log.getLog(ERDEntity.class);
    private DBPDataSource dataSource;
    private String alias;
    private List<ERDEntityAttribute> attributes;
    private List<DBSEntityAssociation> unresolvedKeys;
    private boolean primary = false;
    private ERDAttributeVisibility attributeVisibility;

    public ERDEntity(DBPDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public ERDEntity(DBSEntity entity) {
        super(entity);
    }

    public DBPDataSource getDataSource() {
        return this.dataSource != null ? this.dataSource : ((DBSEntity)this.getObject()).getDataSource();
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public ERDAttributeVisibility getAttributeVisibility() {
        return this.attributeVisibility;
    }

    public void setAttributeVisibility(ERDAttributeVisibility attributeVisibility) {
        this.attributeVisibility = attributeVisibility;
    }

    public void addAttribute(ERDEntityAttribute attribute, boolean reflect) {
        if (this.attributes == null) {
            this.attributes = new ArrayList<ERDEntityAttribute>();
        }
        if (this.attributes.contains(attribute)) {
            throw new IllegalArgumentException("Attribute already present");
        }
        this.attributes.add(attribute);
        if (reflect) {
            this.firePropertyChange("CHILD", null, attribute);
        }
    }

    public void removeAttribute(ERDEntityAttribute attribute, boolean reflect) {
        this.attributes.remove(attribute);
        if (reflect) {
            this.firePropertyChange("CHILD", attribute, null);
        }
    }

    public void sortAttributes(@NotNull Comparator<ERDEntityAttribute> comparator, boolean reflect) {
        if (CommonUtils.isEmpty(this.attributes)) {
            return;
        }
        this.attributes.sort(comparator);
        if (reflect) {
            this.firePropertyChange("REORDER", this, null);
        }
    }

    public void switchAttribute(ERDEntityAttribute attribute, int index, boolean reflect) {
        this.attributes.remove(attribute);
        this.attributes.add(index, attribute);
        if (reflect) {
            this.firePropertyChange("REORDER", this, attribute);
        }
    }

    @NotNull
    public List<ERDEntityAttribute> getAttributes() {
        return CommonUtils.safeList(this.attributes);
    }

    public ERDEntityAttribute getAttribute(DBSEntityAttribute attribute) {
        if (attribute == null) {
            return null;
        }
        for (ERDEntityAttribute attr : this.attributes) {
            if (attr.getObject() != attribute) continue;
            return attr;
        }
        return null;
    }

    public ERDAssociation getAssociation(DBSEntityAssociation association) {
        if (association == null) {
            return null;
        }
        for (ERDAssociation assoc : this.getAssociations()) {
            if (assoc.getObject() != association) continue;
            return assoc;
        }
        return null;
    }

    public ERDAssociation getReferenceAssociation(DBSEntityAssociation association) {
        if (association == null) {
            return null;
        }
        for (ERDAssociation assoc : this.getReferences()) {
            if (assoc.getObject() != association) continue;
            return assoc;
        }
        return null;
    }

    @NotNull
    public List<ERDEntityAttribute> getCheckedAttributes() {
        ArrayList<ERDEntityAttribute> result = new ArrayList<ERDEntityAttribute>();
        if (this.attributes != null) {
            for (ERDEntityAttribute attr : this.attributes) {
                if (!attr.isChecked()) continue;
                result.add(attr);
            }
        }
        return result;
    }

    public void reloadAttributes(ERDDiagram diagram) {
        if (!CommonUtils.isEmpty(this.attributes)) {
            this.attributes.clear();
        }
        diagram.getContentProvider().fillEntityFromObject((DBRProgressMonitor)new VoidProgressMonitor(), diagram, Collections.emptyList(), this);
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public void setPrimary(boolean primary) {
        this.primary = primary;
    }

    public void addModelRelations(DBRProgressMonitor monitor, ERDContainer diagram, boolean create, boolean reflect) {
        try {
            HashSet fkAttrs = new HashSet();
            List fks = DBVUtils.getAllAssociations((DBRProgressMonitor)monitor, (DBSEntity)((DBSEntity)this.getObject()));
            if (fks != null) {
                for (DBSEntityAssociation fk : fks) {
                    ERDEntity entity2;
                    if (fk instanceof DBSEntityReferrer) {
                        fkAttrs.addAll(DBUtils.getEntityAttributes((DBRProgressMonitor)monitor, (DBSEntityReferrer)((DBSEntityReferrer)fk)));
                    }
                    if ((entity2 = diagram.getEntityMap().get(DBVUtils.getRealEntity((DBRProgressMonitor)monitor, (DBSEntity)fk.getAssociatedEntity()))) == null) {
                        if (this.unresolvedKeys == null) {
                            this.unresolvedKeys = new ArrayList<DBSEntityAssociation>();
                        }
                        this.unresolvedKeys.add(fk);
                        continue;
                    }
                    if (!create || DBUtils.isInheritedObject((Object)fk)) continue;
                    diagram.getContentProvider().createAutoAssociation(diagram, fk, this, entity2, reflect);
                }
            }
            if (!fkAttrs.isEmpty()) {
                for (ERDEntityAttribute attribute : this.getAttributes()) {
                    if (!fkAttrs.contains(attribute.getObject())) continue;
                    attribute.setInForeignKey(true);
                }
            }
        }
        catch (Throwable e) {
            log.error((Object)("Can't load table '" + ((DBSEntity)this.getObject()).getName() + "' foreign keys"), e);
        }
    }

    public void resolveRelations(ERDContainer diagram, boolean reflect) {
        if (CommonUtils.isEmpty(this.unresolvedKeys)) {
            return;
        }
        Iterator<DBSEntityAssociation> iter = this.unresolvedKeys.iterator();
        while (iter.hasNext()) {
            ERDAssociation erdAssociation;
            ERDEntity refEntity;
            DBSEntityAssociation fk = iter.next();
            if (fk.getReferencedConstraint() == null || (refEntity = diagram.getEntityMap().get(DBVUtils.tryGetRealEntity((DBSEntity)fk.getReferencedConstraint().getParentObject()))) == null || (erdAssociation = diagram.getContentProvider().createAutoAssociation(diagram, fk, this, refEntity, reflect)) == null) continue;
            iter.remove();
        }
    }

    @NotNull
    public String getName() {
        return ((DBSEntity)this.getObject()).getName();
    }

    @Override
    public void fromMap(@NotNull ERDContext context, Map<String, Object> map) {
        this.alias = JSONUtils.getString(map, (String)"alias");
        try {
            for (Map attrMap : JSONUtils.getObjectList(map, (String)"attributes")) {
                String name = JSONUtils.getString((Map)attrMap, (String)"name");
                if (CommonUtils.isEmpty((String)name)) continue;
                DBSEntityAttribute attribute = ((DBSEntity)this.getObject()).getAttribute(context.getMonitor(), name);
                if (attribute == null) {
                    log.error((Object)("Attribute '" + name + "' not found in entity " + this.getName()));
                    continue;
                }
                ERDEntityAttribute attr = new ERDEntityAttribute(attribute, false);
                attr.fromMap(context, attrMap);
                this.addAttribute(attr, false);
            }
        }
        catch (DBException e) {
            log.error((Object)"Error reading entity attributes", (Throwable)e);
        }
    }

    @Override
    public Map<String, Object> toMap(@NotNull ERDContext context) {
        DBSEntity dbsEntity = (DBSEntity)this.getObject();
        LinkedHashMap<String, Object> entityMap = new LinkedHashMap<String, Object>();
        entityMap.put("id", context.addElementInfo(this));
        DBNDatabaseNode node = context.getNavigatorModel().getNodeByObject(context.getMonitor(), (DBSObject)dbsEntity, true);
        if (node != null) {
            entityMap.put("nodeId", node.getNodeItemPath());
        }
        entityMap.put("name", this.getName());
        if (!CommonUtils.isEmpty((String)this.getAlias())) {
            entityMap.put("alias", this.getAlias());
        }
        if (dbsEntity != null && dbsEntity instanceof DBPQualifiedObject) {
            entityMap.put("fqn", ((DBPQualifiedObject)dbsEntity).getFullyQualifiedName(DBPEvaluationContext.UI));
        }
        entityMap.put("iconIndex", context.getIconIndex(DBValueFormatting.getObjectImage((DBPObject)dbsEntity)));
        entityMap.put("attributes", this.getAttributes().stream().map(a -> a.toMap(context)).collect(Collectors.toList()));
        return entityMap;
    }

    public String toString() {
        return String.valueOf(this.getName()) + (CommonUtils.isEmpty((String)this.alias) ? "" : " " + this.alias);
    }

    public int hashCode() {
        int aliasHC = this.alias == null ? 0 : this.alias.hashCode();
        return (this.object == null ? 0 : ((DBSEntity)this.object).hashCode()) + aliasHC;
    }

    public boolean equals(Object o) {
        if (o instanceof ERDEntity) {
            return CommonUtils.equalObjects((Object)this.object, (Object)((ERDEntity)o).object) && CommonUtils.equalObjects((Object)this.alias, (Object)((ERDEntity)o).alias);
        }
        return false;
    }
}

