/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.core.util;

import java.lang.reflect.Method;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.internal.core.identity.Activator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class PlatformHelper {
    private static Class platformClass;
    private static IAdapterManager adapterManagerCache;
    private static IExtensionRegistry extensionRegistryCache;

    static {
        block7: {
            platformClass = null;
            adapterManagerCache = null;
            extensionRegistryCache = null;
            Activator a = Activator.getDefault();
            if (a != null) {
                try {
                    BundleContext c = a.getBundleContext();
                    if (c == null) break block7;
                    Bundle[] bundles = c.getBundles();
                    Bundle coreRuntime = null;
                    Bundle[] bundleArray = bundles;
                    int n = bundles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Bundle bundle = bundleArray[n2];
                        if (bundle.getSymbolicName().equals("org.eclipse.core.runtime")) {
                            coreRuntime = bundle;
                            platformClass = coreRuntime.loadClass("org.eclipse.core.runtime.Platform");
                            break;
                        }
                        ++n2;
                    }
                }
                catch (Exception e) {
                    try {
                        a.log((IStatus)new Status(2, "org.eclipse.ecf.identity", 2, "Cannot load Platform class", (Throwable)e));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public static synchronized boolean isPlatformAvailable() {
        return platformClass != null;
    }

    public static synchronized IAdapterManager getPlatformAdapterManager() {
        if (adapterManagerCache != null) {
            return adapterManagerCache;
        }
        if (PlatformHelper.isPlatformAvailable()) {
            try {
                Method m = platformClass.getMethod("getAdapterManager", null);
                adapterManagerCache = (IAdapterManager)m.invoke(null, null);
                return adapterManagerCache;
            }
            catch (Exception e) {
                Activator.getDefault().log((IStatus)new Status(2, "org.eclipse.ecf.identity", 2, "Cannot get PlatformAdapterManager()", (Throwable)e));
                return null;
            }
        }
        return null;
    }

    public static synchronized IExtensionRegistry getExtensionRegistry() {
        if (extensionRegistryCache != null) {
            return extensionRegistryCache;
        }
        if (PlatformHelper.isPlatformAvailable()) {
            try {
                Method m = platformClass.getMethod("getExtensionRegistry", null);
                extensionRegistryCache = (IExtensionRegistry)m.invoke(null, null);
                return extensionRegistryCache;
            }
            catch (Exception e) {
                Activator.getDefault().log((IStatus)new Status(2, "org.eclipse.ecf.identity", 2, "Cannot get PlatformExtensionRegistry()", (Throwable)e));
                return null;
            }
        }
        return null;
    }
}

