/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.OracleGrantee;
import org.jkiss.dbeaver.ext.oracle.model.OraclePriv;
import org.jkiss.dbeaver.ext.oracle.model.OracleUtils;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObjectLazy;

public class OraclePrivRole
extends OraclePriv
implements DBSObjectLazy<OracleDataSource> {
    private Object role;
    private boolean defaultRole;

    public OraclePrivRole(OracleGrantee user, ResultSet resultSet) {
        super(user, JDBCUtils.safeGetString((ResultSet)resultSet, (String)"GRANTED_ROLE"), resultSet);
        this.defaultRole = JDBCUtils.safeGetBoolean((ResultSet)resultSet, (String)"DEFAULT_ROLE", (String)"Y");
        this.role = this.name;
    }

    @Override
    @NotNull
    public String getName() {
        return super.getName();
    }

    @Property(id="name", viewable=true, order=2, supportsPreview=true)
    public Object getRole(DBRProgressMonitor monitor) throws DBException {
        if (monitor == null) {
            return this.role;
        }
        return OracleUtils.resolveLazyReference(monitor, this.getDataSource(), this.getDataSource().roleCache, this, null);
    }

    @Property(viewable=true, order=4)
    public boolean isDefaultRole() {
        return this.defaultRole;
    }

    public Object getLazyReference(Object propertyId) {
        return this.role;
    }
}

