/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.project;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IToolTipProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPPlatformEclipse;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPProjectListener;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.DBNProjectDatabases;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.LazyLabelProvider;
import org.jkiss.dbeaver.ui.ProgramInfo;
import org.jkiss.dbeaver.ui.UIExecutionQueue;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ViewerColumnController;
import org.jkiss.dbeaver.ui.internal.UINavigatorMessages;
import org.jkiss.dbeaver.ui.navigator.project.DecoratedProjectView;
import org.jkiss.utils.CommonUtils;

public class ProjectExplorerView
extends DecoratedProjectView
implements DBPProjectListener {
    public static final String VIEW_ID = "org.jkiss.dbeaver.core.projectExplorer";
    private ViewerColumnController columnController;
    private final NumberFormat sizeFormat = new DecimalFormat();

    public ProjectExplorerView() {
        DBPPlatformEclipse.getInstance().getWorkspace().addProjectListener((DBPProjectListener)this);
    }

    @Override
    public DBNNode getRootNode() {
        DBNProject projectNode = this.getModel().getRoot().getProjectNode(DBWorkbench.getPlatform().getWorkspace().getActiveProject());
        return projectNode != null ? projectNode : this.getModel().getRoot();
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        UIUtils.setHelp((Control)parent, (String)"view-project-explorer");
        TreeViewer viewer = this.getNavigatorViewer();
        viewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return !(element instanceof DBNProjectDatabases);
            }
        });
        viewer.getTree().setHeaderVisible(true);
        UIExecutionQueue.queueExec(() -> {
            this.createColumns(viewer);
            this.updateTitle();
        });
        this.getNavigatorTree().getViewer().addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return parentElement != viewer.getInput() || element instanceof DBNResource;
            }
        });
    }

    private void createColumns(TreeViewer viewer) {
        Color shadowColor = viewer.getControl().getDisplay().getSystemColor(17);
        final ILabelProvider mainLabelProvider = (ILabelProvider)viewer.getLabelProvider();
        this.columnController = new ViewerColumnController("projectExplorer", (ColumnViewer)viewer);
        this.columnController.setForceAutoSize(true);
        this.columnController.addColumn(UINavigatorMessages.navigator_project_explorer_columns_name_text, UINavigatorMessages.navigator_project_explorer_columns_name_description, 16384, true, true, (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return mainLabelProvider.getText(element);
            }

            public Image getImage(Object element) {
                Image image = mainLabelProvider.getImage(element);
                if (element instanceof DBNResource) {
                    image = ProjectExplorerView.this.labelDecorator.decorateImage(image, element);
                }
                return image;
            }

            public String getToolTipText(Object element) {
                if (mainLabelProvider instanceof IToolTipProvider) {
                    return ((IToolTipProvider)mainLabelProvider).getToolTipText(element);
                }
                return null;
            }
        });
        this.columnController.addColumn(UINavigatorMessages.navigator_project_explorer_columns_datasource_text, UINavigatorMessages.navigator_project_explorer_columns_datasource_description, 16384, true, false, (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Collection containers;
                if (element instanceof DBNDatabaseNode) {
                    return ((DBNDatabaseNode)element).getDataSourceContainer().getName();
                }
                if (element instanceof DBNResource && !CommonUtils.isEmpty((Collection)(containers = ((DBNResource)element).getAssociatedDataSources()))) {
                    StringBuilder text = new StringBuilder();
                    for (DBPDataSourceContainer container : containers) {
                        if (text.length() > 0) {
                            text.append(", ");
                        }
                        text.append(container.getName());
                    }
                    return text.toString();
                }
                return "";
            }

            public Image getImage(Object element) {
                return null;
            }

            public String getToolTipText(Object element) {
                Collection containers;
                if (element instanceof DBNResource && !CommonUtils.isEmpty((Collection)(containers = ((DBNResource)element).getAssociatedDataSources()))) {
                    StringBuilder text = new StringBuilder();
                    for (DBPDataSourceContainer container : containers) {
                        String description = container.getDescription();
                        if (CommonUtils.isEmpty((String)description)) {
                            description = container.getName();
                        }
                        if (CommonUtils.isEmpty((String)description)) continue;
                        if (text.length() > 0) {
                            text.append(", ");
                        }
                        text.append(description);
                    }
                    return text.toString();
                }
                return null;
            }
        });
        this.columnController.addColumn(UINavigatorMessages.navigator_project_explorer_columns_preview_text, UINavigatorMessages.navigator_project_explorer_columns_preview_description, 16384, false, false, (CellLabelProvider)new LazyLabelProvider(shadowColor){

            public String getLazyText(Object element) {
                if (element instanceof DBNNode) {
                    return ((DBNNode)element).getNodeDescription();
                }
                return null;
            }
        });
        this.columnController.addColumn(UINavigatorMessages.navigator_project_explorer_columns_size_text, UINavigatorMessages.navigator_project_explorer_columns_size_description, 16384, false, false, true, null, (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IResource resource;
                if (element instanceof DBNResource && (resource = ((DBNResource)element).getResource()) instanceof IFile) {
                    return ProjectExplorerView.this.sizeFormat.format(resource.getLocation().toFile().length());
                }
                return "";
            }
        }, null);
        this.columnController.addColumn(UINavigatorMessages.navigator_project_explorer_columns_modified_text, UINavigatorMessages.navigator_project_explorer_columns_modified_description, 16384, false, false, (CellLabelProvider)new ColumnLabelProvider(){
            private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

            public String getText(Object element) {
                IResource resource;
                if (element instanceof DBNResource && ((resource = ((DBNResource)element).getResource()) instanceof IFile || resource instanceof IFolder)) {
                    long lastModified = resource.getLocation().toFile().lastModified();
                    if (lastModified <= 0L) {
                        return "";
                    }
                    return this.sdf.format(new Date(lastModified));
                }
                return "";
            }
        });
        this.columnController.addColumn(UINavigatorMessages.navigator_project_explorer_columns_type_text, UINavigatorMessages.navigator_project_explorer_columns_type_description, 16384, false, false, (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IResource resource;
                ProgramInfo program;
                if (element instanceof DBNResource && (program = ProgramInfo.getProgram((IResource)(resource = ((DBNResource)element).getResource()))) != null) {
                    return program.getProgram().getName();
                }
                return "";
            }
        });
        UIUtils.asyncExec(() -> this.columnController.createColumns(true));
    }

    @Override
    protected int getTreeStyle() {
        return super.getTreeStyle() | 0x10000;
    }

    @Override
    public void dispose() {
        DBPPlatformEclipse.getInstance().getWorkspace().removeProjectListener((DBPProjectListener)this);
        super.dispose();
    }

    public void handleProjectAdd(DBPProject project) {
    }

    public void handleProjectRemove(DBPProject project) {
    }

    public void handleActiveProjectChange(DBPProject oldValue, DBPProject newValue) {
        UIExecutionQueue.queueExec(() -> {
            this.getNavigatorTree().reloadTree(this.getRootNode());
            this.updateTitle();
        });
    }

    private void updateTitle() {
        this.setPartName("Project - " + this.getRootNode().getNodeName());
    }

    @Override
    public void configureView() {
        DBPProject activeProject = DBWorkbench.getPlatform().getWorkspace().getActiveProject();
        if (activeProject != null) {
            UIUtils.showPreferencesFor((Shell)this.getSite().getShell(), (Object)activeProject.getEclipseProject(), (String[])new String[]{"org.jkiss.dbeaver.preferences.projectSettings"});
        }
    }
}

