/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import java.lang.reflect.Array;
import java.text.Collator;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.IColumnTextProvider;
import org.jkiss.dbeaver.ui.IColumnValueProvider;
import org.jkiss.dbeaver.ui.ILabelProviderEx;
import org.jkiss.dbeaver.ui.ILazyLabelProvider;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ColumnBooleanLabelProvider;
import org.jkiss.dbeaver.ui.controls.ObjectViewerRenderer;
import org.jkiss.dbeaver.ui.controls.ViewerColumnRegistry;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.internal.UIMessages;
import org.jkiss.dbeaver.ui.internal.UINavigatorMessages;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class ViewerColumnController<COLUMN, ELEMENT> {
    private static final Log log = Log.getLog(ViewerColumnController.class);
    private static final String DATA_KEY = ViewerColumnController.class.getSimpleName();
    private static final int MIN_COLUMN_AUTO_WIDTH = 100;
    private final String configId;
    private final ColumnViewer viewer;
    private final List<ColumnInfo> columns = new ArrayList<ColumnInfo>();
    private boolean clickOnHeader;
    private boolean isPacking;
    private boolean isInitializing;
    private DBIcon defaultIcon;
    private boolean forceAutoSize;
    private transient ObjectViewerRenderer cellRenderer;
    private transient Listener menuListener;
    private int selectedColumnNumber;

    public static ViewerColumnController getFromControl(Control control) {
        return (ViewerColumnController)control.getData(DATA_KEY);
    }

    public ViewerColumnController(String id, ColumnViewer viewer) {
        this.configId = id;
        this.viewer = viewer;
        Control control = this.viewer.getControl();
        control.setData(DATA_KEY, (Object)this);
        if (control instanceof Tree || control instanceof Table) {
            this.menuListener = event -> {
                Point pt = control.getDisplay().map(null, control, new Point(event.x, event.y));
                Rectangle clientArea = ((Composite)control).getClientArea();
                if (RuntimeUtils.isMacOS()) {
                    this.clickOnHeader = pt.y < 0;
                } else if (control instanceof Tree) {
                    this.clickOnHeader = clientArea.y <= pt.y && pt.y < clientArea.y + ((Tree)control).getHeaderHeight();
                } else {
                    boolean bl = this.clickOnHeader = clientArea.y <= pt.y && pt.y < clientArea.y + ((Table)control).getHeaderHeight();
                }
                if (this.clickOnHeader) {
                    if (viewer instanceof TableViewer && control instanceof Table) {
                        int pointYWithHeader = pt.y + ((Table)control).getHeaderHeight();
                        TableItem selectedItem = ((TableViewer)this.viewer).getTable().getItem(new Point(pt.x, pointYWithHeader));
                        if (selectedItem != null) {
                            this.selectedColumnNumber = UIUtils.getColumnAtPos((TableItem)selectedItem, (int)pt.x, (int)pointYWithHeader);
                        }
                    } else if (viewer instanceof TreeViewer && control instanceof Tree) {
                        int pointYWithHeader = pt.y + ((Tree)control).getHeaderHeight();
                        TreeItem selectedItem = ((TreeViewer)viewer).getTree().getItem(new Point(pt.x, pointYWithHeader));
                        if (selectedItem != null) {
                            this.selectedColumnNumber = UIUtils.getColumnAtPos((TreeItem)selectedItem, (int)pt.x, (int)pointYWithHeader);
                        }
                    }
                }
            };
            control.addListener(35, this.menuListener);
        }
        this.cellRenderer = new ObjectViewerRenderer(viewer, false){

            @Nullable
            public Object getCellValue(Object element, int columnIndex) {
                List<ColumnInfo> visibleColumns = ViewerColumnController.this.getVisibleColumns();
                if (!visibleColumns.isEmpty()) {
                    ColumnInfo columnInfo = ViewerColumnController.this.getVisibleColumns().get(columnIndex);
                    if (columnInfo.labelProvider instanceof ColumnBooleanLabelProvider) {
                        return ((ColumnBooleanLabelProvider)columnInfo.labelProvider).getValueProvider().getValue(element);
                    }
                }
                return null;
            }
        };
        viewer.setComparator((ViewerComparator)new DefaultComparator(Collator.getInstance()));
    }

    public void dispose() {
        this.clearColumns();
        Control control = this.viewer.getControl();
        if (!control.isDisposed() && this.menuListener != null) {
            control.removeListener(35, this.menuListener);
            this.menuListener = null;
        }
    }

    public boolean isClickOnHeader() {
        return this.clickOnHeader;
    }

    public void setForceAutoSize(boolean forceAutoSize) {
        this.forceAutoSize = forceAutoSize;
    }

    public void setDefaultIcon(DBIcon defaultIcon) {
        this.defaultIcon = defaultIcon;
    }

    public void setComparator(@NotNull DefaultComparator comparator) {
        this.viewer.setComparator((ViewerComparator)comparator);
    }

    public int getSelectedColumnNumber() {
        return this.selectedColumnNumber;
    }

    public void fillConfigMenu(IContributionManager menuManager) {
        menuManager.add((IAction)new Action(UINavigatorMessages.obj_editor_properties_control_action_configure_columns, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.CONFIGURATION)){
            {
                this.setDescription(UINavigatorMessages.obj_editor_properties_control_action_configure_columns_description);
            }

            public void run() {
                ViewerColumnController.this.configureColumns();
            }
        });
    }

    public void addColumn(String name, String description, int style, boolean defaultVisible, boolean required, final IColumnTextProvider<ELEMENT> labelProvider, EditingSupport editingSupport) {
        this.addColumn(name, description, style, defaultVisible, required, false, null, (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return labelProvider.getText(element);
            }

            public void update(ViewerCell cell) {
                if (cell.getColumnIndex() == 0 && ViewerColumnController.this.defaultIcon != null) {
                    cell.setImage(DBeaverIcons.getImage((DBPImage)ViewerColumnController.this.defaultIcon));
                }
                cell.setText(labelProvider.getText(cell.getElement()));
            }
        }, editingSupport);
    }

    public void addBooleanColumn(String name, String description, int style, boolean defaultVisible, boolean required, IColumnValueProvider<ELEMENT, Boolean> valueProvider, EditingSupport editingSupport) {
        this.addColumn(name, description, style, defaultVisible, required, false, null, (CellLabelProvider)new ColumnBooleanLabelProvider<ELEMENT, Boolean>(valueProvider), editingSupport);
    }

    public void addColumn(String name, String description, int style, boolean defaultVisible, boolean required, CellLabelProvider labelProvider) {
        this.addColumn(name, description, style, defaultVisible, required, false, null, labelProvider, null);
    }

    public void addColumn(String name, String description, int style, boolean defaultVisible, boolean required, boolean numeric, Object userData, CellLabelProvider labelProvider, EditingSupport editingSupport) {
        this.columns.add(new ColumnInfo(name, description, style, defaultVisible, required, numeric, userData, labelProvider, editingSupport, this.columns.size()));
    }

    private void clearColumns() {
        for (ColumnInfo columnInfo : this.columns) {
            if (columnInfo.column == null) continue;
            columnInfo.column.dispose();
            columnInfo.column = null;
        }
        this.columns.clear();
    }

    public void createColumns() {
        this.createColumns(true);
    }

    public void createColumns(boolean pack) {
        try {
            this.readColumnsConfiguration();
        }
        catch (Exception e) {
            log.warn((Object)("Failed to load configuration for '" + this.configId + "'"), (Throwable)e);
        }
        this.recreateColumns(pack);
    }

    private void recreateColumns(boolean pack) {
        final Control control = this.viewer.getControl();
        if (control == null || control.isDisposed()) {
            return;
        }
        control.setRedraw(false);
        this.isInitializing = true;
        try {
            boolean needRefresh = false;
            for (ColumnInfo columnInfo : this.columns) {
                boolean columnExists;
                boolean bl = columnExists = columnInfo.column != null;
                if (columnExists != columnInfo.visible) {
                    needRefresh = true;
                }
                if (columnInfo.column == null) continue;
                columnInfo.column.dispose();
                columnInfo.column = null;
            }
            this.createVisibleColumns();
            if (needRefresh) {
                this.viewer.refresh();
            }
            boolean allSized = this.isAllSized();
            if (pack && !allSized) {
                this.repackColumns();
                control.addControlListener((ControlListener)new ControlAdapter(){

                    public void controlResized(ControlEvent e) {
                        control.removeControlListener((ControlListener)this);
                        if (ViewerColumnController.this.getRowCount() > 0) {
                            ViewerColumnController.this.repackColumns();
                        }
                    }
                });
            }
        }
        finally {
            control.setRedraw(true);
            this.isInitializing = false;
        }
    }

    private boolean isAllSized() {
        for (ColumnInfo columnInfo : this.columns) {
            if (!columnInfo.visible || columnInfo.width > 0) continue;
            return false;
        }
        return true;
    }

    public void repackColumns() {
        if (this.isAllSized()) {
            return;
        }
        this.isPacking = true;
        try {
            if (this.viewer instanceof TreeViewer) {
                ((TreeViewer)this.viewer).getTree().getItemCount();
                float[] ratios = null;
                if (((TreeViewer)this.viewer).getTree().getColumnCount() == 2) {
                    ratios = new float[]{0.6f, 0.4f};
                }
                UIUtils.packColumns((Tree)((TreeViewer)this.viewer).getTree(), (boolean)this.forceAutoSize, ratios);
            } else if (this.viewer instanceof TableViewer) {
                ((TableViewer)this.viewer).getTable().getItemCount();
                UIUtils.packColumns((Table)((TableViewer)this.viewer).getTable(), (boolean)this.forceAutoSize);
            }
            for (ColumnInfo columnInfo : this.getVisibleColumns()) {
                int realWidth;
                if (columnInfo.column instanceof TreeColumn) {
                    realWidth = ((TreeColumn)columnInfo.column).getWidth();
                    if (realWidth < 100) {
                        ((TreeColumn)columnInfo.column).setWidth(100);
                        realWidth = 100;
                    }
                    columnInfo.width = realWidth;
                    continue;
                }
                if (!(columnInfo.column instanceof TableColumn)) continue;
                realWidth = ((TableColumn)columnInfo.column).getWidth();
                if (realWidth < 100) {
                    ((TableColumn)columnInfo.column).setWidth(100);
                    realWidth = 100;
                }
                columnInfo.width = realWidth;
            }
        }
        finally {
            this.isPacking = false;
        }
    }

    public void autoSizeColumns() {
        UIUtils.asyncExec(() -> {
            Control control = this.viewer.getControl();
            if (control instanceof Tree) {
                UIUtils.packColumns((Tree)((Tree)control), (boolean)true, null);
            } else if (control instanceof Table) {
                UIUtils.packColumns((Table)((Table)control), (boolean)true);
            }
        });
    }

    public void sortByColumn(int index, int direction) {
        ColumnInfo columnInfo = this.columns.get(index);
        columnInfo.sortListener.sortViewer(columnInfo.column, direction);
    }

    private void createVisibleColumns() {
        boolean hasCustomDraw = false;
        List<ColumnInfo> visibleColumns = this.getVisibleColumns();
        int i = 0;
        while (i < visibleColumns.size()) {
            block13: {
                TreeColumn colItem;
                TreeViewerColumn viewerColumn;
                ColumnInfo columnInfo;
                block12: {
                    TreeColumn column;
                    TreeViewerColumn item;
                    block11: {
                        columnInfo = visibleColumns.get(i);
                        columnInfo.order = i;
                        if (!(this.viewer instanceof TreeViewer)) break block11;
                        viewerColumn = item = new TreeViewerColumn((TreeViewer)this.viewer, columnInfo.style);
                        colItem = column = item.getColumn();
                        column.setText(columnInfo.name);
                        column.setMoveable(true);
                        if (columnInfo.width > 0) {
                            column.setWidth(columnInfo.width);
                        }
                        if (!CommonUtils.isEmpty((String)columnInfo.description)) {
                            column.setToolTipText(columnInfo.description);
                        }
                        column.addControlListener((ControlListener)new ControlAdapter(){

                            public void controlResized(ControlEvent e) {
                                if (!ViewerColumnController.this.isInitializing && !ViewerColumnController.this.isPacking) {
                                    columnInfo.width = column.getWidth();
                                    if (ViewerColumnController.this.getRowCount() > 0) {
                                        ViewerColumnController.this.saveColumnConfig();
                                    }
                                }
                            }

                            public void controlMoved(ControlEvent e) {
                                if (!ViewerColumnController.this.isInitializing && e.getSource() instanceof TreeColumn) {
                                    ViewerColumnController.this.updateColumnOrder((Item)column, column.getParent().getColumnOrder());
                                }
                            }
                        });
                        columnInfo.column = column;
                        break block12;
                    }
                    if (!(this.viewer instanceof TableViewer)) break block13;
                    viewerColumn = item = new TableViewerColumn((TableViewer)this.viewer, columnInfo.style);
                    colItem = column = item.getColumn();
                    column.setText(columnInfo.name);
                    column.setMoveable(true);
                    column.setWidth(columnInfo.width);
                    if (!CommonUtils.isEmpty((String)columnInfo.description)) {
                        column.setToolTipText(columnInfo.description);
                    }
                    column.addControlListener((ControlListener)new ControlAdapter((TableColumn)column){
                        private final /* synthetic */ TableColumn val$column;
                        {
                            this.val$column = tableColumn;
                        }

                        public void controlResized(ControlEvent e) {
                            columnInfo.width = this.val$column.getWidth();
                            if (ViewerColumnController.this.getRowCount() > 0) {
                                ViewerColumnController.this.saveColumnConfig();
                            }
                        }

                        public void controlMoved(ControlEvent e) {
                            if (!ViewerColumnController.this.isInitializing && e.getSource() instanceof TableColumn) {
                                ViewerColumnController.this.updateColumnOrder((Item)this.val$column, this.val$column.getParent().getColumnOrder());
                            }
                        }
                    });
                    columnInfo.column = column;
                }
                viewerColumn.setLabelProvider(columnInfo.labelProvider);
                viewerColumn.setEditingSupport(columnInfo.editingSupport);
                colItem.setData((Object)columnInfo);
                if (columnInfo.labelProvider instanceof ILazyLabelProvider || columnInfo.labelProvider instanceof ColumnBooleanLabelProvider) {
                    hasCustomDraw = true;
                } else if (columnInfo.labelProvider instanceof ILabelProvider) {
                    columnInfo.sortListener = new SortListener(this.viewer, columnInfo);
                    columnInfo.column.addListener(13, (Listener)columnInfo.sortListener);
                }
            }
            ++i;
        }
        if (hasCustomDraw) {
            this.viewer.getControl().addListener(42, event -> {
                String lazyText;
                ColumnInfo columnInfo;
                TreeColumn column;
                if (this.viewer instanceof TreeViewer) {
                    column = ((TreeViewer)this.viewer).getTree().getColumn(event.index);
                    columnInfo = (ColumnInfo)column.getData();
                    if (columnInfo.labelProvider instanceof ILazyLabelProvider && CommonUtils.isEmpty((String)((TreeItem)event.item).getText(event.index)) && !CommonUtils.isEmpty((String)(lazyText = ((ILazyLabelProvider)columnInfo.labelProvider).getLazyText(event.item.getData())))) {
                        ((TreeItem)event.item).setText(event.index, lazyText);
                    }
                } else {
                    column = ((TableViewer)this.viewer).getTable().getColumn(event.index);
                    columnInfo = (ColumnInfo)column.getData();
                    if (columnInfo.labelProvider instanceof ILazyLabelProvider && CommonUtils.isEmpty((String)((TableItem)event.item).getText(event.index)) && !CommonUtils.isEmpty((String)(lazyText = ((ILazyLabelProvider)columnInfo.labelProvider).getLazyText(event.item.getData())))) {
                        ((TableItem)event.item).setText(event.index, lazyText);
                    }
                }
                if (columnInfo.labelProvider instanceof ColumnBooleanLabelProvider) {
                    Object element = event.item.getData();
                    Object cellValue = ((ColumnBooleanLabelProvider)columnInfo.labelProvider).getValueProvider().getValue(element);
                    this.cellRenderer.paintCell(event, element, cellValue, event.item, Boolean.class, event.index, true, (event.detail & 2) == 2);
                }
            });
        }
    }

    public List<ColumnInfo> getVisibleColumns() {
        ArrayList<ColumnInfo> visibleList = new ArrayList<ColumnInfo>();
        for (ColumnInfo column : this.columns) {
            if (!column.visible) continue;
            visibleList.add(column);
        }
        visibleList.sort(new ColumnInfoComparator());
        return visibleList;
    }

    private void readColumnsConfiguration() {
        Collection<ViewerColumnRegistry.ColumnState> savedConfig = ViewerColumnRegistry.getInstance().getSavedConfig(this.configId);
        if (savedConfig == null || savedConfig.isEmpty()) {
            return;
        }
        boolean hasVisible = false;
        for (ViewerColumnRegistry.ColumnState savedState : savedConfig) {
            if (!savedState.visible) continue;
            hasVisible = true;
            break;
        }
        if (!hasVisible) {
            return;
        }
        block1: for (ColumnInfo columnInfo : this.columns) {
            for (ViewerColumnRegistry.ColumnState savedState : savedConfig) {
                if (!columnInfo.name.equals(savedState.name)) continue;
                columnInfo.visible = savedState.visible;
                columnInfo.order = savedState.order;
                columnInfo.width = savedState.width;
                continue block1;
            }
        }
    }

    private ColumnInfo getColumnByIndex(int columnIndex) {
        Control control = this.viewer.getControl();
        ColumnInfo columnInfo = control instanceof Tree ? (ColumnInfo)((Tree)control).getColumn(columnIndex).getData() : (ColumnInfo)((Table)control).getColumn(columnIndex).getData();
        return columnInfo;
    }

    @Nullable
    private ColumnInfo getSortColumn() {
        Control control = this.viewer.getControl();
        if (control instanceof Tree) {
            Tree tree = (Tree)control;
            TreeColumn column = tree.getSortColumn();
            if (column != null) {
                return this.getColumnByIndex(tree.indexOf(column));
            }
        } else {
            Table table = (Table)control;
            TableColumn column = table.getSortColumn();
            if (column != null) {
                return this.getColumnByIndex(table.indexOf(column));
            }
        }
        return null;
    }

    private int getSortDirection() {
        Control control = this.viewer.getControl();
        if (control instanceof Tree) {
            return ((Tree)control).getSortDirection();
        }
        return ((Table)control).getSortDirection();
    }

    public COLUMN getColumnData(int columnIndex) {
        return (COLUMN)this.getColumnByIndex((int)columnIndex).userData;
    }

    public String getColumnName(int columnIndex) {
        return this.getColumnByIndex((int)columnIndex).name;
    }

    public COLUMN[] getColumnsData(Class<COLUMN> type) {
        Object[] newArray = (Object[])Array.newInstance(type, this.columns.size());
        int i = 0;
        while (i < this.columns.size()) {
            newArray[i] = type.cast(this.columns.get((int)i).userData);
            ++i;
        }
        return newArray;
    }

    public boolean configureColumns() {
        ConfigDialog configDialog = new ConfigDialog();
        if (configDialog.open() != 0) {
            return false;
        }
        this.saveColumnConfig();
        return true;
    }

    private void updateColumnOrder(Item column, int[] order) {
        if (this.isPacking) {
            return;
        }
        ColumnInfo columnInfo = (ColumnInfo)column.getData();
        boolean updated = false;
        int i = 0;
        while (i < order.length) {
            if (order[i] == columnInfo.order) {
                columnInfo.order = i;
                updated = true;
                break;
            }
            ++i;
        }
        if (updated) {
            this.saveColumnConfig();
        }
    }

    private void saveColumnConfig() {
        ViewerColumnRegistry.getInstance().updateConfig(this.configId, this.columns);
    }

    public int getColumnsCount() {
        Control control = this.viewer.getControl();
        return control instanceof Tree ? ((Tree)control).getColumnCount() : ((Table)control).getColumnCount();
    }

    public int getRowCount() {
        Control control = this.viewer.getControl();
        return control instanceof Tree ? ((Tree)control).getItemCount() : ((Table)control).getItemCount();
    }

    public int getEditableColumnIndex(Object element) {
        for (ColumnInfo info : this.getVisibleColumns()) {
            if (info.editingSupport == null) continue;
            return info.order;
        }
        return -1;
    }

    private static class ColumnInfo
    extends ViewerColumnRegistry.ColumnState {
        final String description;
        final int style;
        final boolean defaultVisible;
        final boolean required;
        final boolean numeric;
        final Object userData;
        final CellLabelProvider labelProvider;
        final EditingSupport editingSupport;
        Item column;
        SortListener sortListener;

        private ColumnInfo(String name, String description, int style, boolean defaultVisible, boolean required, boolean numeric, Object userData, CellLabelProvider labelProvider, EditingSupport editingSupport, int order) {
            this.name = name;
            this.description = description;
            this.style = style;
            this.defaultVisible = defaultVisible;
            this.required = required;
            this.numeric = numeric;
            this.userData = userData;
            this.visible = defaultVisible;
            this.labelProvider = labelProvider;
            this.editingSupport = editingSupport;
            this.order = order;
        }
    }

    private static class ColumnInfoComparator
    implements Comparator<ColumnInfo> {
        private ColumnInfoComparator() {
        }

        @Override
        public int compare(ColumnInfo o1, ColumnInfo o2) {
            return o1.order - o2.order;
        }
    }

    private class ConfigDialog
    extends BaseDialog {
        private Table colTable;

        protected ConfigDialog() {
            super(ViewerColumnController.this.viewer.getControl().getShell(), UINavigatorMessages.label_configure_columns, (DBPImage)UIIcon.CONFIGURATION);
        }

        protected void setShellStyle(int newShellStyle) {
            super.setShellStyle(newShellStyle & 0xFFFFFBFF);
        }

        protected boolean isResizable() {
            return true;
        }

        protected Composite createDialogArea(Composite parent) {
            Composite composite = super.createDialogArea(parent);
            UIUtils.createControlLabel((Composite)composite, (String)UINavigatorMessages.label_select_columns);
            ArrayList<ColumnInfo> orderedList = new ArrayList<ColumnInfo>(ViewerColumnController.this.columns);
            orderedList.sort(new ColumnInfoComparator());
            this.colTable = new Table(composite, 2848);
            this.colTable.setLayoutData((Object)new GridData(1808));
            this.colTable.setLinesVisible(true);
            this.colTable.setHeaderVisible(true);
            this.colTable.addListener(13, event -> {
                if (event.detail == 32 && ((TableItem)event.item).getGrayed()) {
                    ((TableItem)event.item).setChecked(true);
                    event.doit = false;
                }
            });
            TableColumn nameColumn = new TableColumn(this.colTable, 16384);
            nameColumn.setText(UINavigatorMessages.label_name);
            TableColumn descColumn = new TableColumn(this.colTable, 16384);
            descColumn.setText(UINavigatorMessages.label_description);
            for (ColumnInfo columnInfo : orderedList) {
                TableItem colItem = new TableItem(this.colTable, 0);
                colItem.setData((Object)columnInfo);
                colItem.setText(0, columnInfo.name);
                if (!CommonUtils.isEmpty((String)columnInfo.description)) {
                    colItem.setText(1, columnInfo.description);
                }
                colItem.setChecked(columnInfo.visible);
                if (!columnInfo.required) continue;
                colItem.setGrayed(true);
            }
            nameColumn.pack();
            if (nameColumn.getWidth() > 300) {
                nameColumn.setWidth(300);
            }
            descColumn.pack();
            if (descColumn.getWidth() > 400) {
                descColumn.setWidth(400);
            }
            return parent;
        }

        protected void okPressed() {
            boolean recreateColumns = false;
            TableItem[] tableItemArray = this.colTable.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                ColumnInfo ci = (ColumnInfo)item.getData();
                if (item.getChecked() != ci.visible) {
                    ci.visible = item.getChecked();
                    recreateColumns = true;
                }
                ++n2;
            }
            if (recreateColumns) {
                ViewerColumnController.this.recreateColumns(true);
            }
            super.okPressed();
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 13, UIMessages.button_reset_to_defaults, false);
            super.createButtonsForButtonBar(parent);
        }

        protected void buttonPressed(int buttonId) {
            if (buttonId == 13) {
                this.resetToDefaults();
            }
            super.buttonPressed(buttonId);
        }

        private void resetToDefaults() {
            TableItem[] tableItemArray = this.colTable.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                ColumnInfo ci = (ColumnInfo)item.getData();
                item.setChecked(ci.defaultVisible);
                ++n2;
            }
        }
    }

    public static class DefaultComparator
    extends ViewerComparator {
        public DefaultComparator(@Nullable Comparator<? super String> comparator) {
            super(comparator);
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int cat2;
            int cat1 = this.category(e1);
            if (cat1 != (cat2 = this.category(e2))) {
                return cat1 - cat2;
            }
            String name1 = this.getLabel(viewer, e1);
            String name2 = this.getLabel(viewer, e2);
            int result = 0;
            if (CommonUtils.equalObjects((Object)name1, (Object)name2)) {
                return 0;
            }
            if (name1 == null) {
                result = -1;
            } else if (name2 == null) {
                result = 1;
            }
            if (result == 0 && DefaultComparator.isNumeric(viewer)) {
                try {
                    NumberFormat numberFormat = NumberFormat.getInstance();
                    Number number1 = numberFormat.parse(name1);
                    Number number2 = numberFormat.parse(name2);
                    result = CommonUtils.compareNumbers((Number)number1, (Number)number2);
                }
                catch (Exception exception) {}
            }
            if (result == 0) {
                result = this.getComparator().compare(name1, name2);
            }
            return DefaultComparator.isReversed(viewer) ? -result : result;
        }

        @Nullable
        private String getLabel(@NotNull Viewer viewer, @Nullable Object element) {
            ColumnInfo column = DefaultComparator.getColumnInfo(viewer);
            if (column == null) {
                return null;
            }
            if (column.labelProvider instanceof ILabelProviderEx) {
                return ((ILabelProviderEx)column.labelProvider).getText(element, false);
            }
            return ((ILabelProvider)column.labelProvider).getText(element);
        }

        private static boolean isNumeric(@NotNull Viewer viewer) {
            ColumnInfo column = DefaultComparator.getColumnInfo(viewer);
            return column != null && column.numeric;
        }

        private static boolean isReversed(@NotNull Viewer viewer) {
            return ViewerColumnController.getFromControl(viewer.getControl()).getSortDirection() == 1024;
        }

        @Nullable
        private static ColumnInfo getColumnInfo(@NotNull Viewer viewer) {
            return ViewerColumnController.getFromControl(viewer.getControl()).getSortColumn();
        }
    }

    private static class SortListener
    implements Listener {
        ColumnViewer viewer;
        ColumnInfo columnInfo;
        int sortDirection = 128;
        Item prevColumn = null;

        public SortListener(ColumnViewer viewer, ColumnInfo columnInfo) {
            this.viewer = viewer;
            this.columnInfo = columnInfo;
        }

        public void handleEvent(Event e) {
            Item column = (Item)e.widget;
            if (this.prevColumn == column) {
                this.sortDirection = this.sortDirection == 128 ? 1024 : 128;
            }
            this.prevColumn = column;
            this.sortViewer(column, this.sortDirection);
        }

        private void sortViewer(Item column, int sortDirection) {
            if (this.viewer instanceof TreeViewer) {
                ((TreeViewer)this.viewer).getTree().setSortColumn((TreeColumn)column);
                ((TreeViewer)this.viewer).getTree().setSortDirection(sortDirection);
            } else {
                ((TableViewer)this.viewer).getTable().setSortColumn((TableColumn)column);
                ((TableViewer)this.viewer).getTable().setSortDirection(sortDirection);
            }
            this.viewer.refresh();
        }
    }
}

