/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.app.standalone.rpc;

import java.io.File;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ui.app.standalone.rpc.IInstanceController;

public class InstanceClient {
    private static final Log log = Log.getLog(InstanceClient.class);

    @Nullable
    public static IInstanceController createClient(@NotNull String location) {
        return InstanceClient.createClient(location, false);
    }

    @Nullable
    public static IInstanceController createClient(@NotNull String location, boolean quiet) {
        File rmiFile;
        block13: {
            try {
                rmiFile = new File(location, ".metadata/dbeaver-instance.properties");
                if (rmiFile.exists()) break block13;
                return null;
            }
            catch (Exception e) {
                if (!quiet) {
                    log.debug((Object)("Error instantiating RMI client: " + e.getMessage()));
                }
                return null;
            }
        }
        Properties props = new Properties();
        Throwable throwable = null;
        Object var5_7 = null;
        try (FileInputStream is = new FileInputStream(rmiFile);){
            props.load(is);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        String rmiPort = props.getProperty("port");
        Registry registry = LocateRegistry.getRegistry(InetAddress.getLoopbackAddress().getHostAddress(), Integer.parseInt(rmiPort));
        return (IInstanceController)registry.lookup("DBeaver.InstanceController");
    }
}

