/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.tasks;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.tasks.PostgreBackupRestoreSettings;
import org.jkiss.dbeaver.ext.postgresql.tasks.PostgreDatabaseRestoreInfo;
import org.jkiss.dbeaver.ext.postgresql.tasks.PostgreDatabaseRestoreSettings;
import org.jkiss.dbeaver.ext.postgresql.tasks.PostgreNativeToolHandler;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.registry.task.TaskPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tasks.nativetool.AbstractNativeToolSettings;
import org.jkiss.utils.CommonUtils;

public class PostgreDatabaseRestoreHandler
extends PostgreNativeToolHandler<PostgreDatabaseRestoreSettings, DBSObject, PostgreDatabaseRestoreInfo> {
    public Collection<PostgreDatabaseRestoreInfo> getRunInfo(PostgreDatabaseRestoreSettings settings) {
        return Collections.singletonList(settings.getRestoreInfo());
    }

    protected PostgreDatabaseRestoreSettings createTaskSettings(DBRRunnableContext context, DBTTask task) throws DBException {
        PostgreDatabaseRestoreSettings settings = new PostgreDatabaseRestoreSettings();
        settings.loadSettings(context, (DBPPreferenceStore)new TaskPreferenceStore(task));
        return settings;
    }

    protected boolean validateTaskParameters(DBTTask task, PostgreDatabaseRestoreSettings settings, Log log) {
        File dir;
        if (task.getType().getId().equals("pgDatabaseBackup") && !(dir = new File(settings.getOutputFilePattern())).exists() && !dir.mkdirs()) {
            log.error((Object)("Can't create directory '" + dir.getAbsolutePath() + "'"));
            return false;
        }
        return true;
    }

    protected boolean needsModelRefresh() {
        return true;
    }

    @Override
    public boolean isVerbose() {
        return true;
    }

    @Override
    public void fillProcessParameters(PostgreDatabaseRestoreSettings settings, PostgreDatabaseRestoreInfo arg, List<String> cmd) throws IOException {
        super.fillProcessParameters(settings, arg, cmd);
        if (settings.isCleanFirst()) {
            cmd.add("--clean");
        }
        if (settings.isNoOwner()) {
            cmd.add("--no-owner");
        }
        if (settings.isCreateDatabase()) {
            cmd.add("--create");
        }
    }

    @Override
    protected boolean isExportWizard() {
        return false;
    }

    protected List<String> getCommandLine(PostgreDatabaseRestoreSettings settings, PostgreDatabaseRestoreInfo arg) throws IOException {
        List databaseObjects;
        ArrayList<String> cmd = new ArrayList<String>();
        this.fillProcessParameters(settings, arg, cmd);
        if (settings.getFormat() != PostgreBackupRestoreSettings.ExportFormat.PLAIN) {
            cmd.add("--format=" + settings.getFormat().getId());
        }
        if (!CommonUtils.isEmpty((Collection)(databaseObjects = settings.getDatabaseObjects()))) {
            cmd.add("--dbname=" + ((DBSObject)databaseObjects.get(0)).getName());
        }
        cmd.add(settings.getInputFile());
        return cmd;
    }

    protected boolean isLogInputStream() {
        return false;
    }

    protected boolean isMergeProcessStreams() {
        return false;
    }

    protected void startProcessHandler(DBRProgressMonitor monitor, DBTTask task, PostgreDatabaseRestoreSettings settings, PostgreDatabaseRestoreInfo arg, ProcessBuilder processBuilder, Process process, Log log) throws IOException {
        File inputFile = new File(settings.getInputFile());
        if (!inputFile.exists()) {
            throw new IOException("File '" + inputFile.getAbsolutePath() + "' doesn't exist");
        }
        super.startProcessHandler(monitor, task, (AbstractNativeToolSettings)settings, (Object)arg, processBuilder, process, log);
    }

    public void validateErrorCode(int exitCode) throws IOException {
        if (exitCode == 1) {
            DBWorkbench.getPlatformUI().showWarningNotification("Warning", "Database restore finished with warnings.\nPlease check the error log to see what is wrong.");
        } else {
            super.validateErrorCode(exitCode);
        }
    }
}

