/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.h2.model;

import java.sql.ResultSet;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericFunctionResultType;
import org.jkiss.dbeaver.ext.generic.model.GenericPackage;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedure;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;
import org.jkiss.utils.CommonUtils;

public class H2RoutineAlias
extends GenericProcedure {
    private String javaClass;
    private String javaMethod;
    private String javaClassAndMethod;
    private String source;

    public H2RoutineAlias(@NotNull GenericStructContainer container, @NotNull String procedureName, String description, DBSProcedureType procedureType, @Nullable GenericFunctionResultType functionResultType, @NotNull JDBCResultSet dbResult) {
        super(container, procedureName, procedureName, description, procedureType, functionResultType);
        if (!((GenericDataSource)this.getDataSource()).isServerVersionAtLeast(2, 0)) {
            this.javaClass = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"JAVA_CLASS");
            this.javaMethod = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"JAVA_METHOD");
            this.source = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SOURCE");
        } else {
            this.javaClassAndMethod = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"EXTERNAL_NAME");
            this.source = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ROUTINE_DEFINITION");
        }
    }

    @Property(viewable=true, order=7)
    public String getJavaClass() {
        return this.javaClass;
    }

    @Property(viewable=true, order=8)
    public String getJavaMethod() {
        return this.javaMethod;
    }

    @Property(viewable=true, editable=true, updatable=true, length=PropertyLength.MULTILINE, order=100)
    @Nullable
    public String getDescription() {
        return super.getDescription();
    }

    public GenericPackage getPackage() {
        return super.getPackage();
    }

    public GenericCatalog getCatalog() {
        return super.getCatalog();
    }

    public GenericFunctionResultType getFunctionResultType() {
        return super.getFunctionResultType();
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) {
        StringBuilder sourceDDL = new StringBuilder(128);
        sourceDDL.append("CREATE ALIAS ").append(this.getFullyQualifiedName(DBPEvaluationContext.DDL));
        if (CommonUtils.isNotEmpty((String)this.source)) {
            sourceDDL.append(" AS $$\n").append(this.source).append("$$");
        } else if (CommonUtils.isNotEmpty((String)this.javaClass) && CommonUtils.isNotEmpty((String)this.javaMethod)) {
            sourceDDL.append(" FOR \"").append(this.javaClass).append(".").append(this.javaMethod).append("\";");
        } else if (CommonUtils.isNotEmpty((String)this.javaClassAndMethod) && !"null.null".equals(this.javaClassAndMethod)) {
            sourceDDL.append(" FOR \"").append(this.javaClassAndMethod).append("\";");
        }
        return sourceDDL.toString();
    }
}

