/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui.nativetool;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocation;
import org.jkiss.dbeaver.model.connection.LocalNativeClientLocation;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.registry.task.TaskPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tasks.nativetool.AbstractNativeToolSettings;
import org.jkiss.dbeaver.tasks.ui.nativetool.NativeToolWizardPageLog;
import org.jkiss.dbeaver.tasks.ui.nativetool.internal.TaskNativeUIMessages;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskConfigurationWizard;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskConfigurationWizardDialog;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskWizardExecutor;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public abstract class AbstractNativeToolWizard<SETTINGS extends AbstractNativeToolSettings<BASE_OBJECT>, BASE_OBJECT extends DBSObject, PROCESS_ARG>
extends TaskConfigurationWizard<SETTINGS> {
    private static final Log log = Log.getLog(AbstractNativeToolWizard.class);
    private final DBPPreferenceStore preferenceStore;
    private final SETTINGS settings;
    protected String taskTitle;
    protected final NativeToolWizardPageLog logPage;
    private boolean finished;
    private String errorMessage;

    protected AbstractNativeToolWizard(@NotNull Collection<BASE_OBJECT> databaseObjects, @NotNull String taskTitle) {
        this.preferenceStore = DBWorkbench.getPlatform().getPreferenceStore();
        this.settings = this.createSettings();
        this.settings.getDatabaseObjects().addAll(databaseObjects);
        this.taskTitle = taskTitle;
        this.logPage = new NativeToolWizardPageLog(taskTitle);
    }

    public AbstractNativeToolWizard(@NotNull DBTTask task) {
        super(task);
        this.preferenceStore = new TaskPreferenceStore(task);
        this.settings = this.createSettings();
        this.taskTitle = task.getType().getName();
        this.logPage = new NativeToolWizardPageLog(this.taskTitle);
    }

    protected abstract SETTINGS createSettings();

    public SETTINGS getSettings() {
        return this.settings;
    }

    @NotNull
    protected DBPPreferenceStore getPreferenceStore() {
        return this.preferenceStore;
    }

    public DBPProject getProject() {
        if (this.settings.getDataSourceContainer() != null) {
            return this.settings.getDataSourceContainer().getProject();
        }
        return super.getProject();
    }

    protected String getDefaultWindowTitle() {
        return this.taskTitle;
    }

    public boolean canFinish() {
        if (!super.canFinish()) {
            return false;
        }
        if (this.isSingleTimeWizard()) {
            return !this.finished;
        }
        return true;
    }

    protected boolean isSingleTimeWizard() {
        return false;
    }

    public void initializeWizard(Composite pageContainer) {
        try {
            this.settings.loadSettings(UIUtils.getDefaultRunnableContext(), this.getPreferenceStore());
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Settings load", "Error loading wizard settings", (Throwable)e);
        }
        super.initializeWizard(pageContainer);
        this.readLocalClientInfo();
    }

    void readLocalClientInfo() {
        WizardPage currentPage = (WizardPage)this.getStartingPage();
        if (this.isNativeClientHomeRequired()) {
            String clientHomeId = this.getSettings().getDataSourceContainer().getConnectionConfiguration().getClientHomeId();
            List nativeClientLocations = this.getSettings().getDataSourceContainer().getDriver().getNativeClientLocations();
            if (CommonUtils.isEmpty((String)clientHomeId)) {
                if (nativeClientLocations != null && !nativeClientLocations.isEmpty()) {
                    this.settings.setClientHome((DBPNativeClientLocation)nativeClientLocations.get(0));
                } else {
                    this.settings.setClientHome(null);
                }
                if (this.settings.getClientHome() == null) {
                    currentPage.setErrorMessage(TaskNativeUIMessages.tools_wizard_message_no_client_home);
                    this.getContainer().updateMessage();
                    return;
                }
            } else {
                DBPNativeClientLocation clientHome = (DBPNativeClientLocation)DBUtils.findObject((Collection)nativeClientLocations, (String)clientHomeId);
                if (clientHome == null) {
                    clientHome = this.getSettings().findNativeClientHome(clientHomeId);
                }
                if (clientHome == null) {
                    clientHome = new LocalNativeClientLocation(clientHomeId, clientHomeId);
                }
                this.settings.setClientHome(clientHome);
            }
            if (this.settings.getClientHome() == null) {
                currentPage.setErrorMessage(NLS.bind((String)TaskNativeUIMessages.tools_wizard_message_client_home_not_found, (Object)clientHomeId));
            } else {
                currentPage.setErrorMessage(null);
            }
            this.getContainer().updateMessage();
            this.getContainer().updateButtons();
        }
    }

    private boolean validateClientFiles() {
        if (!this.isNativeClientHomeRequired() || this.settings.getClientHome() == null) {
            return true;
        }
        try {
            UIUtils.run((IRunnableContext)this.getContainer(), (boolean)true, (boolean)true, monitor -> {
                try {
                    this.settings.getClientHome().validateFilesPresence(monitor);
                }
                catch (DBException e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError("Download native client file(s)", "Error downloading client file(s)", e.getTargetException());
            ((WizardPage)this.getContainer().getCurrentPage()).setErrorMessage("Error downloading native client file(s)");
            this.getContainer().updateMessage();
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    public boolean performFinish() {
        this.settings.saveSettings(this.getRunnableContext(), this.getPreferenceStore());
        if (!this.validateClientFiles()) {
            return false;
        }
        if (this.getCurrentTask() != null) {
            return super.performFinish();
        }
        TaskConfigurationWizardDialog container = this.getContainer();
        container.disableButtonsOnProgress();
        this.showLogPage();
        try {
            DBTTask temporaryTask = this.getProject().getTaskManager().createTemporaryTask(this.getTaskType(), this.getTaskType().getName());
            this.saveConfigurationToTask(temporaryTask);
            TaskWizardExecutor executor = new TaskWizardExecutor(this.getRunnableContext(), temporaryTask, log, this.logPage.getLogWriter());
            executor.executeTask();
            container.enableButtonsAfterProgress();
            container.setCompleteMarkAfterProgress();
            return false;
        }
        catch (Exception e) {
            DBWorkbench.getPlatformUI().showError(e.getMessage(), "Error running task", (Throwable)e);
            return false;
        }
    }

    protected void showLogPage() {
        if (this.getContainer().getCurrentPage() != this.logPage) {
            this.getContainer().showPage((IWizardPage)this.logPage);
        }
    }

    protected void notifyToolFinish(String toolName, long workTime) {
        Display.getCurrent().beep();
        if (workTime > DBWorkbench.getPlatformUI().getLongOperationTimeout() * 1000L) {
            DBWorkbench.getPlatformUI().notifyAgent(toolName, 1);
        }
    }

    public String getObjectsName() {
        StringBuilder str = new StringBuilder();
        return str.toString();
    }

    protected boolean isNativeClientHomeRequired() {
        return true;
    }

    public boolean isVerbose() {
        return false;
    }

    protected void onSuccess(long workTime) {
    }

    protected void onError() {
        UIUtils.showMessageBox((Shell)this.getShell(), (String)this.taskTitle, (String)(this.errorMessage == null ? "Internal error" : this.errorMessage), (int)1);
    }
}

