/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPDataFormatterRegistry;
import org.jkiss.dbeaver.model.app.DBPGlobalEventManager;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.app.DBPPlatformLanguage;
import org.jkiss.dbeaver.model.app.DBPPlatformLanguageManager;
import org.jkiss.dbeaver.model.connection.DBPDataSourceProviderRegistry;
import org.jkiss.dbeaver.model.data.DBDRegistry;
import org.jkiss.dbeaver.model.edit.DBERegistry;
import org.jkiss.dbeaver.model.fs.DBFRegistry;
import org.jkiss.dbeaver.model.impl.preferences.AbstractPreferenceStore;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.OSDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.DataSourceRegistry;
import org.jkiss.dbeaver.registry.GlobalEventManagerImpl;
import org.jkiss.dbeaver.registry.ObjectManagerRegistry;
import org.jkiss.dbeaver.registry.PluginServiceRegistry;
import org.jkiss.dbeaver.registry.datatype.DataTypeProviderRegistry;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.registry.formatter.DataFormatterRegistry;
import org.jkiss.dbeaver.registry.fs.FileSystemProviderRegistry;
import org.jkiss.dbeaver.registry.language.PlatformLanguageRegistry;
import org.jkiss.dbeaver.runtime.IPluginService;
import org.jkiss.dbeaver.runtime.jobs.DataSourceMonitorJob;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public abstract class BasePlatformImpl
implements DBPPlatform,
DBPPlatformLanguageManager {
    private static final Log log = Log.getLog(BasePlatformImpl.class);
    private static final String APP_CONFIG_FILE = "dbeaver.ini";
    private static final String ECLIPSE_CONFIG_FILE = "eclipse.ini";
    private static final String CONFIG_FILE = "config.ini";
    private DBPPlatformLanguage language;
    private OSDescriptor localSystem;
    private DBNModel navigatorModel;
    private final List<IPluginService> activatedServices = new ArrayList<IPluginService>();

    protected void initialize() {
        log.debug((Object)"Initialize base platform...");
        DBPPreferenceStore prefsStore = this.getPreferenceStore();
        prefsStore.addPropertyChangeListener(event -> {
            for (DBPDataSourceContainer ds : DataSourceRegistry.getAllDataSources()) {
                ((AbstractPreferenceStore)ds.getPreferenceStore()).firePropertyChangeEvent((Object)prefsStore, event.getProperty(), event.getOldValue(), event.getNewValue());
            }
        });
        this.localSystem = new OSDescriptor(Platform.getOS(), Platform.getOSArch());
        this.language = PlatformLanguageRegistry.getInstance().getLanguage(Locale.getDefault());
        if (this.language == null) {
            log.debug((Object)("Language for locale '" + Locale.getDefault() + "' not found. Use default."));
            this.language = PlatformLanguageRegistry.getInstance().getLanguage(Locale.ENGLISH);
        }
        this.navigatorModel = new DBNModel((DBPPlatform)this, null);
        this.navigatorModel.initialize();
        if (!this.getApplication().isExclusiveMode()) {
            for (IPluginService pluginService : PluginServiceRegistry.getInstance().getServices()) {
                try {
                    pluginService.activateService();
                    this.activatedServices.add(pluginService);
                }
                catch (Throwable e) {
                    log.error((Object)"Error activating plugin service", e);
                }
            }
            new DataSourceMonitorJob((DBPPlatform)this).scheduleMonitor();
        }
    }

    public synchronized void dispose() {
        for (IPluginService pluginService : this.activatedServices) {
            try {
                pluginService.deactivateService();
            }
            catch (Exception e) {
                log.error((Object)"Error deactivating plugin service", (Throwable)e);
            }
        }
        this.activatedServices.clear();
        if (this.navigatorModel != null) {
            this.navigatorModel.dispose();
        }
    }

    @NotNull
    public DBDRegistry getValueHandlerRegistry() {
        return DataTypeProviderRegistry.getInstance();
    }

    @NotNull
    public DBERegistry getEditorsRegistry() {
        return ObjectManagerRegistry.getInstance();
    }

    @NotNull
    public DBFRegistry getFileSystemRegistry() {
        return FileSystemProviderRegistry.getInstance();
    }

    public DBPGlobalEventManager getGlobalEventManager() {
        return GlobalEventManagerImpl.getInstance();
    }

    @NotNull
    public DBPDataFormatterRegistry getDataFormatterRegistry() {
        return DataFormatterRegistry.getInstance();
    }

    @NotNull
    public File getApplicationConfiguration() {
        File configPath;
        try {
            configPath = RuntimeUtils.getLocalFileFromURL((URL)Platform.getInstallLocation().getURL());
        }
        catch (IOException e) {
            throw new IllegalStateException("Can't detect application installation folder.", e);
        }
        File iniFile = new File(configPath, ECLIPSE_CONFIG_FILE);
        if (!iniFile.exists()) {
            iniFile = new File(configPath, APP_CONFIG_FILE);
        }
        return iniFile;
    }

    @NotNull
    public OSDescriptor getLocalSystem() {
        return this.localSystem;
    }

    @NotNull
    public DBPPlatformLanguage getLanguage() {
        return this.language;
    }

    public void setPlatformLanguage(@NotNull DBPPlatformLanguage language) throws DBException {
        if (CommonUtils.equalObjects((Object)language, (Object)this.language)) {
            return;
        }
        try {
            Object var5_8;
            Throwable throwable;
            File config = new File(RuntimeUtils.getLocalFileFromURL((URL)Platform.getConfigurationLocation().getURL()), CONFIG_FILE);
            Properties properties = new Properties();
            if (config.exists()) {
                throwable = null;
                var5_8 = null;
                try (FileInputStream is = new FileInputStream(config);){
                    properties.load(is);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            properties.put("osgi.nl", language.getCode());
            throwable = null;
            var5_8 = null;
            try (FileOutputStream os = new FileOutputStream(config);){
                properties.store(os, null);
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            this.language = language;
            this.getPreferenceStore().setValue("platform.language", language.getCode());
        }
        catch (IOException e) {
            throw new DBException("Unexpected error while saving startup configuration", (Throwable)e);
        }
    }

    @NotNull
    public DBNModel getNavigatorModel() {
        return this.navigatorModel;
    }

    @NotNull
    public DBPDataSourceProviderRegistry getDataSourceProviderRegistry() {
        return DataSourceProviderRegistry.getInstance();
    }

    @NotNull
    public Path getCustomDriversHome() {
        return DriverDescriptor.getCustomDriversHome();
    }

    public boolean isReadOnly() {
        return Platform.getInstanceLocation().isReadOnly();
    }
}

