/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dashboard.view;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dashboard.control.DashboardItem;
import org.jkiss.dbeaver.ui.dashboard.control.DashboardList;
import org.jkiss.dbeaver.ui.dashboard.control.DashboardListViewer;
import org.jkiss.dbeaver.ui.dashboard.internal.UIDashboardActivator;
import org.jkiss.dbeaver.ui.dashboard.internal.UIDashboardMessages;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardViewContainer;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;

public class DashboardItemViewDialog
extends BaseDialog {
    private static final String DIALOG_ID = "DBeaver.DashboardItemViewDialog";
    private final DashboardViewContainer parentPart;
    private final DashboardItem sourceItem;

    public DashboardItemViewDialog(DashboardViewContainer parentPart, DashboardItem sourceItem) {
        super(parentPart.getSite().getShell(), UIDashboardMessages.dialog_dashboard_item_view_title, null);
        this.parentPart = parentPart;
        this.sourceItem = sourceItem;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getSettingsSection((IDialogSettings)UIDashboardActivator.getDefault().getDialogSettings(), (String)DIALOG_ID);
    }

    protected Composite createDialogArea(Composite parent) {
        Composite dialogArea = super.createDialogArea(parent);
        Composite chartGroup = UIUtils.createPlaceholder((Composite)dialogArea, (int)1);
        GridData gd = new GridData(1808);
        gd.widthHint = 450;
        gd.heightHint = 300;
        chartGroup.setLayoutData((Object)gd);
        chartGroup.setLayout((Layout)new FillLayout());
        DashboardListViewer dashboardListViewer = new DashboardListViewer(this.parentPart.getSite(), this.sourceItem.getDataSourceContainer(), this.parentPart.getViewConfiguration());
        dashboardListViewer.setSingleChartMode(true);
        dashboardListViewer.createControl(chartGroup);
        DashboardItem targetItem = new DashboardItem((DashboardList)dashboardListViewer.getDefaultGroup(), this.sourceItem.getDashboardId());
        targetItem.moveViewFrom(this.sourceItem, false);
        return dialogArea;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, true);
        UIUtils.asyncExec(() -> {
            boolean bl = this.getButton(0).setFocus();
        });
    }
}

