/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.snowflake.ui.config;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.jkiss.dbeaver.ext.snowflake.ui.internal.SnowflakeMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.DatabaseNativeAuthModelConfigurator;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;
import org.jkiss.utils.CommonUtils;

public class SnowflakeAuthSnowflakeConfigurator
extends DatabaseNativeAuthModelConfigurator {
    private Combo userRoleCombo;
    private Combo authTypeCombo;

    public void createControl(Composite parent, Runnable propertyChangeListener) {
        ModifyListener textListener = e -> propertyChangeListener.run();
        this.usernameLabel = UIUtils.createLabel((Composite)parent, (String)UIConnectionMessages.dialog_connection_auth_label_username);
        this.usernameLabel.setLayoutData((Object)new GridData(32));
        this.createUserNameControls(parent, propertyChangeListener);
        if (this.supportsPassword()) {
            this.createPasswordControls(parent, propertyChangeListener);
        }
        Label userRoleLabel = UIUtils.createControlLabel((Composite)parent, (String)SnowflakeMessages.label_role);
        userRoleLabel.setLayoutData((Object)new GridData(32));
        this.userRoleCombo = new Combo(parent, 4);
        GridData gd = new GridData(2);
        gd.widthHint = UIUtils.getFontHeight((Control)this.userRoleCombo) * 10;
        this.userRoleCombo.setLayoutData((Object)gd);
        this.userRoleCombo.select(0);
        this.userRoleCombo.addModifyListener(textListener);
        if (this.needsAuthTypeSelector()) {
            UIUtils.createControlLabel((Composite)parent, (String)SnowflakeMessages.label_authenticator);
            this.authTypeCombo = new Combo(parent, 2052);
            this.authTypeCombo.add("");
            this.authTypeCombo.add("snowflake");
            this.authTypeCombo.add("externalbrowser");
            gd = new GridData(800);
            this.authTypeCombo.setLayoutData((Object)gd);
            this.authTypeCombo.addModifyListener(textListener);
        }
    }

    protected boolean needsAuthTypeSelector() {
        return true;
    }

    public void loadSettings(DBPDataSourceContainer dataSource) {
        super.loadSettings(dataSource);
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        String roleName = connectionInfo.getAuthProperty("role");
        if (roleName != null) {
            this.userRoleCombo.setText(roleName);
        }
        if (this.authTypeCombo != null) {
            String authName = connectionInfo.getAuthProperty("authenticator");
            if (CommonUtils.isEmpty((String)authName)) {
                authName = CommonUtils.notEmpty((String)connectionInfo.getProviderProperty("@dbeaver-authenticator@"));
            }
            this.authTypeCombo.setText(authName);
        }
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        super.saveSettings(dataSource);
        String roleName = this.userRoleCombo.getText();
        DBPConnectionConfiguration configuration = dataSource.getConnectionConfiguration();
        if (!CommonUtils.isEmpty((String)roleName)) {
            configuration.setAuthProperty("role", roleName);
        }
        if (this.authTypeCombo != null) {
            configuration.setAuthProperty("authenticator", this.authTypeCombo.getText().trim());
        }
        configuration.removeProviderProperty("@dbeaver-authenticator@");
        configuration.removeProviderProperty("@dbeaver-role@");
    }

    public void resetSettings(DBPDataSourceContainer dataSource) {
        super.resetSettings(dataSource);
    }

    protected boolean supportsPassword() {
        return true;
    }
}

