/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef3.ui.palette.editparts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2dl.Border;
import org.eclipse.draw2dl.IFigure;
import org.eclipse.draw2dl.MarginBorder;
import org.eclipse.draw2dl.geometry.Dimension;
import org.eclipse.draw2dl.text.FlowPage;
import org.eclipse.draw2dl.text.TextFlow;
import org.eclipse.gef3.AccessibleEditPart;
import org.eclipse.gef3.DragTracker;
import org.eclipse.gef3.Request;
import org.eclipse.gef3.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef3.palette.PaletteContainer;
import org.eclipse.gef3.palette.PaletteEntry;
import org.eclipse.gef3.palette.PaletteSeparator;
import org.eclipse.gef3.tools.SelectEditPartTracker;
import org.eclipse.gef3.ui.palette.PaletteMessages;
import org.eclipse.gef3.ui.palette.PaletteViewer;
import org.eclipse.gef3.ui.palette.PaletteViewerPreferences;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;

public abstract class PaletteEditPart
extends AbstractGraphicalEditPart
implements PropertyChangeListener {
    public static final String XML_NAME = "entry";
    private static final Border TOOLTIP_BORDER = new MarginBorder(0, 2, 1, 0);
    private static ImageCache globalImageCache;
    private AccessibleEditPart acc;
    private PropertyChangeListener childListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("Visible")) {
                PaletteEditPart.this.refreshChildren();
            }
        }
    };
    private Image image;
    private ImageDescriptor imgDescriptor;

    public PaletteEditPart(PaletteEntry model) {
        this.setModel(model);
    }

    @Override
    public void activate() {
        super.activate();
        PaletteEntry model = (PaletteEntry)this.getModel();
        model.addPropertyChangeListener(this);
        this.traverseChildren(model, true);
    }

    protected AccessibleEditPart createAccessible() {
        return null;
    }

    @Override
    public void createEditPolicies() {
    }

    protected IFigure createToolTip() {
        String message = this.getToolTipText();
        if (message == null || message.length() == 0) {
            return null;
        }
        FlowPage fp = new FlowPage(){

            public Dimension getPreferredSize(int w, int h) {
                Dimension d = super.getPreferredSize(-1, -1);
                if (d.width > 150) {
                    d = super.getPreferredSize(150, -1);
                }
                return d;
            }
        };
        fp.setOpaque(true);
        fp.setBorder(TOOLTIP_BORDER);
        TextFlow tf = new TextFlow();
        tf.setText(message);
        fp.add((IFigure)tf);
        return fp;
    }

    @Override
    public void deactivate() {
        PaletteEntry model = (PaletteEntry)this.getModel();
        model.removePropertyChangeListener(this);
        this.traverseChildren(model, false);
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
        super.deactivate();
    }

    @Override
    protected AccessibleEditPart getAccessibleEditPart() {
        if (this.acc == null) {
            this.acc = this.createAccessible();
        }
        return this.acc;
    }

    @Override
    public DragTracker getDragTracker(Request request) {
        return new SingleSelectionTracker();
    }

    protected static ImageCache getImageCache() {
        ImageCache cache = globalImageCache;
        if (cache == null) {
            globalImageCache = cache = new ImageCache();
            Display display = Display.getDefault();
            if (display != null) {
                display.disposeExec(new Runnable(){

                    @Override
                    public void run() {
                        if (globalImageCache != null) {
                            globalImageCache.dispose();
                            globalImageCache = null;
                        }
                    }
                });
            }
        }
        return cache;
    }

    @Override
    public List getModelChildren() {
        if (!(this.getModel() instanceof PaletteContainer)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList modelChildren = new ArrayList(((PaletteContainer)this.getModel()).getChildren());
        PaletteEntry prevVisibleEntry = null;
        Iterator iter = modelChildren.iterator();
        while (iter.hasNext()) {
            PaletteEntry entry = (PaletteEntry)iter.next();
            if (!entry.isVisible()) {
                iter.remove();
                continue;
            }
            if (entry instanceof PaletteSeparator && prevVisibleEntry == null) {
                iter.remove();
                continue;
            }
            if (entry instanceof PaletteSeparator && prevVisibleEntry instanceof PaletteSeparator) {
                iter.remove();
                continue;
            }
            prevVisibleEntry = entry;
        }
        if (prevVisibleEntry instanceof PaletteSeparator) {
            modelChildren.remove(prevVisibleEntry);
        }
        return modelChildren;
    }

    protected PaletteEntry getPaletteEntry() {
        return (PaletteEntry)this.getModel();
    }

    protected PaletteViewer getPaletteViewer() {
        return (PaletteViewer)this.getViewer();
    }

    protected PaletteViewerPreferences getPreferenceSource() {
        return ((PaletteViewer)this.getViewer()).getPaletteViewerPreferences();
    }

    protected IFigure getToolTipFigure() {
        return this.getFigure();
    }

    protected String getToolTipText() {
        String text = null;
        PaletteEntry entry = (PaletteEntry)this.getModel();
        String desc = entry.getDescription();
        boolean needName = this.nameNeededInToolTip();
        if (desc == null || desc.trim().equals(entry.getLabel()) || desc.trim().equals("")) {
            if (needName) {
                text = entry.getLabel();
            }
        } else {
            text = needName ? String.valueOf(entry.getLabel()) + " " + PaletteMessages.NAME_DESCRIPTION_SEPARATOR + " " + desc : desc;
        }
        if (text != null && text.trim().equals("")) {
            return null;
        }
        return text;
    }

    protected boolean nameNeededInToolTip() {
        return this.getLayoutSetting() == 2;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String property = evt.getPropertyName();
        if (property.equals("Children Changed")) {
            this.traverseChildren((List)evt.getOldValue(), false);
            this.refreshChildren();
            this.traverseChildren((List)evt.getNewValue(), true);
        } else if (property.equals("Name") || property.equals("Small Icon") || property.equals("Large Icon") || property.equals("Description")) {
            this.refreshVisuals();
        }
    }

    public void restoreState(IMemento memento) {
        Iterator iter = this.getChildren().iterator();
        IMemento[] childMementos = memento.getChildren(XML_NAME);
        int index = 0;
        while (iter.hasNext()) {
            ((PaletteEditPart)iter.next()).restoreState(childMementos[index++]);
        }
    }

    public void saveState(IMemento memento) {
        Iterator iter = this.getChildren().iterator();
        while (iter.hasNext()) {
            ((PaletteEditPart)iter.next()).saveState(memento.createChild(XML_NAME));
        }
    }

    protected void setImageDescriptor(ImageDescriptor desc) {
        if (desc == this.imgDescriptor) {
            return;
        }
        this.imgDescriptor = desc;
        this.setImageInFigure(PaletteEditPart.getImageCache().getImage(this.imgDescriptor));
    }

    protected void setImageInFigure(Image image) {
    }

    private void traverseChildren(PaletteEntry parent, boolean add) {
        if (!(parent instanceof PaletteContainer)) {
            return;
        }
        PaletteContainer container = (PaletteContainer)parent;
        this.traverseChildren(container.getChildren(), add);
    }

    private void traverseChildren(List children, boolean add) {
        for (PaletteEntry entry : children) {
            if (add) {
                entry.addPropertyChangeListener(this.childListener);
                continue;
            }
            entry.removePropertyChangeListener(this.childListener);
        }
    }

    protected int getLayoutSetting() {
        if (this.getParent() instanceof PaletteEditPart) {
            return ((PaletteEditPart)this.getParent()).getLayoutSetting();
        }
        return this.getPreferenceSource().getLayoutSetting();
    }

    @Override
    public boolean isSelectable() {
        return true;
    }

    public boolean isToolbarItem() {
        if (this.getParent() instanceof PaletteEditPart) {
            return ((PaletteEditPart)this.getParent()).isToolbarItem();
        }
        return false;
    }

    protected static class ImageCache {
        private Map images = new HashMap(11);

        protected ImageCache() {
        }

        Image getImage(ImageDescriptor desc) {
            if (desc == null) {
                return null;
            }
            Image img = null;
            Object obj = this.images.get(desc);
            if (obj != null) {
                img = (Image)obj;
            } else {
                img = desc.createImage();
                this.images.put(desc, img);
            }
            return img;
        }

        Image getMissingImage() {
            return this.getImage(ImageDescriptor.getMissingImageDescriptor());
        }

        void dispose() {
            for (Image img : this.images.values()) {
                img.dispose();
            }
            this.images.clear();
        }
    }

    public class SingleSelectionTracker
    extends SelectEditPartTracker {
        public SingleSelectionTracker() {
            super(PaletteEditPart.this);
        }

        @Override
        protected void performSelection() {
            if (this.hasSelectionOccurred()) {
                return;
            }
            this.setFlag(64, true);
            this.getCurrentViewer().select(this.getSourceEditPart());
        }
    }
}

