/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.task;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.runtime.ProxyProgressMonitor;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskExecutionListener;
import org.jkiss.dbeaver.model.task.DBTTaskHandler;
import org.jkiss.dbeaver.model.task.DBTTaskRunStatus;
import org.jkiss.dbeaver.registry.task.TaskImpl;
import org.jkiss.dbeaver.registry.task.TaskManagerImpl;
import org.jkiss.dbeaver.registry.task.TaskRunImpl;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class TaskRunJob
extends AbstractJob
implements DBRRunnableContext {
    private static final Log log = Log.getLog(TaskRunJob.class);
    private static AtomicInteger taskNumber = new AtomicInteger(0);
    private final TaskImpl task;
    private final Locale locale;
    private DBTTaskExecutionListener executionListener;
    private Log taskLog = log;
    private DBRProgressMonitor activeMonitor;
    private long startTime;
    private long elapsedTime;
    private Throwable taskError;

    protected TaskRunJob(TaskImpl task, Locale locale, DBTTaskExecutionListener executionListener) {
        super("Task [" + task.getType().getName() + "] runner - " + task.getName());
        this.setUser(true);
        this.setSystem(false);
        this.task = task;
        this.locale = locale;
        this.executionListener = new LoggingExecutionListener(executionListener);
    }

    protected IStatus run(DBRProgressMonitor monitor) {
        Date startTime = new Date();
        String taskId = String.valueOf(TaskManagerImpl.systemDateFormat.format(startTime)) + "_" + taskNumber.incrementAndGet();
        TaskRunImpl taskRun = new TaskRunImpl(taskId, new Date(), System.getProperty("user.name"), GeneralUtils.getProductTitle(), 0L, null, null);
        this.task.getTaskStatsFolder(true);
        Path logFile = this.task.getRunLog(taskRun);
        this.task.addNewRun(taskRun);
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (PrintStream logStream = new PrintStream(Files.newOutputStream(logFile, new OpenOption[0]), true, StandardCharsets.UTF_8.name());){
                this.taskLog = Log.getLog(TaskRunJob.class);
                Log.setLogWriter((OutputStream)logStream);
                monitor.beginTask("Run task '" + this.task.getName() + " (" + this.task.getType().getName() + ")", 1);
                try {
                    try {
                        DBTTaskRunStatus runResultStatus = this.executeTask((DBRProgressMonitor)new LoggingProgressMonitor(monitor), logStream);
                        taskRun.setExtraMessage(runResultStatus.getResultMessage());
                    }
                    catch (Throwable e) {
                        this.taskError = e;
                        this.taskLog.error((Object)"Task fatal error", e);
                        monitor.done();
                        this.taskLog.flush();
                        Log.setLogWriter(null);
                        taskRun.setRunDuration(this.elapsedTime);
                        if (this.taskError != null) {
                            String errorMessage = this.taskError.getMessage();
                            if (CommonUtils.isEmpty((String)errorMessage)) {
                                errorMessage = this.taskError.getClass().getName();
                            }
                            taskRun.setErrorMessage(errorMessage);
                            StringWriter buf = new StringWriter();
                            this.taskError.printStackTrace(new PrintWriter((Writer)buf, true));
                            taskRun.setErrorStackTrace(buf.toString());
                        }
                        this.task.updateRun(taskRun);
                    }
                }
                finally {
                    monitor.done();
                    this.taskLog.flush();
                    Log.setLogWriter(null);
                    taskRun.setRunDuration(this.elapsedTime);
                    if (this.taskError != null) {
                        String errorMessage = this.taskError.getMessage();
                        if (CommonUtils.isEmpty((String)errorMessage)) {
                            errorMessage = this.taskError.getClass().getName();
                        }
                        taskRun.setErrorMessage(errorMessage);
                        StringWriter buf = new StringWriter();
                        this.taskError.printStackTrace(new PrintWriter((Writer)buf, true));
                        taskRun.setErrorStackTrace(buf.toString());
                    }
                    this.task.updateRun(taskRun);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.error((Object)"Error opning task run log file", (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    private DBTTaskRunStatus executeTask(DBRProgressMonitor monitor, PrintStream logWriter) throws DBException {
        this.activeMonitor = monitor;
        DBTTaskHandler taskHandler = this.task.getType().createHandler();
        return taskHandler.executeTask((DBRRunnableContext)this, (DBTTask)this.task, this.locale, this.taskLog, logWriter, this.executionListener);
    }

    public void run(boolean fork, boolean cancelable, DBRRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        runnable.run(this.activeMonitor);
    }

    private class LoggingExecutionListener
    implements DBTTaskExecutionListener {
        DBTTaskExecutionListener parent;

        public LoggingExecutionListener(DBTTaskExecutionListener src) {
            this.parent = src;
        }

        public void taskStarted(@NotNull Object task) {
            TaskRunJob.this.startTime = System.currentTimeMillis();
            this.parent.taskStarted(task);
        }

        public void taskFinished(@NotNull Object task, @Nullable Object result, @Nullable Throwable error) {
            this.parent.taskFinished(task, result, error);
            TaskRunJob.this.elapsedTime = System.currentTimeMillis() - TaskRunJob.this.startTime;
            TaskRunJob.this.taskError = error;
        }

        public void subTaskFinished(@Nullable Throwable error) {
            this.parent.subTaskFinished(error);
        }
    }

    private class LoggingProgressMonitor
    extends ProxyProgressMonitor {
        public LoggingProgressMonitor(DBRProgressMonitor monitor) {
            super(monitor);
        }

        public void beginTask(String name, int totalWork) {
            super.beginTask(name, totalWork);
            TaskRunJob.this.taskLog.debug((Object)name);
        }

        public void subTask(String name) {
            super.subTask(name);
            TaskRunJob.this.taskLog.debug((Object)("\t" + name));
        }
    }
}

