/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.resources;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.fs.nio.NIOFile;
import org.jkiss.dbeaver.model.fs.nio.NIOFileStore;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNNodeWithResource;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ProgramInfo;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.resources.AbstractResourceHandler;
import org.jkiss.utils.CommonUtils;

public class DefaultResourceHandlerImpl
extends AbstractResourceHandler {
    public static final DefaultResourceHandlerImpl INSTANCE = new DefaultResourceHandlerImpl();

    public int getFeatures(IResource resource) {
        if (resource instanceof IFile) {
            return 11;
        }
        if (resource instanceof IFolder) {
            return 30;
        }
        return super.getFeatures(resource);
    }

    @NotNull
    public String getTypeName(@NotNull IResource resource) {
        ProgramInfo program = ProgramInfo.getProgram((IResource)resource);
        if (program != null) {
            return program.getProgram().getName();
        }
        return "resource";
    }

    public String getResourceDescription(@NotNull IResource resource) {
        return "";
    }

    @NotNull
    public DBNResource makeNavigatorNode(@NotNull DBNNode parentNode, @NotNull IResource resource) throws CoreException, DBException {
        DBNResource node = super.makeNavigatorNode(parentNode, resource);
        this.updateNavigatorNodeFromResource((DBNNodeWithResource)node, resource);
        return node;
    }

    public void updateNavigatorNodeFromResource(@NotNull DBNNodeWithResource node, @NotNull IResource resource) {
        super.updateNavigatorNodeFromResource(node, resource);
        String fileExtension = resource.getFileExtension();
        if (!CommonUtils.isEmpty((String)fileExtension)) {
            this.setNodeIconFromFileType(node, fileExtension);
        }
    }

    public void setNodeIconFromFileType(@NotNull DBNNodeWithResource node, @NotNull String fileExt) {
        ProgramInfo program = ProgramInfo.getProgram((String)fileExt);
        if (program != null && program.getImage() != null) {
            node.setResourceImage(program.getImage());
        }
    }

    public void openResource(@NotNull IResource resource) throws CoreException, DBException {
        if (resource instanceof NIOFile) {
            IEditorDescriptor editorDesc;
            NIOFileStore fileStore = new NIOFileStore(resource.getLocationURI(), ((NIOFile)resource).getNioPath());
            FileStoreEditorInput editorInput = new FileStoreEditorInput((IFileStore)fileStore);
            try {
                editorDesc = IDE.getEditorDescriptor((IFile)((IFile)resource), (boolean)true, (boolean)true);
            }
            catch (OperationCanceledException operationCanceledException) {
                return;
            }
            IDE.openEditor((IWorkbenchPage)UIUtils.getActiveWorkbenchWindow().getActivePage(), (IEditorInput)editorInput, (String)editorDesc.getId());
        } else if (resource instanceof IFile) {
            IDE.openEditor((IWorkbenchPage)UIUtils.getActiveWorkbenchWindow().getActivePage(), (IFile)((IFile)resource));
        } else if (resource instanceof IFolder) {
            DBWorkbench.getPlatformUI().executeShellProgram(resource.getLocation().toOSString());
        }
    }
}

