/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.edit;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.edit.PostgreTableManagerBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreClass;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreMaterializedView;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableColumn;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableContainer;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreView;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreViewBase;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLStructEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class PostgreViewManager
extends PostgreTableManagerBase
implements DBEObjectRenamer<PostgreTableBase> {
    private static final Class<?>[] CHILD_TYPES = new Class[]{PostgreTableColumn.class};

    public Class<?>[] getChildTypes() {
        return CHILD_TYPES;
    }

    @Nullable
    public DBSObjectCache<PostgreTableContainer, PostgreTableBase> getObjectsCache(PostgreTableBase object) {
        return ((PostgreTableContainer)object.getContainer()).getSchema().getTableCache();
    }

    protected void validateObjectProperties(DBRProgressMonitor monitor, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) throws DBException {
        PostgreTableBase object = (PostgreTableBase)command.getObject();
        if (CommonUtils.isEmpty((String)object.getName())) {
            throw new DBException("View name cannot be empty");
        }
    }

    protected String getBaseObjectName() {
        return "NewView";
    }

    protected PostgreViewBase createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) throws DBException {
        PostgreSchema schema = (PostgreSchema)container;
        PostgreView newView = (PostgreView)schema.getDataSource().getServerType().createNewRelation(monitor, schema, PostgreClass.RelKind.v, null);
        this.setNewObjectName(monitor, schema, newView);
        return newView;
    }

    protected void addStructObjectCreateActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLStructEditor.StructCreateCommand command, Map<String, Object> options) throws DBException {
        if (!command.hasProperty((Object)"description") || command.getProperties().size() > 1) {
            this.createOrReplaceViewQuery(monitor, actions, (PostgreViewBase)command.getObject(), options);
        }
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) throws DBException {
        if (!command.hasProperty((Object)"description") || command.getProperties().size() > 1) {
            this.createOrReplaceViewQuery(monitor, actionList, (PostgreViewBase)command.getObject(), options);
        }
    }

    protected void addObjectDeleteActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        PostgreViewBase view = (PostgreViewBase)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop view", "DROP " + view.getTableTypeName() + " " + view.getFullyQualifiedName(DBPEvaluationContext.DDL) + (CommonUtils.getOption(options, (String)"deleteCascade") ? " CASCADE" : "")));
    }

    protected void createOrReplaceViewQuery(DBRProgressMonitor monitor, List<DBEPersistAction> actions, PostgreViewBase view, Map<String, Object> options) throws DBException {
        String sql = view.getSource().trim();
        if (!sql.toLowerCase(Locale.ENGLISH).startsWith("create")) {
            StringBuilder sqlBuf = new StringBuilder();
            sqlBuf.append("CREATE ");
            if (!(view instanceof PostgreMaterializedView)) {
                sqlBuf.append("OR REPLACE ");
            }
            sqlBuf.append(view.getTableTypeName()).append(" ").append(DBUtils.getObjectFullName((DBPNamedObject)view, (DBPEvaluationContext)DBPEvaluationContext.DDL));
            this.appendViewDeclarationPrefix(monitor, sqlBuf, view);
            sqlBuf.append("\nAS ").append(sql);
            this.appendViewDeclarationPostfix(monitor, sqlBuf, view);
            sql = sqlBuf.toString();
        }
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create view", sql));
    }

    public void appendViewDeclarationPrefix(DBRProgressMonitor monitor, StringBuilder sqlBuf, PostgreViewBase view) throws DBException {
        Object[] relOptions = view.getRelOptions();
        if (!ArrayUtils.isEmpty((Object[])relOptions)) {
            sqlBuf.append("\nWITH(").append(String.join((CharSequence)",", (CharSequence[])relOptions)).append(")");
        }
    }

    public void appendViewDeclarationPostfix(DBRProgressMonitor monitor, StringBuilder sqlBuf, PostgreViewBase view) {
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull PostgreTableBase object, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        this.processObjectRename(commandContext, object, options, newName);
    }

    protected void addObjectRenameActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        PostgreViewBase view = (PostgreViewBase)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename view", "ALTER " + view.getTableTypeName() + " " + DBUtils.getQuotedIdentifier((DBSObject)view.getSchema()) + "." + DBUtils.getQuotedIdentifier((DBPDataSource)view.getDataSource(), (String)command.getOldName()) + " RENAME TO " + DBUtils.getQuotedIdentifier((DBPDataSource)view.getDataSource(), (String)command.getNewName())));
    }

    @Override
    protected void addObjectExtraActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.NestedObjectCommand<PostgreTableBase, SQLObjectEditor.PropertyHandler> command, Map<String, Object> options) {
        PostgreViewBase viewBase = (PostgreViewBase)command.getObject();
        if (command.hasProperty((Object)"description")) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Comment view", "COMMENT ON " + viewBase.getTableTypeName() + " " + viewBase.getFullyQualifiedName(DBPEvaluationContext.DDL) + " IS " + SQLUtils.quoteString((DBSObject)viewBase, (String)CommonUtils.notEmpty((String)viewBase.getDescription()))));
        }
    }
}

