/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.editors;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ModelPreferences;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomTimeEditor;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.dialogs.ValueViewDialog;

public class DateTimeStandaloneEditor
extends ValueViewDialog {
    private CustomTimeEditor timeEditor;
    private boolean dirty;
    private IValueController valueController;

    public DateTimeStandaloneEditor(IValueController valueController) {
        super(valueController);
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        this.valueController = this.getValueController();
        Object value = this.valueController.getValue();
        Composite dialogGroup = (Composite)super.createDialogArea(parent);
        Composite panel = UIUtils.createComposite((Composite)dialogGroup, (int)3);
        panel.setLayoutData((Object)new GridData(768));
        int style = 0;
        if (this.valueController.isReadOnly()) {
            style |= 8;
        }
        this.timeEditor = new CustomTimeEditor(panel, style, false, false);
        this.timeEditor.getControl().addListener(24, event -> {
            boolean bl = this.dirty = true;
        });
        GridData gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.timeEditor.getControl().setLayoutData((Object)gd);
        this.timeEditor.createDateFormat(this.valueController.getValueType());
        if (!ModelPreferences.getPreferences().getBoolean("resultset.datetime.editor")) {
            this.timeEditor.setToTextComposite();
        }
        this.primeEditorValue(value);
        Button button = UIUtils.createPushButton((Composite)panel, (String)"Set Current", null);
        button.setEnabled(!this.valueController.isReadOnly());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DateTimeStandaloneEditor.this.primeEditorValue(new Date());
            }
        });
        return dialogGroup;
    }

    private boolean isCalendarMode() {
        return ModelPreferences.getPreferences().getBoolean("resultset.datetime.editor");
    }

    @Override
    public Object extractEditorValue() throws DBException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (DBCSession session = this.getValueController().getExecutionContext().openSession((DBRProgressMonitor)new VoidProgressMonitor(), DBCExecutionPurpose.UTIL, "Make datetime value from editor");){
            if (!this.isCalendarMode()) {
                String strValue = this.timeEditor.getValueAsString();
                return this.valueController.getValueHandler().getValueFromObject(session, this.valueController.getValueType(), (Object)strValue, false, true);
            }
            Date dateValue = this.timeEditor.getValueAsDate();
            return this.valueController.getValueHandler().getValueFromObject(session, this.valueController.getValueType(), (Object)dateValue, false, true);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void primeEditorValue(@Nullable Object value) {
        this.timeEditor.setTextValue(this.valueController.getValueHandler().getValueDisplayString(this.valueController.getValueType(), value, DBDDisplayFormat.EDIT));
        if (value instanceof Time) {
            this.timeEditor.setValue((Date)((Time)value));
        } else if (value instanceof Timestamp) {
            this.timeEditor.setValue((Date)((Timestamp)value));
        } else if (value instanceof Date) {
            this.timeEditor.setValue((Date)value);
        }
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public Control getControl() {
        return null;
    }
}

