/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.snowflake.ui.config;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.jkiss.dbeaver.ext.snowflake.ui.internal.SnowflakeMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.DatabaseNativeAuthModelConfigurator;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;
import org.jkiss.utils.CommonUtils;

public class SnowflakeAuthSnowflakeConfigurator
extends DatabaseNativeAuthModelConfigurator {
    private Combo userRoleCombo;

    public void createControl(Composite parent, Runnable propertyChangeListener) {
        this.usernameLabel = UIUtils.createLabel((Composite)parent, (String)UIConnectionMessages.dialog_connection_auth_label_username);
        this.usernameLabel.setLayoutData((Object)new GridData(32));
        this.createUserNameControls(parent, propertyChangeListener);
        if (this.supportsPassword()) {
            this.createPasswordControls(parent, propertyChangeListener);
        }
        Label userRoleLabel = UIUtils.createControlLabel((Composite)parent, (String)SnowflakeMessages.label_role);
        userRoleLabel.setLayoutData((Object)new GridData(32));
        this.userRoleCombo = new Combo(parent, 4);
        GridData gd = new GridData(2);
        gd.widthHint = UIUtils.getFontHeight((Control)this.userRoleCombo) * 10;
        this.userRoleCombo.setLayoutData((Object)gd);
        this.userRoleCombo.select(0);
    }

    public void loadSettings(DBPDataSourceContainer dataSource) {
        super.loadSettings(dataSource);
        String roleName = dataSource.getConnectionConfiguration().getAuthProperty("role");
        if (roleName != null) {
            this.userRoleCombo.setText(roleName);
        }
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        super.saveSettings(dataSource);
        String roleName = this.userRoleCombo.getText();
        if (!CommonUtils.isEmpty((String)roleName)) {
            dataSource.getConnectionConfiguration().setAuthProperty("role", roleName);
        }
        dataSource.getConnectionConfiguration().removeProviderProperty("@dbeaver-authenticator@");
        dataSource.getConnectionConfiguration().removeProviderProperty("@dbeaver-role@");
    }

    public void resetSettings(DBPDataSourceContainer dataSource) {
        super.resetSettings(dataSource);
    }

    protected boolean supportsPassword() {
        return true;
    }
}

