/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.model.DBPKeywordType;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCSQLDialect;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class ExasolSQLDialect
extends JDBCSQLDialect {
    private static final Log LOG = Log.getLog(ExasolDataSource.class);
    public static final String[] EXEC_KEYWORDS = new String[0];
    private static final String[] ADVANCED_FUNCTIONS = new String[]{"BIT_AND", "BIT_CHECK", "BIT_LENGTH", "BIT_NOT", "BIT_OR", "BIT_SET", "BIT_TO_NUM", "CONVERT_TZ", "DATE_TRUNC", "DECODE", "EDIT_DISTANCE", "GROUPING_ID", "HASH_MD5", "HASH_SHA", "HASH_TIGER", "HASHTYPE_MD5", "HASHTYPE_SHA", "HASHTYPE_TIGER", "IS_DATE", "IS_TIMESTAMP", "IS_BOOLEAN", "IS_DSINTERVAL", "IS_YMINTERVAL", "JSON_EXTRACT", "JSON_VALUE", "LAG", "LAST_VALUE", "LEAD", "LISTAGG", "MUL", "NTILE", "NULLIFZERO", "NVL", "RATIO_TO_REPORT", "REGR_FUNCTIONS", "ROWNUM", "ROWID", "SESSION_PARAMETER", "ST_BOUNDARY", "ST_BUFFER", "ST_CENTROID", "ST_CONTAINS", "ST_CONVEXHULL", "ST_CROSSES", "ST_DIFFERENCE", "ST_DIMENSION", "ST_DISJOINT", "ST_DISTANCE", "ST_ENDPOINT", "ST_ENVELOPE", "ST_EQUALS", "ST_EXTERIORRING", "ST_FORCE2D", "ST_GEOMETRYN", "ST_GEOMETRYTYPE", "ST_ISEMPTY", "ST_ISRING", "ST_ISSIMPLE", "ST_LENGTH", "ST_MAX_DECIMAL_DIGITS", "ST_NUMGEOMETRIES", "ST_NUMINTERIORRINGS", "ST_NUMPOINTS", "ST_OVERLAPS", "ST_POINTN", "ST_SETSRID", "ST_STARTPOINT", "ST_SYMDIFFERENCE", "ST_TOUCHES", "ST_TRANSFORM", "ST_UNION", "ST_WITHIN", "ST_X", "ST_Y", "SYS_CONNECT_BY_PATH", "SYS_GUID", "ZEROIFNULL"};

    public ExasolSQLDialect() {
        super("Exasol", "exasol");
    }

    private void addExtraFunctions(String ... functions) {
        super.addFunctions(Arrays.asList(functions));
    }

    public void initDriverSettings(JDBCSession session, JDBCDataSource dataSource, JDBCDatabaseMetaData metaData) {
        super.initDriverSettings(session, dataSource, metaData);
        Collections.addAll(this.tableQueryWords, "DESC");
        this.addFunctions(Arrays.asList(ADVANCED_FUNCTIONS));
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (JDBCStatement stmt = session.createStatement();){
                String keyWord;
                JDBCResultSet dbResult;
                Throwable throwable2 = null;
                Object var8_12 = null;
                try {
                    dbResult = stmt.executeQuery("/*snapshot execution*/ SELECT \"VALUE\" FROM \"$ODBCJDBC\".DB_METADATA WHERE name = 'aggregateFunctions'");
                    try {
                        if (dbResult != null && dbResult.next()) {
                            keyWord = dbResult.getString(1);
                            String[] aggregateFunctions = keyWord.split(",");
                            this.addExtraFunctions(aggregateFunctions);
                        }
                    }
                    finally {
                        if (dbResult != null) {
                            dbResult.close();
                        }
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
                throwable2 = null;
                var8_12 = null;
                try {
                    dbResult = stmt.executeQuery("/*snapshot execution*/ SELECT keyword FROM sys.EXA_SQL_KEYWORDS esk WHERE RESERVED");
                    try {
                        while (dbResult != null && dbResult.next()) {
                            keyWord = dbResult.getString("KEYWORD");
                            super.addSQLKeyword(keyWord);
                        }
                    }
                    finally {
                        if (dbResult != null) {
                            dbResult.close();
                        }
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable2 == null) {
                        throwable2 = throwable4;
                    } else if (throwable2 != throwable4) {
                        throwable2.addSuppressed(throwable4);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (SQLException sQLException) {
            LOG.warn((Object)"Could not retrieve functions list from Exasol dictionary");
        }
        ArrayList<String> value = new ArrayList<String>(){
            {
                this.add("KERBEROS");
                this.add("JDBC");
                this.add("BYTE");
                this.add("BIT");
                this.add("PRECEDENCE");
                this.add("GROUP_TEMP_DB_RAM_LIMIT");
                this.add("USER_TEMP_DB_RAM_LIMIT");
                this.add("SESSION_TEMP_DB_RAM_LIMIT");
                this.add("CPU_WEIGHT");
            }
        };
        this.addKeywords(value, DBPKeywordType.KEYWORD);
    }

    @NotNull
    public SQLDialect.MultiValueInsertMode getDefaultMultiValueInsertMode() {
        return SQLDialect.MultiValueInsertMode.GROUP_ROWS;
    }

    public boolean supportsAliasInSelect() {
        return true;
    }

    @NotNull
    public String[] getExecuteKeywords() {
        return new String[]{"EXECUTE SCRIPT"};
    }

    @NotNull
    public String escapeScriptValue(DBSTypedObject attribute, @NotNull Object value, @NotNull String strValue) {
        return super.escapeScriptValue(attribute, value, strValue);
    }

    public boolean supportsInsertAllDefaultValuesStatement() {
        return true;
    }
}

